/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.zzc;
import java.util.Arrays;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new zza();
    private final String zzbal;
    private final String zzalR;
    private final Uri zzaXY;
    private final Uri zzaXZ;
    private final int zzLj;
    private final String zzbdB;
    private final boolean zzbdC;
    private final PlayerEntity zzaZm;
    private final int zzapk;
    private final ParticipantResult zzbdD;
    private final String zzaYj;
    private final String zzaYk;

    public ParticipantEntity(Participant participant) {
        this.zzbal = participant.getParticipantId();
        this.zzalR = participant.getDisplayName();
        this.zzaXY = participant.getIconImageUri();
        this.zzaXZ = participant.getHiResImageUri();
        this.zzLj = participant.getStatus();
        this.zzbdB = participant.zzvq();
        this.zzbdC = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaZm = player == null ? null : new PlayerEntity(player);
        this.zzapk = participant.getCapabilities();
        this.zzbdD = participant.getResult();
        this.zzaYj = participant.getIconImageUrl();
        this.zzaYk = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zzbal = string;
        this.zzalR = string2;
        this.zzaXY = uri;
        this.zzaXZ = uri2;
        this.zzLj = n;
        this.zzbdB = string3;
        this.zzbdC = bl;
        this.zzaZm = playerEntity;
        this.zzapk = n2;
        this.zzbdD = participantResult;
        this.zzaYj = string4;
        this.zzaYk = string5;
    }

    @Override
    public final int getStatus() {
        return this.zzLj;
    }

    @Override
    public final String zzvq() {
        return this.zzbdB;
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzbdC;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzaZm == null) {
            return this.zzalR;
        }
        return this.zzaZm.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzaZm == null) {
            zzi.zzb((String)this.zzalR, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzaZm.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzaZm == null) {
            return this.zzaXY;
        }
        return this.zzaZm.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzaZm == null) {
            return this.zzaYj;
        }
        return this.zzaZm.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzaZm == null) {
            return this.zzaXZ;
        }
        return this.zzaZm.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzaZm == null) {
            return this.zzaYk;
        }
        return this.zzaZm.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zzbal;
    }

    @Override
    public final Player getPlayer() {
        return this.zzaZm;
    }

    @Override
    public final ParticipantResult getResult() {
        return this.zzbdD;
    }

    @Override
    public final int getCapabilities() {
        return this.zzapk;
    }

    public final Participant freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return Arrays.hashCode(new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzvq(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzbh.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzbh.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzbh.equal((Object)participant2.zzvq(), (Object)participant.zzvq()) && zzbh.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzbh.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzbh.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzbh.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzbh.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzbh.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzbh.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzbh.zzt((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzvq()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ParticipantEntity participantEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)participantEntity.getParticipantId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)participantEntity.getDisplayName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)participantEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)participantEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)participantEntity.getStatus());
        zzd.zza((Parcel)parcel2, (int)6, (String)participantEntity.zzbdB, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)participantEntity.isConnectedToRoom());
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)participantEntity.getPlayer(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)participantEntity.zzapk);
        zzd.zza((Parcel)parcel2, (int)10, (Parcelable)participantEntity.getResult(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)11, (String)participantEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)participantEntity.getHiResImageUrl(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzc {
        zza() {
        }

        @Override
        public final ParticipantEntity zzi(Parcel parcel) {
            if (ParticipantEntity.zze(ParticipantEntity.zzrv()) || ParticipantEntity.zzcA((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzi(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl = parcel.readInt() > 0;
            PlayerEntity playerEntity = parcel.readInt() > 0 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl, playerEntity, 7, null, null, null);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzi(parcel);
        }
    }
}

