/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.zzc;
import com.google.android.gms.games.multiplayer.realtime.zzd;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class RoomConfig {
    protected RoomConfig() {
    }

    public abstract RoomUpdateListener getRoomUpdateListener();

    public abstract String getInvitationId();

    public abstract RoomStatusUpdateListener getRoomStatusUpdateListener();

    public abstract RealTimeMessageReceivedListener getMessageReceivedListener();

    public abstract int getVariant();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder(RoomUpdateListener roomUpdateListener) {
        return new Builder(roomUpdateListener, null);
    }

    public static Bundle createAutoMatchCriteria(int n, int n2, long l) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", n);
        bundle.putInt("max_automatch_players", n2);
        bundle.putLong("exclusive_bit_mask", l);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener zzbdK;
        RoomStatusUpdateListener zzbdL;
        RealTimeMessageReceivedListener zzbdM;
        String zzbdN = null;
        int zzbdy = -1;
        ArrayList<String> zzbdO = new ArrayList();
        Bundle zzbdP;

        private Builder(RoomUpdateListener roomUpdateListener) {
            this.zzbdK = (RoomUpdateListener)zzbr.zzb((Object)roomUpdateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public final Builder setInvitationIdToAccept(String string) {
            zzbr.zzu((Object)string);
            this.zzbdN = string;
            return this;
        }

        public final Builder setRoomStatusUpdateListener(RoomStatusUpdateListener roomStatusUpdateListener) {
            this.zzbdL = roomStatusUpdateListener;
            return this;
        }

        public final Builder setMessageReceivedListener(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.zzbdM = realTimeMessageReceivedListener;
            return this;
        }

        public final Builder addPlayersToInvite(String ... stringArray) {
            zzbr.zzu((Object)stringArray);
            this.zzbdO.addAll(Arrays.asList(stringArray));
            return this;
        }

        public final Builder addPlayersToInvite(ArrayList<String> arrayList) {
            zzbr.zzu(arrayList);
            this.zzbdO.addAll(arrayList);
            return this;
        }

        public final Builder setVariant(int n) {
            zzbr.zzb((n == -1 || n > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.zzbdy = n;
            return this;
        }

        public final Builder setAutoMatchCriteria(Bundle bundle) {
            this.zzbdP = bundle;
            return this;
        }

        public final RoomConfig build() {
            return new zzd(this);
        }

        /* synthetic */ Builder(RoomUpdateListener roomUpdateListener, zzc zzc2) {
            this(roomUpdateListener);
        }
    }
}

