/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class QuestEntity
extends com.google.android.gms.games.internal.zzc
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new zzc();
    private final GameEntity zzbbR;
    private final String zzbem;
    private final long zzben;
    private final Uri zzbeo;
    private final String zzbep;
    private final String zzafc;
    private final long zzbeq;
    private final long zzaZp;
    private final Uri zzber;
    private final String zzbes;
    private final String mName;
    private final long zzbet;
    private final long zzbeu;
    private final int mState;
    private final int zzamt;
    private final ArrayList<MilestoneEntity> zzbev;

    public QuestEntity(Quest quest) {
        this.zzbbR = new GameEntity(quest.getGame());
        this.zzbem = quest.getQuestId();
        this.zzben = quest.getAcceptedTimestamp();
        this.zzafc = quest.getDescription();
        this.zzbeo = quest.getBannerImageUri();
        this.zzbep = quest.getBannerImageUrl();
        this.zzbeq = quest.getEndTimestamp();
        this.zzber = quest.getIconImageUri();
        this.zzbes = quest.getIconImageUrl();
        this.zzaZp = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzbet = quest.zzvt();
        this.zzbeu = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzamt = quest.getType();
        List<Milestone> list = quest.zzvs();
        int n = list.size();
        this.zzbev = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbev.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n, int n2, ArrayList<MilestoneEntity> arrayList) {
        this.zzbbR = gameEntity;
        this.zzbem = string;
        this.zzben = l;
        this.zzbeo = uri;
        this.zzbep = string2;
        this.zzafc = string3;
        this.zzbeq = l2;
        this.zzaZp = l3;
        this.zzber = uri2;
        this.zzbes = string4;
        this.mName = string5;
        this.zzbet = l4;
        this.zzbeu = l5;
        this.mState = n;
        this.zzamt = n2;
        this.zzbev = arrayList;
    }

    @Override
    public final String getQuestId() {
        return this.zzbem;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzafc;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.zzafc, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzber;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzbes;
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzbeo;
    }

    @Override
    public final String getBannerImageUrl() {
        return this.zzbep;
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzvs().get(0);
    }

    @Override
    public final List<Milestone> zzvs() {
        return new ArrayList<Milestone>(this.zzbev);
    }

    @Override
    public final Game getGame() {
        return this.zzbbR;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getType() {
        return this.zzamt;
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.zzben;
    }

    @Override
    public final long getEndTimestamp() {
        return this.zzbeq;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzaZp;
    }

    @Override
    public final long zzvt() {
        return this.zzbet;
    }

    @Override
    public final long getStartTimestamp() {
        return this.zzbeu;
    }

    @Override
    public final boolean isEndingSoon() {
        return this.zzbet <= System.currentTimeMillis() + 1800000L;
    }

    public final Quest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return Arrays.hashCode(new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzvs(), quest.getName(), quest.zzvt(), quest.getStartTimestamp(), quest.getState()});
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzbh.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzbh.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzbh.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzbh.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzbh.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzbh.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzbh.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzbh.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzbh.equal(quest2.zzvs(), quest.zzvs()) && zzbh.equal((Object)quest2.getName(), (Object)quest.getName()) && zzbh.equal((Object)quest2.zzvt(), (Object)quest.zzvt()) && zzbh.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzbh.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzbh.zzt((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzvs()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzvt()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        QuestEntity questEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)questEntity.getGame(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)questEntity.getQuestId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)questEntity.getAcceptedTimestamp());
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)questEntity.getBannerImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)questEntity.getBannerImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)questEntity.getDescription(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (long)questEntity.getEndTimestamp());
        zzd.zza((Parcel)parcel2, (int)8, (long)questEntity.getLastUpdatedTimestamp());
        zzd.zza((Parcel)parcel2, (int)9, (Parcelable)questEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)10, (String)questEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)questEntity.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)13, (long)questEntity.zzbet);
        zzd.zza((Parcel)parcel2, (int)14, (long)questEntity.getStartTimestamp());
        zzd.zzc((Parcel)parcel2, (int)15, (int)questEntity.getState());
        zzd.zzc((Parcel)parcel2, (int)16, (int)questEntity.zzamt);
        zzd.zzc((Parcel)parcel2, (int)17, questEntity.zzvs(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

