/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.zza;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class GameRequestEntity
extends zzc
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new zza();
    private final GameEntity zzbbR;
    private final PlayerEntity zzbew;
    private final byte[] zzbec;
    private final String zzQz;
    private final ArrayList<PlayerEntity> zzbex;
    private final int zzamt;
    private final long mCreationTimestamp;
    private final long zzbey;
    private final Bundle zzbez;
    private final int zzLj;

    public GameRequestEntity(GameRequest gameRequest) {
        this.zzbbR = new GameEntity(gameRequest.getGame());
        this.zzbew = new PlayerEntity(gameRequest.getSender());
        this.zzQz = gameRequest.getRequestId();
        this.zzamt = gameRequest.getType();
        this.mCreationTimestamp = gameRequest.getCreationTimestamp();
        this.zzbey = gameRequest.getExpirationTimestamp();
        this.zzLj = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzbec = null;
        } else {
            this.zzbec = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbec, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzbex = new ArrayList(n);
        this.zzbez = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzbex.add((PlayerEntity)player);
            this.zzbez.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zzbbR = gameEntity;
        this.zzbew = playerEntity;
        this.zzbec = byArray;
        this.zzQz = string;
        this.zzbex = arrayList;
        this.zzamt = n;
        this.mCreationTimestamp = l;
        this.zzbey = l2;
        this.zzbez = bundle;
        this.zzLj = n2;
    }

    @Override
    public final String getRequestId() {
        return this.zzQz;
    }

    @Override
    public final Game getGame() {
        return this.zzbbR;
    }

    @Override
    public final Player getSender() {
        return this.zzbew;
    }

    @Override
    public final List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzbex);
    }

    @Override
    public final boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public final byte[] getData() {
        return this.zzbec;
    }

    @Override
    public final int getType() {
        return this.zzamt;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final long getExpirationTimestamp() {
        return this.zzbey;
    }

    @Override
    public final int getRecipientStatus(String string) {
        return this.zzbez.getInt(string, 0);
    }

    @Override
    public final int getStatus() {
        return this.zzLj;
    }

    public final GameRequest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return Arrays.hashCode(new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public final boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzbh.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzbh.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzbh.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzbh.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzbh.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzbh.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzbh.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public final String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzbh.zzt((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameRequestEntity gameRequestEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)gameRequestEntity.getGame(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)gameRequestEntity.getSender(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (byte[])gameRequestEntity.getData(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)gameRequestEntity.getRequestId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, gameRequestEntity.getRecipients(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)gameRequestEntity.getType());
        zzd.zza((Parcel)parcel2, (int)9, (long)gameRequestEntity.getCreationTimestamp());
        zzd.zza((Parcel)parcel2, (int)10, (long)gameRequestEntity.getExpirationTimestamp());
        zzd.zza((Parcel)parcel2, (int)11, (Bundle)gameRequestEntity.zzbez, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)12, (int)gameRequestEntity.getStatus());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

