/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.zza;
import java.util.Arrays;

public final class VideoCapabilities
extends zzc {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new zza();
    private final boolean zzbfh;
    private final boolean zzbfi;
    private final boolean zzbfj;
    private final boolean[] zzbfk;
    private final boolean[] zzbfl;

    public VideoCapabilities(boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.zzbfh = bl;
        this.zzbfi = bl2;
        this.zzbfj = bl3;
        this.zzbfk = blArray;
        this.zzbfl = blArray2;
    }

    public final boolean isMicSupported() {
        return this.zzbfi;
    }

    public final boolean isCameraSupported() {
        return this.zzbfh;
    }

    public final boolean isWriteStorageSupported() {
        return this.zzbfj;
    }

    public final boolean[] getSupportedCaptureModes() {
        return this.zzbfk;
    }

    public final boolean[] getSupportedQualityLevels() {
        return this.zzbfl;
    }

    public final boolean supportsCaptureMode(int n) {
        zzbr.zzae((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzbfk[n];
    }

    public final boolean supportsQualityLevel(int n) {
        zzbr.zzae((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zzbfl[n];
    }

    public final boolean isFullySupported(int n, int n2) {
        return this.zzbfh && this.zzbfi && this.zzbfj && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzbh.equal((Object)videoCapabilities.getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && zzbh.equal((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && zzbh.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzbh.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzbh.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public final String toString() {
        return zzbh.zzt((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).zzg("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoCapabilities videoCapabilities = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (boolean)videoCapabilities.isCameraSupported());
        zzd.zza((Parcel)parcel2, (int)2, (boolean)videoCapabilities.isMicSupported());
        zzd.zza((Parcel)parcel2, (int)3, (boolean)videoCapabilities.isWriteStorageSupported());
        zzd.zza((Parcel)parcel2, (int)4, (boolean[])videoCapabilities.getSupportedCaptureModes(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (boolean[])videoCapabilities.getSupportedQualityLevels(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

