/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.games.video.zzb;

public final class VideoConfiguration
extends zza {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zzbfm;
    private final int zzbff;
    private final String zzbfn;
    private final String zzbfo;
    private final String zzbfp;
    private final String zzbfq;
    private final boolean zzbfr;

    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbr.zzaf((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbr.zzaf((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zzbfm = n;
        this.zzbff = n2;
        this.zzbfr = bl;
        if (n2 == 1) {
            this.zzbfo = string2;
            this.zzbfn = string;
            this.zzbfp = string3;
            this.zzbfq = string4;
            return;
        }
        zzbr.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbr.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbr.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbr.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zzbfo = null;
        this.zzbfn = null;
        this.zzbfp = null;
        this.zzbfq = null;
    }

    public final int getQualityLevel() {
        return this.zzbfm;
    }

    public final int getCaptureMode() {
        return this.zzbff;
    }

    public final String getStreamUrl() {
        return this.zzbfn;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzd.zzc((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzd.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zzbfo, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zzbfp, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zzbfq, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzbfr);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzbfm;
        private int zzbff;
        private boolean zzbfr;
        private String zzbfn;
        private String zzbfo;
        private String zzbfp;
        private String zzbfq;

        public Builder(int n, int n2) {
            this.zzbfm = n;
            this.zzbff = n2;
            this.zzbfr = true;
            this.zzbfn = null;
            this.zzbfo = null;
            this.zzbfp = null;
            this.zzbfq = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zzbfm = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zzbff = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zzbfm, this.zzbff, null, null, null, null, this.zzbfr);
        }
    }
}

