/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.zzab;
import com.google.android.gms.games.internal.api.zzaf;
import com.google.android.gms.games.internal.api.zzav;
import com.google.android.gms.games.internal.api.zzaw;
import com.google.android.gms.games.internal.api.zzax;
import com.google.android.gms.games.internal.api.zzbh;
import com.google.android.gms.games.internal.api.zzbs;
import com.google.android.gms.games.internal.api.zzbt;
import com.google.android.gms.games.internal.api.zzcb;
import com.google.android.gms.games.internal.api.zzcp;
import com.google.android.gms.games.internal.api.zzcq;
import com.google.android.gms.games.internal.api.zzcu;
import com.google.android.gms.games.internal.api.zzdr;
import com.google.android.gms.games.internal.api.zzo;
import com.google.android.gms.games.internal.api.zzp;
import com.google.android.gms.games.internal.api.zzx;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.games.zze;
import com.google.android.gms.games.zzf;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzcag;
import com.google.android.gms.internal.zzcao;
import java.util.ArrayList;

@KeepForSdk
public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzf<GamesClientImpl> zzajR = new Api.zzf();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzajS = new com.google.android.gms.games.zzb();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzaYm = new com.google.android.gms.games.zzc();
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    private static Scope zzaYn = new Scope("https://www.googleapis.com/auth/games_lite");
    public static final Api<GamesOptions> API = new Api("Games.API", zzajS, zzajR);
    public static final Scope zzaYo = new Scope("https://www.googleapis.com/auth/games.firstparty");
    private static Api<GamesOptions> zzaYp = new Api("Games.API_1P", zzaYm, zzajR);
    public static final GamesMetadata GamesMetadata = new zzx();
    public static final Achievements Achievements = new com.google.android.gms.games.internal.api.zza();
    private static zzcag zzaYq = new zzo();
    public static final Events Events = new zzp();
    public static final Leaderboards Leaderboards = new zzaf();
    public static final Invitations Invitations = new zzab();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new zzcu();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new zzbs();
    private static Multiplayer zzaYr = new zzav();
    public static final Players Players = new zzax();
    public static final Notifications Notifications = new zzaw();
    public static final Quests Quests = new zzbh();
    public static final Requests Requests = new zzbt();
    public static final Snapshots Snapshots = new zzcb();
    public static final Stats Stats = new zzcq();
    public static final Videos Videos = new zzdr();
    private static zzcao zzaYs = new zzcp();

    private Games() {
    }

    public static GamesClientImpl zzf(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true);
    }

    public static GamesClientImpl zza(GoogleApiClient googleApiClient, boolean bl) {
        zzbo.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzbo.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzb(googleApiClient, bl);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzbo.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        if (bl2) {
            return (GamesClientImpl)googleApiClient.zza(zzajR);
        }
        return null;
    }

    public static void setGravityForPopups(GoogleApiClient googleApiClient, int n) {
        GamesClientImpl gamesClientImpl = Games.zza(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzaZ(n);
        }
    }

    public static void setViewForPopups(GoogleApiClient googleApiClient, View view) {
        zzbo.zzu((Object)view);
        GamesClientImpl gamesClientImpl = Games.zza(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzs(view);
        }
    }

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public static String getCurrentAccountName(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzus();
    }

    @Deprecated
    @KeepForSdk
    public static PendingResult<GetServerAuthCodeResult> getGamesServerAuthCode(GoogleApiClient googleApiClient, String string) {
        zzbo.zzh((String)string, (Object)"Please provide a valid serverClientId");
        return googleApiClient.zze((zzbax)new com.google.android.gms.games.zzd(googleApiClient, string));
    }

    public static String getAppId(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzhl();
    }

    public static Intent getSettingsIntent(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzuE();
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzbax)new zze(googleApiClient));
    }

    public static int getSdkVariant(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzuF();
    }

    static abstract class zzd
    extends zza<Status> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public final /* synthetic */ Result zzb(Status status) {
            return status;
        }

        /* synthetic */ zzd(GoogleApiClient googleApiClient, com.google.android.gms.games.zzb zzb2) {
            this(googleApiClient);
        }
    }

    static abstract class zzc
    extends zza<GetServerAuthCodeResult> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzc zzc2 = this;
            return new zzf(zzc2, status2);
        }

        /* synthetic */ zzc(GoogleApiClient googleApiClient, com.google.android.gms.games.zzb zzb2) {
            this(googleApiClient);
        }
    }

    @Deprecated
    @KeepForSdk
    public static interface GetServerAuthCodeResult
    extends Result {
        @KeepForSdk
        public String getCode();
    }

    public static abstract class zza<R extends Result>
    extends zzbax<R, GamesClientImpl> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzajR, googleApiClient);
        }
    }

    static abstract class zzb
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private zzb() {
        }

        public final int getPriority() {
            return 1;
        }

        public final /* synthetic */ Api.zze zza(Context context, Looper looper, zzq zzq2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
            GamesOptions gamesOptions = (GamesOptions)object;
            zzq zzq3 = zzq2;
            Looper looper2 = looper;
            Context context2 = context;
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions.Builder(null).build();
            }
            return new GamesClientImpl(context2, looper2, zzq3, gamesOptions, connectionCallbacks2, onConnectionFailedListener2);
        }

        /* synthetic */ zzb(com.google.android.gms.games.zzb zzb2) {
            this();
        }
    }

    public static final class GamesOptions
    implements GoogleSignInOptionsExtension,
    Api.ApiOptions.Optional {
        public final boolean zzaYu;
        private boolean zzaYv;
        private int zzaYw;
        private boolean zzaYx;
        private int zzaYy;
        private String zzaYz;
        private ArrayList<String> zzaYA;
        private boolean zzaYB;
        public final boolean zzaYC;
        private boolean zzaYD;

        private GamesOptions(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList<String> arrayList, boolean bl4, boolean bl5, boolean bl6) {
            this.zzaYu = bl;
            this.zzaYv = bl2;
            this.zzaYw = n;
            this.zzaYx = bl3;
            this.zzaYy = n2;
            this.zzaYz = string;
            this.zzaYA = arrayList;
            this.zzaYB = bl4;
            this.zzaYC = bl5;
            this.zzaYD = bl6;
        }

        public final Bundle toBundle() {
            return this.zzui();
        }

        public final Bundle zzui() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.zzaYu);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.zzaYv);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.zzaYw);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.zzaYx);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.zzaYy);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.zzaYz);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.zzaYA);
            bundle.putBoolean("com.google.android.gms.games.key.requireGooglePlus", this.zzaYB);
            bundle.putBoolean("com.google.android.gms.games.key.unauthenticated", this.zzaYC);
            bundle.putBoolean("com.google.android.gms.games.key.skipWelcomePopup", this.zzaYD);
            return bundle;
        }

        public static Builder builder() {
            return new Builder(null);
        }

        /* synthetic */ GamesOptions(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList arrayList, boolean bl4, boolean bl5, boolean bl6, com.google.android.gms.games.zzb zzb2) {
            this(false, bl2, n, false, n2, null, arrayList, false, false, false);
        }

        public static final class Builder {
            private boolean zzaYu = false;
            private boolean zzaYv = true;
            private int zzaYw = 17;
            private boolean zzaYx = false;
            private int zzaYy = 4368;
            private String zzaYz = null;
            private ArrayList<String> zzaYA = new ArrayList();
            private boolean zzaYB = false;
            private boolean zzaYC = false;
            private boolean zzaYD = false;

            private Builder() {
            }

            public final Builder setShowConnectingPopup(boolean bl) {
                this.zzaYv = bl;
                this.zzaYw = 17;
                return this;
            }

            public final Builder setShowConnectingPopup(boolean bl, int n) {
                this.zzaYv = bl;
                this.zzaYw = n;
                return this;
            }

            public final Builder setSdkVariant(int n) {
                this.zzaYy = n;
                return this;
            }

            public final GamesOptions build() {
                return new GamesOptions(false, this.zzaYv, this.zzaYw, false, this.zzaYy, null, this.zzaYA, false, false, false, null);
            }

            /* synthetic */ Builder(com.google.android.gms.games.zzb zzb2) {
                this();
            }
        }
    }
}

