/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzbcR;
    private final String zzbcS;
    private final String zzbcT;
    private final long zzbcU;
    private final long zzbcV;
    private final String zzbcW;
    private final Uri zzbcX;
    private final Uri zzbcY;
    private final PlayerEntity zzbcZ;
    private final String zzbda;
    private final String zzbdb;
    private final String zzbdc;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzbcR = leaderboardScore.getRank();
        this.zzbcS = (String)zzbo.zzu((Object)leaderboardScore.getDisplayRank());
        this.zzbcT = (String)zzbo.zzu((Object)leaderboardScore.getDisplayScore());
        this.zzbcU = leaderboardScore.getRawScore();
        this.zzbcV = leaderboardScore.getTimestampMillis();
        this.zzbcW = leaderboardScore.getScoreHolderDisplayName();
        this.zzbcX = leaderboardScore.getScoreHolderIconImageUri();
        this.zzbcY = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzbcZ = player == null ? null : (PlayerEntity)player.freeze();
        this.zzbda = leaderboardScore.getScoreTag();
        this.zzbdb = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzbdc = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zzbcR;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzbcS;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzbcS, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zzbcT;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzbcT, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzbcU;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zzbcV;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzbcZ == null) {
            return this.zzbcW;
        }
        return this.zzbcZ.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzbcZ == null) {
            zzh.zzb((String)this.zzbcW, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzbcZ.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzbcZ == null) {
            return this.zzbcX;
        }
        return this.zzbcZ.getIconImageUri();
    }

    @Override
    public final String getScoreHolderIconImageUrl() {
        if (this.zzbcZ == null) {
            return this.zzbdb;
        }
        return this.zzbcZ.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzbcZ == null) {
            return this.zzbcY;
        }
        return this.zzbcZ.getHiResImageUri();
    }

    @Override
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzbcZ == null) {
            return this.zzbdc;
        }
        return this.zzbcZ.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zzbcZ;
    }

    @Override
    public final String getScoreTag() {
        return this.zzbda;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbe.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbe.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbe.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbe.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbe.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbe.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbe.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbe.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbe.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbe.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbe.zzt((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

