/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.zza;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class GameRequestEntity
extends zzc
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new zza();
    private final GameEntity zzbbN;
    private final PlayerEntity zzbes;
    private final byte[] zzbdY;
    private final String zzQx;
    private final ArrayList<PlayerEntity> zzbet;
    private final int zzamr;
    private final long mCreationTimestamp;
    private final long zzbeu;
    private final Bundle zzbev;
    private final int zzLg;

    public GameRequestEntity(GameRequest gameRequest) {
        this.zzbbN = new GameEntity(gameRequest.getGame());
        this.zzbes = new PlayerEntity(gameRequest.getSender());
        this.zzQx = gameRequest.getRequestId();
        this.zzamr = gameRequest.getType();
        this.mCreationTimestamp = gameRequest.getCreationTimestamp();
        this.zzbeu = gameRequest.getExpirationTimestamp();
        this.zzLg = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzbdY = null;
        } else {
            this.zzbdY = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbdY, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzbet = new ArrayList(n);
        this.zzbev = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzbet.add((PlayerEntity)player);
            this.zzbev.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zzbbN = gameEntity;
        this.zzbes = playerEntity;
        this.zzbdY = byArray;
        this.zzQx = string;
        this.zzbet = arrayList;
        this.zzamr = n;
        this.mCreationTimestamp = l;
        this.zzbeu = l2;
        this.zzbev = bundle;
        this.zzLg = n2;
    }

    @Override
    public final String getRequestId() {
        return this.zzQx;
    }

    @Override
    public final Game getGame() {
        return this.zzbbN;
    }

    @Override
    public final Player getSender() {
        return this.zzbes;
    }

    @Override
    public final List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzbet);
    }

    @Override
    public final boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public final byte[] getData() {
        return this.zzbdY;
    }

    @Override
    public final int getType() {
        return this.zzamr;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final long getExpirationTimestamp() {
        return this.zzbeu;
    }

    @Override
    public final int getRecipientStatus(String string) {
        return this.zzbev.getInt(string, 0);
    }

    @Override
    public final int getStatus() {
        return this.zzLg;
    }

    public final GameRequest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return Arrays.hashCode(new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public final boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzbe.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzbe.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzbe.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzbe.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzbe.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzbe.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzbe.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public final String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzbe.zzt((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameRequestEntity gameRequestEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)gameRequestEntity.getGame(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)gameRequestEntity.getSender(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (byte[])gameRequestEntity.getData(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)gameRequestEntity.getRequestId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, gameRequestEntity.getRecipients(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)gameRequestEntity.getType());
        zzd.zza((Parcel)parcel2, (int)9, (long)gameRequestEntity.getCreationTimestamp());
        zzd.zza((Parcel)parcel2, (int)10, (long)gameRequestEntity.getExpirationTimestamp());
        zzd.zza((Parcel)parcel2, (int)11, (Bundle)gameRequestEntity.zzbev, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)12, (int)gameRequestEntity.getStatus());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

