/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzbaz;
import com.google.android.gms.internal.zzbbx;
import com.google.android.gms.internal.zzbby;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbdz;
import com.google.android.gms.internal.zzcaj;
import com.google.android.gms.internal.zzcal;
import com.google.android.gms.internal.zzcam;
import com.google.android.gms.internal.zzctu;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends com.google.android.gms.common.internal.zzz<com.google.android.gms.games.internal.zzj> {
    private zzcal zzaZp = new com.google.android.gms.games.internal.zzd(this);
    private final String zzaZq;
    private PlayerEntity zzaZr;
    private GameEntity zzaZs;
    private final com.google.android.gms.games.internal.zzn zzaZt;
    private boolean zzaZu = false;
    private final Binder zzaZv;
    private final long zzaZw;
    private final Games.GamesOptions zzaZx;
    private boolean zzaZy = false;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzq zzq2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzaZq = zzq2.zzrq();
        this.zzaZv = new Binder();
        int n = zzq2.zzrm();
        GamesClientImpl gamesClientImpl = this;
        this.zzaZt = new com.google.android.gms.games.internal.zzq(gamesClientImpl, n);
        this.zzaZw = ((Object)((Object)this)).hashCode();
        this.zzaZx = gamesOptions;
        if (!this.zzaZx.zzaYC) {
            this.zzs(zzq2.zzrs());
        }
    }

    public final boolean zzmv() {
        return true;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzaZu = false;
    }

    public final void zzaZ(int n) {
        int n2;
        this.zzaZt.zzbaL.gravity = n2 = n;
    }

    public final void zzs(View view) {
        this.zzaZt.zzt(view);
    }

    protected final Set<Scope> zzb(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            com.google.android.gms.common.internal.zzbo.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            com.google.android.gms.common.internal.zzbo.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public final void zza(com.google.android.gms.common.internal.zzj zzj2) {
        GamesClientImpl gamesClientImpl = this;
        this.zzaZr = null;
        gamesClientImpl.zzaZs = null;
        super.zza(zzj2);
    }

    public final void disconnect() {
        this.zzaZu = false;
        if (this.isConnected()) {
            try {
                com.google.android.gms.games.internal.zzj zzj2 = (com.google.android.gms.games.internal.zzj)this.zzrf();
                zzj2.zzuP();
                this.zzaZp.flush();
                zzj2.zzC(this.zzaZw);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.games.internal.zze.zzy("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected final String zzdb() {
        return "com.google.android.gms.games.service.START";
    }

    protected final String zzdc() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    public final Bundle zzoC() {
        try {
            Bundle bundle = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzoC();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    protected final Bundle zzmo() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzaZx.zzui();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzaZq);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzaZt.zzbaL.zzbaM));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzctu.zza((com.google.android.gms.common.internal.zzq)this.zzry()));
        return bundle;
    }

    public final String zzus() {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzus();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzb(String string, zzbaz<Games.GetServerAuthCodeResult> zzbaz2) throws RemoteException {
        com.google.android.gms.common.internal.zzbo.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(string, new zzy(zzbaz2));
    }

    public final String zzah(boolean bl) {
        if (this.zzaZr != null) {
            return this.zzaZr.getPlayerId();
        }
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuR();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Player zzut() {
        this.zzre();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaZr == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuS());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzaZr = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesClientImpl.zzd(remoteException);
                }
            }
        }
        return this.zzaZr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Game zzuu() {
        this.zzre();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaZs == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuT());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzaZs = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesClientImpl.zzd(remoteException);
                }
            }
        }
        return this.zzaZs;
    }

    public final void zza(zzbaz<Players.LoadPlayersResult> zzbaz2, String string, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb((com.google.android.gms.games.internal.zzf)new zzbn(zzbaz2), string, bl);
    }

    public final void zza(zzbaz<Players.LoadPlayersResult> zzbaz2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzbn(zzbaz2), n, bl, bl2);
    }

    public final void zza(zzbaz<Players.LoadPlayersResult> zzbaz2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzbn(zzbaz2), string, n, bl, bl2);
    }

    public final void zza(zzbaz<Players.LoadPlayersResult> zzbaz2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzc((com.google.android.gms.games.internal.zzf)new zzbn(zzbaz2), bl);
    }

    public final Intent zzuv() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuv();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzj(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzk(string, n, n2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzb(zzbaz<Leaderboards.LeaderboardMetadataResult> zzbaz2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb((com.google.android.gms.games.internal.zzf)new zzai(zzbaz2), bl);
    }

    public final void zzb(zzbaz<Leaderboards.LeaderboardMetadataResult> zzbaz2, String string, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzai(zzbaz2), string, bl);
    }

    public final void zza(zzbaz<Leaderboards.LoadPlayerScoreResult> zzbaz2, String string, String string2, int n, int n2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzbl(zzbaz2), null, string2, n, n2);
    }

    public final void zza(zzbaz<Leaderboards.LoadScoresResult> zzbaz2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(new zzah(zzbaz2), string, n, n2, n3, bl);
    }

    public final void zzb(zzbaz<Leaderboards.LoadScoresResult> zzbaz2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb(new zzah(zzbaz2), string, n, n2, n3, bl);
    }

    public final void zza(zzbaz<Leaderboards.LoadScoresResult> zzbaz2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzah(zzbaz2), leaderboardScoreBuffer.zzvn().asBundle(), n, n2);
    }

    public final void zza(zzbaz<Leaderboards.SubmitScoreResult> zzbaz2, String string, long l, String string2) throws RemoteException {
        zzcl zzcl2 = zzbaz2 == null ? null : new zzcl(zzbaz2);
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)zzcl2, string, l, string2);
    }

    public final Intent zzuw() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuw();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzc(zzbaz<Achievements.LoadAchievementsResult> zzbaz2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzf(zzbaz2), bl);
    }

    public final void zza(zzbaz<Achievements.UpdateAchievementResult> zzbaz2, String string) throws RemoteException {
        zze zze2 = zzbaz2 == null ? null : new zze(zzbaz2);
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)zze2, string, this.zzaZt.zzbaL.zzbaM, this.zzaZt.zzbaL.zzuW());
    }

    public final void zzb(zzbaz<Achievements.UpdateAchievementResult> zzbaz2, String string) throws RemoteException {
        zze zze2 = zzbaz2 == null ? null : new zze(zzbaz2);
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb(zze2, string, this.zzaZt.zzbaL.zzbaM, this.zzaZt.zzbaL.zzuW());
    }

    public final void zza(zzbaz<Achievements.UpdateAchievementResult> zzbaz2, String string, int n) throws RemoteException {
        zze zze2 = zzbaz2 == null ? null : new zze(zzbaz2);
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)zze2, string, n, this.zzaZt.zzbaL.zzbaM, this.zzaZt.zzbaL.zzuW());
    }

    public final void zzb(zzbaz<Achievements.UpdateAchievementResult> zzbaz2, String string, int n) throws RemoteException {
        zze zze2 = zzbaz2 == null ? null : new zze(zzbaz2);
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb(zze2, string, n, this.zzaZt.zzbaL.zzbaM, this.zzaZt.zzbaL.zzuW());
    }

    public final void zzd(zzbaz<Events.LoadEventsResult> zzbaz2, boolean bl) throws RemoteException {
        this.zzaZp.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zze((com.google.android.gms.games.internal.zzf)new zzu(zzbaz2), bl);
    }

    public final void zza(zzbaz<Events.LoadEventsResult> zzbaz2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzaZp.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzu(zzbaz2), bl, stringArray);
    }

    public final void zzn(String string, int n) {
        this.zzaZp.zzn(string, n);
    }

    public final Intent zzux() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzux();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzuy() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuy();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(zzbdw<OnInvitationReceivedListener> zzbdw2) {
        try {
            zzab zzab2 = new zzab(zzbdw2);
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)zzab2, this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuz() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzD(this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzb(zzbdw<OnTurnBasedMatchUpdateReceivedListener> zzbdw2) {
        try {
            zzaz zzaz2 = new zzaz(zzbdw2);
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb((com.google.android.gms.games.internal.zzf)zzaz2, this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuA() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzE(this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzc(zzbdw<QuestUpdateListener> zzbdw2) {
        try {
            zzbs zzbs2 = new zzbs(zzbdw2);
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzd((com.google.android.gms.games.internal.zzf)zzbs2, this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuB() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzG(this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzd(zzbdw<OnRequestReceivedListener> zzbdw2) {
        try {
            zzbw zzbw2 = new zzbw(zzbdw2);
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzc((com.google.android.gms.games.internal.zzf)zzbw2, this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuC() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzF(this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzuD() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuD();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzuE() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuE();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzf(zzbaz<GamesMetadata.LoadGamesResult> zzbaz2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb(new zzx(zzbaz2));
    }

    public final void zzg(zzbaz<Status> zzbaz2) throws RemoteException {
        this.zzaZp.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(new zzcg(zzbaz2));
    }

    public final int zzuF() {
        int n = 4368;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuF();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final String zzhl() {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzhl();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(zzbaz<Invitations.LoadInvitationsResult> zzbaz2, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzae(zzbaz2), n);
    }

    public final void zzo(String string, int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzo(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzp(String string, int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzp(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(zzbaz<TurnBasedMultiplayer.InitiateMatchResult> zzbaz2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzco(zzbaz2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzvs(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public final void zzc(zzbaz<TurnBasedMultiplayer.InitiateMatchResult> zzbaz2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb((com.google.android.gms.games.internal.zzf)new zzco(zzbaz2), string);
    }

    public final void zzd(zzbaz<TurnBasedMultiplayer.InitiateMatchResult> zzbaz2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzc((com.google.android.gms.games.internal.zzf)new zzco(zzbaz2), string);
    }

    public final int zzuG() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuG();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(zzbaz<TurnBasedMultiplayer.UpdateMatchResult> zzbaz2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzcs(zzbaz2), string, byArray, string2, participantResultArray);
    }

    public final void zza(zzbaz<TurnBasedMultiplayer.UpdateMatchResult> zzbaz2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzcs(zzbaz2), string, byArray, participantResultArray);
    }

    public final void zze(zzbaz<TurnBasedMultiplayer.LeaveMatchResult> zzbaz2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zze((com.google.android.gms.games.internal.zzf)new zzcp(zzbaz2), string);
    }

    public final void zza(zzbaz<TurnBasedMultiplayer.LeaveMatchResult> zzbaz2, String string, String string2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzcp(zzbaz2), string, string2);
    }

    public final void zzf(zzbaz<TurnBasedMultiplayer.CancelMatchResult> zzbaz2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzd((com.google.android.gms.games.internal.zzf)new zzcn(zzbaz2), string);
    }

    public final void zzdj(String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzdm(string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(zzbaz<TurnBasedMultiplayer.LoadMatchesResult> zzbaz2, int n, int[] nArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzct(zzbaz2), n, nArray);
    }

    public final void zzg(zzbaz<TurnBasedMultiplayer.LoadMatchResult> zzbaz2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzf((com.google.android.gms.games.internal.zzf)new zzcq(zzbaz2), string);
    }

    public final Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(zzbdw<RoomUpdateListener> zzbdw2, zzbdw<RoomStatusUpdateListener> zzbdw3, zzbdw<RealTimeMessageReceivedListener> zzbdw4, RoomConfig roomConfig) {
        try {
            zzcc zzcc2 = new zzcc(zzbdw2, zzbdw3, zzbdw4);
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(zzcc2, (IBinder)this.zzaZv, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzb(zzbdw<RoomUpdateListener> zzbdw2, zzbdw<RoomStatusUpdateListener> zzbdw3, zzbdw<RealTimeMessageReceivedListener> zzbdw4, RoomConfig roomConfig) {
        try {
            zzcc zzcc2 = new zzcc(zzbdw2, zzbdw3, zzbdw4);
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)zzcc2, (IBinder)this.zzaZv, roomConfig.getInvitationId(), false, this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(zzbdw<RoomUpdateListener> zzbdw2, String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzcc(zzbdw2), string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zza(zzbdw<RealTimeMultiplayer.ReliableMessageSentCallback> zzbdw2, byte[] byArray, String string, String string2) {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzbv(zzbdw2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string, String[] stringArray) {
        com.google.android.gms.common.internal.zzbo.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzc(byte[] byArray, String string) {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zzba(int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzba(n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzuH() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuH();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(n, byArray, n2, string);
            com.google.android.gms.common.internal.zzbo.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final int zzuI() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuI();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzuJ() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuJ();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(zzbaz<Requests.UpdateRequestsResult> zzbaz2, String[] stringArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzca(zzbaz2), stringArray);
    }

    public final void zzb(zzbaz<Requests.UpdateRequestsResult> zzbaz2, String[] stringArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb((com.google.android.gms.games.internal.zzf)new zzca(zzbaz2), stringArray);
    }

    public final void zza(zzbaz<Requests.LoadRequestsResult> zzbaz2, int n, int n2, int n3) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzbz(zzbaz2), n, n2, n3);
    }

    public final void zze(zzbaz<Stats.LoadPlayerStatsResult> zzbaz2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzf((com.google.android.gms.games.internal.zzf)new zzbm(zzbaz2), bl);
    }

    public final Intent zzb(int[] nArray) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb(nArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzdk(String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzdk(string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzh(zzbaz<Quests.AcceptQuestResult> zzbaz2, String string) throws RemoteException {
        this.zzaZp.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzh(new zzbp(zzbaz2), string);
    }

    public final void zzb(zzbaz<Quests.ClaimMilestoneResult> zzbaz2, String string, String string2) throws RemoteException {
        this.zzaZp.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb((com.google.android.gms.games.internal.zzf)new zzbr(zzbaz2, string2), string, string2);
    }

    public final void zza(zzbaz<Quests.LoadQuestsResult> zzbaz2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaZp.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzbt(zzbaz2), nArray, n, bl);
    }

    public final void zzb(zzbaz<Quests.LoadQuestsResult> zzbaz2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaZp.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzbt(zzbaz2), stringArray, bl);
    }

    public final void zzdl(String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(string, this.zzaZt.zzbaL.zzbaM, this.zzaZt.zzbaL.zzuW());
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zzuK() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuK();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzuL() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuL();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzf(zzbaz<Snapshots.LoadSnapshotsResult> zzbaz2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzd((com.google.android.gms.games.internal.zzf)new zzck(zzbaz2), bl);
    }

    public final void zza(zzbaz<Snapshots.OpenSnapshotResult> zzbaz2, String string, boolean bl, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzcj(zzbaz2), string, bl, n);
    }

    public final void zza(zzbaz<Snapshots.CommitSnapshotResult> zzbaz2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbo.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzvv();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzsM();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzch(zzbaz2), snapshot.getMetadata().getSnapshotId(), (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
    }

    public final void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbo.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzsM();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(zzbaz<Snapshots.DeleteSnapshotResult> zzbaz2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzg(new zzci(zzbaz2), string);
    }

    public final void zza(zzbaz<Snapshots.OpenSnapshotResult> zzbaz2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        com.google.android.gms.common.internal.zzbo.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzvv();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzsM();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza((com.google.android.gms.games.internal.zzf)new zzcj(zzbaz2), string, string2, (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
    }

    public final void zzh(zzbaz<Videos.CaptureCapabilitiesResult> zzbaz2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzc(new zzj(zzbaz2));
    }

    public final Intent zzuM() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuU();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzi(zzbaz<Videos.CaptureStateResult> zzbaz2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzd(new zzn(zzbaz2));
    }

    public final void zzb(zzbaz<Videos.CaptureAvailableResult> zzbaz2, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzb((com.google.android.gms.games.internal.zzf)new zzh(zzbaz2), n);
    }

    public final boolean zzuN() {
        boolean bl = false;
        try {
            bl = ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuN();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return bl;
    }

    public final void zze(zzbdw<Videos.CaptureOverlayStateListener> zzbdw2) {
        try {
            zzl zzl2 = new zzl(zzbdw2);
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zze((com.google.android.gms.games.internal.zzf)zzl2, this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzuO() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzH(this.zzaZw);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzj)this.zzrf()).zza(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    public final void zzuP() {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzj)this.zzrf()).zzuP();
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    private static void zzd(RemoteException remoteException) {
        com.google.android.gms.games.internal.zze.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzK(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.zzb zzb2 = new com.google.android.gms.games.multiplayer.realtime.zzb(dataHolder);
        Room room = null;
        try {
            if (zzb2.getCount() > 0) {
                room = (Room)((Room)zzb2.get(0)).freeze();
            }
        }
        finally {
            zzb2.release();
        }
        return room;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzaZy = this.zzaZu = bundle.getBoolean("show_welcome_popup");
            this.zzaZr = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzaZs = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        com.google.android.gms.games.internal.zzj zzj2 = (com.google.android.gms.games.internal.zzj)iInterface;
        GamesClientImpl gamesClientImpl = this;
        super.zza((IInterface)zzj2);
        if (gamesClientImpl.zzaZu) {
            gamesClientImpl.zzaZt.zzuV();
            gamesClientImpl.zzaZu = false;
        }
        if (!gamesClientImpl.zzaZx.zzaYu && !gamesClientImpl.zzaZx.zzaYC) {
            com.google.android.gms.games.internal.zzj zzj3 = zzj2;
            GamesClientImpl gamesClientImpl2 = gamesClientImpl;
            try {
                zzbo zzbo2 = new zzbo(gamesClientImpl2.zzaZt);
                zzj3.zza(zzbo2, gamesClientImpl2.zzaZw);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof com.google.android.gms.games.internal.zzj) {
            return (com.google.android.gms.games.internal.zzj)iInterface;
        }
        return new com.google.android.gms.games.internal.zzk(iBinder2);
    }

    static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status mStatus;
        private final String zzD;

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getUrl() {
            return this.zzD;
        }
    }

    static final class zzo
    implements Videos.CaptureStateResult {
        private final Status mStatus;
        private final CaptureState zzaZG;

        zzo(Status status, CaptureState captureState) {
            this.mStatus = status;
            this.zzaZG = captureState;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final CaptureState getCaptureState() {
            return this.zzaZG;
        }
    }

    static final class zzk
    implements Videos.CaptureCapabilitiesResult {
        private final Status mStatus;
        private final VideoCapabilities zzaZE;

        zzk(Status status, VideoCapabilities videoCapabilities) {
            this.mStatus = status;
            this.zzaZE = videoCapabilities;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final VideoCapabilities getCapabilities() {
            return this.zzaZE;
        }
    }

    static final class zzi
    implements Videos.CaptureAvailableResult {
        private final Status mStatus;
        private final boolean zzaZD;

        zzi(Status status, boolean bl) {
            this.mStatus = status;
            this.zzaZD = bl;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final boolean isAvailable() {
            return this.zzaZD;
        }
    }

    static final class zzs
    implements Snapshots.DeleteSnapshotResult {
        private final Status mStatus;
        private final String zzaZJ;

        zzs(int n, String string) {
            this.mStatus = GamesStatusCodes.zzaY(n);
            this.zzaZJ = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getSnapshotId() {
            return this.zzaZJ;
        }
    }

    static final class zzq
    extends zzw
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzaZI;

        zzq(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzaZI = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
                return;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public final SnapshotMetadata getSnapshotMetadata() {
            return this.zzaZI;
        }
    }

    static final class zzbc
    extends zzw
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzbac;
        private final String zzbad;
        private final Snapshot zzbae;
        private final com.google.android.gms.drive.zzc zzbaf;
        private final SnapshotContents zzbag;

        zzbc(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        zzbc(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzbac = null;
                    this.zzbae = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzc.zzae((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzbac = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    this.zzbae = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzbac = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzbae = new SnapshotEntity(snapshotMetadataEntity2, new com.google.android.gms.games.snapshot.zza(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzbad = string;
            this.zzbaf = zzc4;
            this.zzbag = new com.google.android.gms.games.snapshot.zza(zzc4);
        }

        @Override
        public final Snapshot getSnapshot() {
            return this.zzbac;
        }

        @Override
        public final String getConflictId() {
            return this.zzbad;
        }

        @Override
        public final Snapshot getConflictingSnapshot() {
            return this.zzbae;
        }

        @Override
        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzbag;
        }
    }

    static final class zzax
    extends zzw
    implements Snapshots.LoadSnapshotsResult {
        zzax(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzaCX);
        }
    }

    static final class zzas
    extends zzw
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzaZU;

        zzas(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzaZU = playerStatsBuffer.getCount() > 0 ? new com.google.android.gms.games.stats.zza((PlayerStats)playerStatsBuffer.get(0)) : null;
                return;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public final PlayerStats getPlayerStats() {
            return this.zzaZU;
        }
    }

    static final class zzp
    extends zzw
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzaZH;
        private final Quest zzaZB;

        zzp(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzaZB = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzaZB.zzvt();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzaZH = list.get(i);
                        return;
                    }
                    this.zzaZH = null;
                } else {
                    this.zzaZH = null;
                    this.zzaZB = null;
                }
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Milestone getMilestone() {
            return this.zzaZH;
        }

        @Override
        public final Quest getQuest() {
            return this.zzaZB;
        }
    }

    static final class zzd
    extends zzw
    implements Quests.AcceptQuestResult {
        private final Quest zzaZB;

        zzd(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzaZB = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Quest getQuest() {
            return this.zzaZB;
        }
    }

    static final class zzau
    extends zzw
    implements Quests.LoadQuestsResult {
        private final DataHolder zzaCX;

        zzau(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaCX = dataHolder;
        }

        @Override
        public final QuestBuffer getQuests() {
            return new QuestBuffer(this.zzaCX);
        }
    }

    static final class zzav
    implements Requests.LoadRequestsResult {
        private final Status mStatus;
        private final Bundle zzaZW;

        zzav(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzaZW = bundle;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final GameRequestBuffer getRequests(int n) {
            String string;
            switch (n) {
                case 1: {
                    String string2 = "GIFT";
                    break;
                }
                case 2: {
                    String string2 = "WISH";
                    break;
                }
                default: {
                    com.google.android.gms.games.internal.zze.zzz("RequestType", new StringBuilder(33).append("Unknown request type: ").append(n).toString());
                    String string2 = string = "UNKNOWN_TYPE";
                }
            }
            if (!this.zzaZW.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzaZW.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public final void release() {
            for (String string : this.zzaZW.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzaZW.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    static final class zzcw
    extends zzw
    implements Requests.UpdateRequestsResult {
        private final zzcam zzbaF;

        zzcw(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbaF = zzcam.zzN(dataHolder);
        }

        @Override
        public final int getRequestOutcome(String string) {
            return this.zzbaF.getRequestOutcome(string);
        }

        @Override
        public final Set<String> getRequestIds() {
            return this.zzbaF.getRequestIds();
        }
    }

    static final class zzz
    implements Games.GetServerAuthCodeResult {
        private final Status mStatus;
        private final String zzaZK;

        zzz(Status status, String string) {
            this.mStatus = status;
            this.zzaZK = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getCode() {
            return this.zzaZK;
        }
    }

    static final class zzg
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status mStatus;
        private final String zzaZC;

        zzg(Status status, String string) {
            this.mStatus = status;
            this.zzaZC = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMatchId() {
            return this.zzaZC;
        }
    }

    static final class zzaj
    extends zzcr
    implements TurnBasedMultiplayer.LeaveMatchResult {
        zzaj(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzcv
    extends zzcr
    implements TurnBasedMultiplayer.UpdateMatchResult {
        zzcv(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzaa
    extends zzcr
    implements TurnBasedMultiplayer.InitiateMatchResult {
        zzaa(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzap
    extends zzcr
    implements TurnBasedMultiplayer.LoadMatchResult {
        zzap(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static abstract class zzcr
    extends zzw {
        private TurnBasedMatch zzbaa;

        zzcr(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzbaa = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzbaa;
        }
    }

    static final class zzcm
    extends zzw
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzbay;

        public zzcm(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzbay = new ScoreSubmissionData(dataHolder);
                return;
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public final ScoreSubmissionData getScoreData() {
            return this.zzbay;
        }
    }

    static final class zzat
    extends zzw
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzaZV;

        zzat(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZV = new PlayerBuffer(dataHolder);
        }

        @Override
        public final PlayerBuffer getPlayers() {
            return this.zzaZV;
        }
    }

    static final class zzaq
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status mStatus;
        private final LoadMatchesResponse zzaZS;

        zzaq(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzaZS = new LoadMatchesResponse(bundle);
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final LoadMatchesResponse getMatches() {
            return this.zzaZS;
        }

        public final void release() {
            this.zzaZS.release();
        }
    }

    static final class zzao
    extends zzw
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzaZR;

        zzao(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZR = new InvitationBuffer(dataHolder);
        }

        @Override
        public final InvitationBuffer getInvitations() {
            return this.zzaZR;
        }
    }

    static final class zzar
    extends zzw
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzaZT;

        zzar(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzaZT = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public final LeaderboardScore getScore() {
            return this.zzaZT;
        }
    }

    static final class zzaw
    extends zzw
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzaZX;
        private final LeaderboardScoreBuffer zzaZY;

        zzaw(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzaZX = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzaZY = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public final Leaderboard getLeaderboard() {
            return this.zzaZX;
        }

        @Override
        public final LeaderboardScoreBuffer getScores() {
            return this.zzaZY;
        }
    }

    static final class zzag
    extends zzw
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzaZM;

        zzag(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZM = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public final LeaderboardBuffer getLeaderboards() {
            return this.zzaZM;
        }
    }

    static final class zzan
    extends zzw
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzaZQ;

        zzan(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZQ = new GameBuffer(dataHolder);
        }

        @Override
        public final GameBuffer getGames() {
            return this.zzaZQ;
        }
    }

    static final class zzam
    extends zzw
    implements Events.LoadEventsResult {
        private final EventBuffer zzaZP;

        zzam(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZP = new EventBuffer(dataHolder);
        }

        @Override
        public final EventBuffer getEvents() {
            return this.zzaZP;
        }
    }

    static final class zzcu
    implements Achievements.UpdateAchievementResult {
        private final Status mStatus;
        private final String zzaZb;

        zzcu(int n, String string) {
            this.mStatus = GamesStatusCodes.zzaY(n);
            this.zzaZb = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getAchievementId() {
            return this.zzaZb;
        }
    }

    static final class zzal
    extends zzw
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzaZO;

        zzal(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZO = new AchievementBuffer(dataHolder);
        }

        @Override
        public final AchievementBuffer getAchievements() {
            return this.zzaZO;
        }
    }

    static abstract class zzw
    extends zzbby {
        protected zzw(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzaY(dataHolder.getStatusCode()));
        }
    }

    static final class zzbu
    implements zzbdz<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzaxu;
        private final String zzbam;
        private final int zzban;

        zzbu(int n, int n2, String string) {
            this.zzaxu = n;
            this.zzban = n2;
            this.zzbam = string;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback = (RealTimeMultiplayer.ReliableMessageSentCallback)object;
            zzbu zzbu2 = this;
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(zzbu2.zzaxu, zzbu2.zzban, zzbu2.zzbam);
            }
        }
    }

    static final class zzbb
    implements zzbdz<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzbab;

        zzbb(RealTimeMessage realTimeMessage) {
            this.zzbab = realTimeMessage;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RealTimeMessageReceivedListener realTimeMessageReceivedListener = (RealTimeMessageReceivedListener)object;
            zzbb zzbb2 = this;
            realTimeMessageReceivedListener.onRealTimeMessageReceived(zzbb2.zzbab);
        }
    }

    static final class zzbe
    implements zzbdz<RoomStatusUpdateListener> {
        private final String zzbah;

        zzbe(String string) {
            this.zzbah = string;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbe zzbe2 = this;
            roomStatusUpdateListener.onP2PDisconnected(zzbe2.zzbah);
        }
    }

    static final class zzbd
    implements zzbdz<RoomStatusUpdateListener> {
        private final String zzbah;

        zzbd(String string) {
            this.zzbah = string;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbd zzbd2 = this;
            roomStatusUpdateListener.onP2PConnected(zzbd2.zzbah);
        }
    }

    static final class zzbh
    extends zza {
        zzbh(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    static final class zzbf
    extends zza {
        zzbf(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    static final class zzbg
    extends zza {
        zzbg(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    static final class zzbk
    extends zza {
        zzbk(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    static final class zzbj
    extends zza {
        zzbj(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    static final class zzbi
    extends zza {
        zzbi(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    static final class zzt
    extends zzc {
        zzt(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    static final class zzr
    extends zzc {
        zzr(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    static final class zzcb
    extends zzc {
        zzcb(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    static final class zzce
    extends zzc {
        zzce(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    static final class zzcd
    extends zzb {
        zzcd(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    static final class zzak
    implements zzbdz<RoomUpdateListener> {
        private final int zzaxu;
        private final String zzaZN;

        zzak(int n, String string) {
            this.zzaxu = n;
            this.zzaZN = string;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            zzak zzak2 = this;
            roomUpdateListener.onLeftRoom(zzak2.zzaxu, zzak2.zzaZN);
        }
    }

    static final class zzaf
    extends zzb {
        public zzaf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    static final class zzcf
    extends zzb {
        public zzcf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    static abstract class zza
    extends zzc {
        private final ArrayList<String> zzaZA = new ArrayList();

        zza(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzaZA.add(stringArray[i]);
            }
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzaZA);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    static abstract class zzc
    extends zzbbx<RoomStatusUpdateListener> {
        zzc(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzK(dataHolder2));
        }
    }

    static abstract class zzb
    extends zzbbx<RoomUpdateListener> {
        zzb(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            this.zza(roomUpdateListener, GamesClientImpl.zzK(dataHolder2), dataHolder2.getStatusCode());
        }
    }

    static final class zzby
    implements zzbdz<OnRequestReceivedListener> {
        private final String zzQx;

        zzby(String string) {
            this.zzQx = string;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzby zzby2 = this;
            onRequestReceivedListener.onRequestRemoved(zzby2.zzQx);
        }
    }

    static final class zzbx
    implements zzbdz<OnRequestReceivedListener> {
        private final GameRequest zzbap;

        zzbx(GameRequest gameRequest) {
            this.zzbap = gameRequest;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzbx zzbx2 = this;
            onRequestReceivedListener.onRequestReceived(zzbx2.zzbap);
        }
    }

    static final class zzbq
    implements zzbdz<QuestUpdateListener> {
        private final Quest zzaZB;

        zzbq(Quest quest) {
            this.zzaZB = quest;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            QuestUpdateListener questUpdateListener = (QuestUpdateListener)object;
            zzbq zzbq2 = this;
            questUpdateListener.onQuestCompleted(zzbq2.zzaZB);
        }
    }

    static final class zzay
    implements zzbdz<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzaZZ;

        zzay(String string) {
            this.zzaZZ = string;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzay zzay2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(zzay2.zzaZZ);
        }
    }

    static final class zzba
    implements zzbdz<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzbaa;

        zzba(TurnBasedMatch turnBasedMatch) {
            this.zzbaa = turnBasedMatch;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzba zzba2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(zzba2.zzbaa);
        }
    }

    static final class zzad
    implements zzbdz<OnInvitationReceivedListener> {
        private final String zzajX;

        zzad(String string) {
            this.zzajX = string;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzad zzad2 = this;
            onInvitationReceivedListener.onInvitationRemoved(zzad2.zzajX);
        }
    }

    static final class zzac
    implements zzbdz<OnInvitationReceivedListener> {
        private final Invitation zzaZL;

        zzac(Invitation invitation) {
            this.zzaZL = invitation;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzac zzac2 = this;
            onInvitationReceivedListener.onInvitationReceived(zzac2.zzaZL);
        }
    }

    static final class zzm
    implements zzbdz<Videos.CaptureOverlayStateListener> {
        private final int zzaZF;

        zzm(int n) {
            this.zzaZF = n;
        }

        public final void zzpT() {
        }

        public final /* synthetic */ void zzq(Object object) {
            Videos.CaptureOverlayStateListener captureOverlayStateListener = (Videos.CaptureOverlayStateListener)object;
            zzm zzm2 = this;
            captureOverlayStateListener.onCaptureOverlayStateChanged(zzm2.zzaZF);
        }
    }

    static final class zzn
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Videos.CaptureStateResult> zzaIz;

        public zzn(zzbaz<Videos.CaptureStateResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzd(int n, Bundle bundle) {
            this.zzaIz.setResult((Object)new zzo(new Status(n), CaptureState.zzs(bundle)));
        }
    }

    static final class zzl
    extends com.google.android.gms.games.internal.zza {
        private final zzbdw<Videos.CaptureOverlayStateListener> zzaOo;

        zzl(zzbdw<Videos.CaptureOverlayStateListener> zzbdw2) {
            this.zzaOo = (zzbdw)com.google.android.gms.common.internal.zzbo.zzb(zzbdw2, (Object)"Callback must not be null");
        }

        @Override
        public final void onCaptureOverlayStateChanged(int n) {
            this.zzaOo.zza((zzbdz)new zzm(n));
        }
    }

    static final class zzj
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Videos.CaptureCapabilitiesResult> zzaIz;

        zzj(zzbaz<Videos.CaptureCapabilitiesResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzaIz.setResult((Object)new zzk(new Status(n), videoCapabilities));
        }
    }

    static final class zzh
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Videos.CaptureAvailableResult> zzaIz;

        zzh(zzbaz<Videos.CaptureAvailableResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, boolean bl) {
            this.zzaIz.setResult((Object)new zzi(new Status(n), bl));
        }
    }

    static final class zzci
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Snapshots.DeleteSnapshotResult> zzaIz;

        public zzci(zzbaz<Snapshots.DeleteSnapshotResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(int n, String string) {
            this.zzaIz.setResult((Object)new zzs(n, string));
        }
    }

    static final class zzch
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Snapshots.CommitSnapshotResult> zzbav;

        public zzch(zzbaz<Snapshots.CommitSnapshotResult> zzbaz2) {
            this.zzbav = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzE(DataHolder dataHolder) {
            this.zzbav.setResult((Object)new zzq(dataHolder));
        }
    }

    static final class zzcj
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Snapshots.OpenSnapshotResult> zzbaw;

        public zzcj(zzbaz<Snapshots.OpenSnapshotResult> zzbaz2) {
            this.zzbaw = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzbaw.setResult((Object)new zzbc(dataHolder, zzc2));
        }

        @Override
        public final void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzbaw.setResult((Object)new zzbc(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    static final class zzck
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Snapshots.LoadSnapshotsResult> zzbax;

        public zzck(zzbaz<Snapshots.LoadSnapshotsResult> zzbaz2) {
            this.zzbax = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzD(DataHolder dataHolder) {
            this.zzbax.setResult((Object)new zzax(dataHolder));
        }
    }

    static final class zzbm
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Stats.LoadPlayerStatsResult> zzaIz;

        public zzbm(zzbaz<Stats.LoadPlayerStatsResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzJ(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzas(dataHolder));
        }
    }

    static final class zzbt
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Quests.LoadQuestsResult> zzbal;

        public zzbt(zzbaz<Quests.LoadQuestsResult> zzbaz2) {
            this.zzbal = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzI(DataHolder dataHolder) {
            this.zzbal.setResult((Object)new zzau(dataHolder));
        }
    }

    static final class zzbr
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Quests.ClaimMilestoneResult> zzbaj;
        private final String zzbak;

        public zzbr(zzbaz<Quests.ClaimMilestoneResult> zzbaz2, String string) {
            this.zzbaj = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
            this.zzbak = (String)com.google.android.gms.common.internal.zzbo.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public final void zzF(DataHolder dataHolder) {
            this.zzbaj.setResult((Object)new zzp(dataHolder, this.zzbak));
        }
    }

    static final class zzbp
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Quests.AcceptQuestResult> zzbai;

        public zzbp(zzbaz<Quests.AcceptQuestResult> zzbaz2) {
            this.zzbai = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzG(DataHolder dataHolder) {
            this.zzbai.setResult((Object)new zzd(dataHolder));
        }
    }

    static final class zzbz
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Requests.LoadRequestsResult> zzbaq;

        public zzbz(zzbaz<Requests.LoadRequestsResult> zzbaz2) {
            this.zzbaq = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzaY(n);
            this.zzbaq.setResult((Object)new zzav(status, bundle));
        }
    }

    static final class zzca
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Requests.UpdateRequestsResult> zzbar;

        public zzca(zzbaz<Requests.UpdateRequestsResult> zzbaz2) {
            this.zzbar = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzC(DataHolder dataHolder) {
            this.zzbar.setResult((Object)new zzcw(dataHolder));
        }
    }

    static final class zzbo
    extends com.google.android.gms.games.internal.zzb {
        private final com.google.android.gms.games.internal.zzn zzaZt;

        public zzbo(com.google.android.gms.games.internal.zzn zzn2) {
            this.zzaZt = zzn2;
        }

        @Override
        public final com.google.android.gms.games.internal.zzl zzur() {
            return new com.google.android.gms.games.internal.zzl(this.zzaZt.zzbaL);
        }
    }

    static final class zzy
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Games.GetServerAuthCodeResult> zzaIz;

        public zzy(zzbaz<Games.GetServerAuthCodeResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzaY(n);
            this.zzaIz.setResult((Object)new zzz(status, string));
        }
    }

    static final class zzcg
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Status> zzaIz;

        public zzcg(zzbaz<Status> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzuq() {
            Status status = GamesStatusCodes.zzaY(0);
            this.zzaIz.setResult((Object)status);
        }
    }

    static final class zzbv
    extends com.google.android.gms.games.internal.zza {
        private zzbdw<RealTimeMultiplayer.ReliableMessageSentCallback> zzbao;

        public zzbv(zzbdw<RealTimeMultiplayer.ReliableMessageSentCallback> zzbdw2) {
            this.zzbao = zzbdw2;
        }

        @Override
        public final void zzb(int n, int n2, String string) {
            if (this.zzbao != null) {
                this.zzbao.zza((zzbdz)new zzbu(n, n2, string));
            }
        }
    }

    static final class zzcc
    extends com.google.android.gms.games.internal.zza {
        private final zzbdw<? extends RoomUpdateListener> zzbas;
        private final zzbdw<? extends RoomStatusUpdateListener> zzbat;
        private final zzbdw<RealTimeMessageReceivedListener> zzbau;

        public zzcc(zzbdw<RoomUpdateListener> zzbdw2) {
            this.zzbas = (zzbdw)com.google.android.gms.common.internal.zzbo.zzb(zzbdw2, (Object)"Callbacks must not be null");
            this.zzbat = null;
            this.zzbau = null;
        }

        public zzcc(zzbdw<? extends RoomUpdateListener> zzbdw2, zzbdw<? extends RoomStatusUpdateListener> zzbdw3, zzbdw<RealTimeMessageReceivedListener> zzbdw4) {
            this.zzbas = (zzbdw)com.google.android.gms.common.internal.zzbo.zzb(zzbdw2, (Object)"Callbacks must not be null");
            this.zzbat = zzbdw3;
            this.zzbau = zzbdw4;
        }

        @Override
        public final void zzu(DataHolder dataHolder) {
            this.zzbas.zza((zzbdz)new zzcf(dataHolder));
        }

        @Override
        public final void zzv(DataHolder dataHolder) {
            this.zzbas.zza((zzbdz)new zzaf(dataHolder));
        }

        @Override
        public final void onLeftRoom(int n, String string) {
            this.zzbas.zza((zzbdz)new zzak(n, string));
        }

        @Override
        public final void zzy(DataHolder dataHolder) {
            this.zzbas.zza((zzbdz)new zzcd(dataHolder));
        }

        @Override
        public final void zzw(DataHolder dataHolder) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzce(dataHolder));
            }
        }

        @Override
        public final void zzx(DataHolder dataHolder) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzcb(dataHolder));
            }
        }

        @Override
        public final void zzz(DataHolder dataHolder) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzr(dataHolder));
            }
        }

        @Override
        public final void zzA(DataHolder dataHolder) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzt(dataHolder));
            }
        }

        @Override
        public final void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzbf(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzbh(dataHolder, stringArray));
            }
        }

        @Override
        public final void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzbi(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzbj(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzbk(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzbg(dataHolder, stringArray));
            }
        }

        @Override
        public final void onP2PConnected(String string) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzbd(string));
            }
        }

        @Override
        public final void onP2PDisconnected(String string) {
            if (this.zzbat != null) {
                this.zzbat.zza((zzbdz)new zzbe(string));
            }
        }

        @Override
        public final void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzbau != null) {
                this.zzbau.zza((zzbdz)new zzbb(realTimeMessage));
            }
        }
    }

    static final class zzcn
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<TurnBasedMultiplayer.CancelMatchResult> zzbaz;

        public zzcn(zzbaz<TurnBasedMultiplayer.CancelMatchResult> zzbaz2) {
            this.zzbaz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzaY(n);
            this.zzbaz.setResult((Object)new zzg(status, string));
        }
    }

    static final class zzcp
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<TurnBasedMultiplayer.LeaveMatchResult> zzbaB;

        public zzcp(zzbaz<TurnBasedMultiplayer.LeaveMatchResult> zzbaz2) {
            this.zzbaB = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzs(DataHolder dataHolder) {
            this.zzbaB.setResult((Object)new zzaj(dataHolder));
        }
    }

    static final class zzcs
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<TurnBasedMultiplayer.UpdateMatchResult> zzbaD;

        public zzcs(zzbaz<TurnBasedMultiplayer.UpdateMatchResult> zzbaz2) {
            this.zzbaD = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzr(DataHolder dataHolder) {
            this.zzbaD.setResult((Object)new zzcv(dataHolder));
        }
    }

    static final class zzco
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<TurnBasedMultiplayer.InitiateMatchResult> zzbaA;

        public zzco(zzbaz<TurnBasedMultiplayer.InitiateMatchResult> zzbaz2) {
            this.zzbaA = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzq(DataHolder dataHolder) {
            this.zzbaA.setResult((Object)new zzaa(dataHolder));
        }
    }

    static final class zzcq
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<TurnBasedMultiplayer.LoadMatchResult> zzbaC;

        public zzcq(zzbaz<TurnBasedMultiplayer.LoadMatchResult> zzbaz2) {
            this.zzbaC = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzp(DataHolder dataHolder) {
            this.zzbaC.setResult((Object)new zzap(dataHolder));
        }
    }

    static final class zzct
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<TurnBasedMultiplayer.LoadMatchesResult> zzbaE;

        public zzct(zzbaz<TurnBasedMultiplayer.LoadMatchesResult> zzbaz2) {
            this.zzbaE = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzaY(n);
            this.zzbaE.setResult((Object)new zzaq(status, bundle));
        }
    }

    static final class zzcl
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Leaderboards.SubmitScoreResult> zzaIz;

        public zzcl(zzbaz<Leaderboards.SubmitScoreResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzcm(dataHolder));
        }
    }

    static final class zzbn
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Players.LoadPlayersResult> zzaIz;

        zzbn(zzbaz<Players.LoadPlayersResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzat(dataHolder));
        }

        @Override
        public final void zzk(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzat(dataHolder));
        }
    }

    static final class zzbw
    extends com.google.android.gms.games.internal.zza {
        private final zzbdw<OnRequestReceivedListener> zzaOo;

        zzbw(zzbdw<OnRequestReceivedListener> zzbdw2) {
            this.zzaOo = zzbdw2;
        }

        @Override
        public final void zzo(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzaOo.zza((zzbdz)new zzbx(gameRequest));
            }
        }

        @Override
        public final void onRequestRemoved(String string) {
            this.zzaOo.zza((zzbdz)new zzby(string));
        }
    }

    static final class zzbs
    extends com.google.android.gms.games.internal.zza {
        private final zzbdw<QuestUpdateListener> zzaOo;

        zzbs(zzbdw<QuestUpdateListener> zzbdw2) {
            this.zzaOo = zzbdw2;
        }

        @Override
        public final void zzH(DataHolder dataHolder) {
            Quest quest = zzbs.zzM(dataHolder);
            if (quest != null) {
                this.zzaOo.zza((zzbdz)new zzbq(quest));
            }
        }

        private static Quest zzM(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    static final class zzaz
    extends com.google.android.gms.games.internal.zza {
        private final zzbdw<OnTurnBasedMatchUpdateReceivedListener> zzaOo;

        zzaz(zzbdw<OnTurnBasedMatchUpdateReceivedListener> zzbdw2) {
            this.zzaOo = zzbdw2;
        }

        @Override
        public final void zzt(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzaOo.zza((zzbdz)new zzba(turnBasedMatch));
            }
        }

        @Override
        public final void onTurnBasedMatchRemoved(String string) {
            this.zzaOo.zza((zzbdz)new zzay(string));
        }
    }

    static final class zzab
    extends com.google.android.gms.games.internal.zza {
        private final zzbdw<OnInvitationReceivedListener> zzaOo;

        zzab(zzbdw<OnInvitationReceivedListener> zzbdw2) {
            this.zzaOo = zzbdw2;
        }

        @Override
        public final void zzn(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzaOo.zza((zzbdz)new zzac(invitation));
            }
        }

        @Override
        public final void onInvitationRemoved(String string) {
            this.zzaOo.zza((zzbdz)new zzad(string));
        }
    }

    static final class zzae
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Invitations.LoadInvitationsResult> zzaIz;

        zzae(zzbaz<Invitations.LoadInvitationsResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzm(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzao(dataHolder));
        }
    }

    static final class zzbl
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Leaderboards.LoadPlayerScoreResult> zzaIz;

        zzbl(zzbaz<Leaderboards.LoadPlayerScoreResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzB(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzar(dataHolder));
        }
    }

    static final class zzah
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Leaderboards.LoadScoresResult> zzaIz;

        zzah(zzbaz<Leaderboards.LoadScoresResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzaIz.setResult((Object)new zzaw(dataHolder, dataHolder2));
        }
    }

    static final class zzai
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Leaderboards.LeaderboardMetadataResult> zzaIz;

        zzai(zzbaz<Leaderboards.LeaderboardMetadataResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzag(dataHolder));
        }
    }

    static final class zzu
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Events.LoadEventsResult> zzaIz;

        zzu(zzbaz<Events.LoadEventsResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzam(dataHolder));
        }
    }

    static final class zzx
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<GamesMetadata.LoadGamesResult> zzaIz;

        zzx(zzbaz<GamesMetadata.LoadGamesResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzl(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzan(dataHolder));
        }
    }

    static final class zze
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Achievements.UpdateAchievementResult> zzaIz;

        zze(zzbaz<Achievements.UpdateAchievementResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, String string) {
            this.zzaIz.setResult((Object)new zzcu(n, string));
        }
    }

    static final class zzf
    extends com.google.android.gms.games.internal.zza {
        private final zzbaz<Achievements.LoadAchievementsResult> zzaIz;

        zzf(zzbaz<Achievements.LoadAchievementsResult> zzbaz2) {
            this.zzaIz = (zzbaz)com.google.android.gms.common.internal.zzbo.zzb(zzbaz2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzf(DataHolder dataHolder) {
            this.zzaIz.setResult((Object)new zzal(dataHolder));
        }
    }

    final class zzv
    extends zzcaj {
        private /* synthetic */ GamesClientImpl zzaZz;

        public zzv(GamesClientImpl gamesClientImpl) {
            this.zzaZz = gamesClientImpl;
            super(gamesClientImpl.getContext().getMainLooper(), 1000);
        }

        @Override
        protected final void zzq(String string, int n) {
            try {
                if (this.zzaZz.isConnected()) {
                    ((com.google.android.gms.games.internal.zzj)this.zzaZz.zzrf()).zzn(string, n);
                    return;
                }
                com.google.android.gms.games.internal.zze.zzz("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
                return;
            }
        }
    }
}

