/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.zzb;
import java.util.ArrayList;
import java.util.Arrays;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzbcL;
    private final String zzalP;
    private final Uri zzaXU;
    private final int zzbcM;
    private final ArrayList<zzb> zzbcN;
    private final Game zzbcO;
    private final String zzaYf;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzbcL = leaderboard.getLeaderboardId();
        this.zzalP = leaderboard.getDisplayName();
        this.zzaXU = leaderboard.getIconImageUri();
        this.zzaYf = leaderboard.getIconImageUrl();
        this.zzbcM = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzbcO = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzbcN = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbcN.add((zzb)arrayList.get(i).freeze());
        }
    }

    @Override
    public final String getLeaderboardId() {
        return this.zzbcL;
    }

    @Override
    public final String getDisplayName() {
        return this.zzalP;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzalP, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzaXU;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzaYf;
    }

    @Override
    public final int getScoreOrder() {
        return this.zzbcM;
    }

    @Override
    public final ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzbcN);
    }

    @Override
    public final Game getGame() {
        return this.zzbcO;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return Arrays.hashCode(new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public final boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzbe.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzbe.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzbe.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzbe.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzbe.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public final String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzbe.zzt((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }
}

