/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.zzc;
import java.util.ArrayList;
import java.util.Arrays;

public final class TurnBasedMatchEntity
extends com.google.android.gms.games.internal.zzc
implements TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new zzc();
    private final GameEntity zzbbN;
    private final String zzaZZ;
    private final String zzbdN;
    private final long mCreationTimestamp;
    private final String zzbdV;
    private final long zzaZl;
    private final String zzbdW;
    private final int zzbdX;
    private final int zzbdu;
    private final int mVersion;
    private final byte[] zzbdY;
    private final ArrayList<ParticipantEntity> zzbdt;
    private final String zzbdZ;
    private final byte[] zzbea;
    private final int zzbeb;
    private final Bundle zzbdL;
    private final int zzbec;
    private final boolean zzbed;
    private final String zzafa;
    private final String zzbee;

    public TurnBasedMatchEntity(TurnBasedMatch turnBasedMatch) {
        this.zzbbN = new GameEntity(turnBasedMatch.getGame());
        this.zzaZZ = turnBasedMatch.getMatchId();
        this.zzbdN = turnBasedMatch.getCreatorId();
        this.mCreationTimestamp = turnBasedMatch.getCreationTimestamp();
        this.zzbdV = turnBasedMatch.getLastUpdaterId();
        this.zzaZl = turnBasedMatch.getLastUpdatedTimestamp();
        this.zzbdW = turnBasedMatch.getPendingParticipantId();
        this.zzbdX = turnBasedMatch.getStatus();
        this.zzbec = turnBasedMatch.getTurnStatus();
        this.zzbdu = turnBasedMatch.getVariant();
        this.mVersion = turnBasedMatch.getVersion();
        this.zzbdZ = turnBasedMatch.getRematchId();
        this.zzbeb = turnBasedMatch.getMatchNumber();
        this.zzbdL = turnBasedMatch.getAutoMatchCriteria();
        this.zzbed = turnBasedMatch.isLocallyModified();
        this.zzafa = turnBasedMatch.getDescription();
        this.zzbee = turnBasedMatch.getDescriptionParticipantId();
        byte[] byArray = turnBasedMatch.getData();
        if (byArray == null) {
            this.zzbdY = null;
        } else {
            this.zzbdY = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbdY, 0, byArray.length);
        }
        byte[] byArray2 = turnBasedMatch.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzbea = null;
        } else {
            this.zzbea = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzbea, 0, byArray2.length);
        }
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        this.zzbdt = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbdt.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(GameEntity gameEntity, String string, String string2, long l, String string3, long l2, String string4, int n, int n2, int n3, byte[] byArray, ArrayList<ParticipantEntity> arrayList, String string5, byte[] byArray2, int n4, Bundle bundle, int n5, boolean bl, String string6, String string7) {
        this.zzbbN = gameEntity;
        this.zzaZZ = string;
        this.zzbdN = string2;
        this.mCreationTimestamp = l;
        this.zzbdV = string3;
        this.zzaZl = l2;
        this.zzbdW = string4;
        this.zzbdX = n;
        this.zzbec = n5;
        this.zzbdu = n2;
        this.mVersion = n3;
        this.zzbdY = byArray;
        this.zzbdt = arrayList;
        this.zzbdZ = string5;
        this.zzbea = byArray2;
        this.zzbeb = n4;
        this.zzbdL = bundle;
        this.zzbed = bl;
        this.zzafa = string6;
        this.zzbee = string7;
    }

    @Override
    public final Game getGame() {
        return this.zzbbN;
    }

    @Override
    public final String getMatchId() {
        return this.zzaZZ;
    }

    @Override
    public final String getCreatorId() {
        return this.zzbdN;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final String getLastUpdaterId() {
        return this.zzbdV;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzaZl;
    }

    @Override
    public final String getPendingParticipantId() {
        return this.zzbdW;
    }

    @Override
    public final int getStatus() {
        return this.zzbdX;
    }

    @Override
    public final int getTurnStatus() {
        return this.zzbec;
    }

    @Override
    public final String getDescription() {
        return this.zzafa;
    }

    @Override
    public final String getDescriptionParticipantId() {
        return this.zzbee;
    }

    @Override
    public final Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzafa, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final int getVariant() {
        return this.zzbdu;
    }

    @Override
    public final byte[] getData() {
        return this.zzbdY;
    }

    @Override
    public final int getVersion() {
        return this.mVersion;
    }

    @Override
    public final String getRematchId() {
        return this.zzbdZ;
    }

    @Override
    public final byte[] getPreviousMatchData() {
        return this.zzbea;
    }

    @Override
    public final int getMatchNumber() {
        return this.zzbeb;
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        return this.zzbdL;
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        if (this.zzbdL == null) {
            return 0;
        }
        return this.zzbdL.getInt("max_automatch_players");
    }

    @Override
    public final boolean canRematch() {
        return this.zzbdX == 2 && this.zzbdZ == null;
    }

    @Override
    public final boolean isLocallyModified() {
        return this.zzbed;
    }

    @Override
    public final int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzbdt);
    }

    public final TurnBasedMatch freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return Arrays.hashCode(new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public final boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzbe.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzbe.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzbe.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzbe.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzbe.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzbe.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzbe.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzbe.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzbe.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzbe.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzbe.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzbe.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzbe.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzbe.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzbe.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzbe.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzbe.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzbe.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public final String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzbe.zzt((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TurnBasedMatchEntity turnBasedMatchEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)turnBasedMatchEntity.getGame(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)turnBasedMatchEntity.getMatchId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)turnBasedMatchEntity.getCreatorId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (long)turnBasedMatchEntity.getCreationTimestamp());
        zzd.zza((Parcel)parcel2, (int)5, (String)turnBasedMatchEntity.getLastUpdaterId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (long)turnBasedMatchEntity.getLastUpdatedTimestamp());
        zzd.zza((Parcel)parcel2, (int)7, (String)turnBasedMatchEntity.getPendingParticipantId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)8, (int)turnBasedMatchEntity.getStatus());
        zzd.zzc((Parcel)parcel2, (int)10, (int)turnBasedMatchEntity.getVariant());
        zzd.zzc((Parcel)parcel2, (int)11, (int)turnBasedMatchEntity.getVersion());
        zzd.zza((Parcel)parcel2, (int)12, (byte[])turnBasedMatchEntity.getData(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)13, turnBasedMatchEntity.getParticipants(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)14, (String)turnBasedMatchEntity.getRematchId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)15, (byte[])turnBasedMatchEntity.getPreviousMatchData(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)16, (int)turnBasedMatchEntity.getMatchNumber());
        zzd.zza((Parcel)parcel2, (int)17, (Bundle)turnBasedMatchEntity.getAutoMatchCriteria(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)18, (int)turnBasedMatchEntity.getTurnStatus());
        zzd.zza((Parcel)parcel2, (int)19, (boolean)turnBasedMatchEntity.isLocallyModified());
        zzd.zza((Parcel)parcel2, (int)20, (String)turnBasedMatchEntity.getDescription(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)21, (String)turnBasedMatchEntity.getDescriptionParticipantId(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        String string2 = String.valueOf(turnBasedMatch.getMatchId());
        throw new IllegalStateException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Participant ").append(string).append(" is not in match ").append(string2).toString());
    }
}

