/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzhdk;
    private final int zzeda;
    private final String mName;
    private final String zzdmz;
    private final Uri zzhdl;
    private final String zzhdm;
    private final Uri zzhdn;
    private final String zzhdo;
    private final int zzhdp;
    private final String zzhdq;
    private final PlayerEntity zzhdr;
    private final int mState;
    private final int zzhds;
    private final String zzhdt;
    private final long zzhdu;
    private final long zzhdv;

    public AchievementEntity(Achievement achievement) {
        this.zzhdk = achievement.getAchievementId();
        this.zzeda = achievement.getType();
        this.mName = achievement.getName();
        this.zzdmz = achievement.getDescription();
        this.zzhdl = achievement.getUnlockedImageUri();
        this.zzhdm = achievement.getUnlockedImageUrl();
        this.zzhdn = achievement.getRevealedImageUri();
        this.zzhdo = achievement.getRevealedImageUrl();
        this.zzhdr = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzhdu = achievement.getLastUpdatedTimestamp();
        this.zzhdv = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzhdp = achievement.getTotalSteps();
            this.zzhdq = achievement.getFormattedTotalSteps();
            this.zzhds = achievement.getCurrentSteps();
            this.zzhdt = achievement.getFormattedCurrentSteps();
        } else {
            this.zzhdp = 0;
            this.zzhdq = null;
            this.zzhds = 0;
            this.zzhdt = null;
        }
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzhdk);
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzdmz);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzhdk = string;
        this.zzeda = n;
        this.mName = string2;
        this.zzdmz = string3;
        this.zzhdl = uri;
        this.zzhdm = string4;
        this.zzhdn = uri2;
        this.zzhdo = string5;
        this.zzhdp = n2;
        this.zzhdq = string6;
        this.zzhdr = playerEntity;
        this.mState = n3;
        this.zzhds = n4;
        this.zzhdt = string7;
        this.zzhdu = l;
        this.zzhdv = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzhdk;
    }

    @Override
    public final int getType() {
        return this.zzeda;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdmz;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmz, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzhdl;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzhdm;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzhdn;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzhdo;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhdp;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhdq;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhdq, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzhdr;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhds;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhdt;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhdt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhdu;
    }

    @Override
    public final long getXpValue() {
        return this.zzhdv;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbf.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbf.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbf.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbf.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbf.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbf.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbf.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbf.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbf.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbf.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbh zzbh2 = zzbf.zzt((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbh2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbh2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbh2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzd.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzhdp);
        zzd.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzhdq, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzd.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzhds);
        zzd.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzhdt, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzd.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

