/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzhla;
    private final String zzhlb;
    private final String zzhlc;
    private final long zzhld;
    private final long zzhle;
    private final String zzhlf;
    private final Uri zzhlg;
    private final Uri zzhlh;
    private final PlayerEntity zzhli;
    private final String zzhlj;
    private final String zzhlk;
    private final String zzhll;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzhla = leaderboardScore.getRank();
        this.zzhlb = (String)zzbp.zzu((Object)leaderboardScore.getDisplayRank());
        this.zzhlc = (String)zzbp.zzu((Object)leaderboardScore.getDisplayScore());
        this.zzhld = leaderboardScore.getRawScore();
        this.zzhle = leaderboardScore.getTimestampMillis();
        this.zzhlf = leaderboardScore.getScoreHolderDisplayName();
        this.zzhlg = leaderboardScore.getScoreHolderIconImageUri();
        this.zzhlh = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzhli = player == null ? null : (PlayerEntity)player.freeze();
        this.zzhlj = leaderboardScore.getScoreTag();
        this.zzhlk = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzhll = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zzhla;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzhlb;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhlb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zzhlc;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhlc, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzhld;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zzhle;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzhli == null) {
            return this.zzhlf;
        }
        return this.zzhli.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhli == null) {
            zzg.zzb((String)this.zzhlf, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhli.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzhli == null) {
            return this.zzhlg;
        }
        return this.zzhli.getIconImageUri();
    }

    @Override
    public final String getScoreHolderIconImageUrl() {
        if (this.zzhli == null) {
            return this.zzhlk;
        }
        return this.zzhli.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzhli == null) {
            return this.zzhlh;
        }
        return this.zzhli.getHiResImageUri();
    }

    @Override
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzhli == null) {
            return this.zzhll;
        }
        return this.zzhli.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zzhli;
    }

    @Override
    public final String getScoreTag() {
        return this.zzhlj;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbf.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbf.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbf.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbf.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbf.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbf.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbf.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbf.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbf.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbf.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbf.zzt((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

