/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantRef
extends zzc
implements Participant {
    private final PlayerRef zzhmj;

    public ParticipantRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.zzhmj = new PlayerRef(dataHolder, n);
    }

    @Override
    public final int getStatus() {
        return this.getInteger("player_status");
    }

    @Override
    public final String zzaru() {
        return this.getString("client_address");
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.getInteger("connected") > 0;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzfv("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzhmj.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzfv("external_player_id")) {
            this.zza("default_display_name", charArrayBuffer);
            return;
        }
        this.zzhmj.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzfv("external_player_id")) {
            return this.zzfu("default_display_image_uri");
        }
        return this.zzhmj.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzfv("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzhmj.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzfv("external_player_id")) {
            return this.zzfu("default_display_hi_res_image_uri");
        }
        return this.zzhmj.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzfv("external_player_id")) {
            return this.getString("default_display_hi_res_image_url");
        }
        return this.zzhmj.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.getString("external_participant_id");
    }

    @Override
    public final Player getPlayer() {
        if (this.zzfv("external_player_id")) {
            return null;
        }
        return this.zzhmj;
    }

    @Override
    public final ParticipantResult getResult() {
        if (this.zzfv("result_type")) {
            return null;
        }
        int n = this.getInteger("result_type");
        int n2 = this.getInteger("placing");
        return new ParticipantResult(this.getParticipantId(), n, n2);
    }

    @Override
    public final int getCapabilities() {
        return this.getInteger("capabilities");
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((ParticipantEntity)((Participant)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        ParticipantRef participantRef = this;
        return new ParticipantEntity(participantRef);
    }
}

