/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.zzc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class QuestEntity
extends com.google.android.gms.games.internal.zzc
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new zzc();
    private final GameEntity zzhiw;
    private final String zzhnr;
    private final long zzhns;
    private final Uri zzhnt;
    private final String zzhnu;
    private final String zzdmz;
    private final long zzhnv;
    private final long zzhdu;
    private final Uri zzhnw;
    private final String zzhnx;
    private final String mName;
    private final long zzhny;
    private final long zzhnz;
    private final int mState;
    private final int zzeda;
    private final ArrayList<MilestoneEntity> zzhoa;

    public QuestEntity(Quest quest) {
        this.zzhiw = new GameEntity(quest.getGame());
        this.zzhnr = quest.getQuestId();
        this.zzhns = quest.getAcceptedTimestamp();
        this.zzdmz = quest.getDescription();
        this.zzhnt = quest.getBannerImageUri();
        this.zzhnu = quest.getBannerImageUrl();
        this.zzhnv = quest.getEndTimestamp();
        this.zzhnw = quest.getIconImageUri();
        this.zzhnx = quest.getIconImageUrl();
        this.zzhdu = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzhny = quest.zzarx();
        this.zzhnz = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzeda = quest.getType();
        List<Milestone> list = quest.zzarw();
        int n = list.size();
        this.zzhoa = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhoa.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n, int n2, ArrayList<MilestoneEntity> arrayList) {
        this.zzhiw = gameEntity;
        this.zzhnr = string;
        this.zzhns = l;
        this.zzhnt = uri;
        this.zzhnu = string2;
        this.zzdmz = string3;
        this.zzhnv = l2;
        this.zzhdu = l3;
        this.zzhnw = uri2;
        this.zzhnx = string4;
        this.mName = string5;
        this.zzhny = l4;
        this.zzhnz = l5;
        this.mState = n;
        this.zzeda = n2;
        this.zzhoa = arrayList;
    }

    @Override
    public final String getQuestId() {
        return this.zzhnr;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdmz;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmz, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhnw;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhnx;
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzhnt;
    }

    @Override
    public final String getBannerImageUrl() {
        return this.zzhnu;
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzarw().get(0);
    }

    @Override
    public final List<Milestone> zzarw() {
        return new ArrayList<Milestone>(this.zzhoa);
    }

    @Override
    public final Game getGame() {
        return this.zzhiw;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getType() {
        return this.zzeda;
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.zzhns;
    }

    @Override
    public final long getEndTimestamp() {
        return this.zzhnv;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhdu;
    }

    @Override
    public final long zzarx() {
        return this.zzhny;
    }

    @Override
    public final long getStartTimestamp() {
        return this.zzhnz;
    }

    @Override
    public final boolean isEndingSoon() {
        return this.zzhny <= System.currentTimeMillis() + 1800000L;
    }

    public final Quest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return Arrays.hashCode(new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzarw(), quest.getName(), quest.zzarx(), quest.getStartTimestamp(), quest.getState()});
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzbf.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzbf.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzbf.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzbf.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzbf.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzbf.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzbf.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzbf.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzbf.equal(quest2.zzarw(), quest.zzarw()) && zzbf.equal((Object)quest2.getName(), (Object)quest.getName()) && zzbf.equal((Object)quest2.zzarx(), (Object)quest.zzarx()) && zzbf.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzbf.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzbf.zzt((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzarw()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzarx()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        QuestEntity questEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)questEntity.getGame(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)questEntity.getQuestId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)questEntity.getAcceptedTimestamp());
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)questEntity.getBannerImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)questEntity.getBannerImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)questEntity.getDescription(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (long)questEntity.getEndTimestamp());
        zzd.zza((Parcel)parcel2, (int)8, (long)questEntity.getLastUpdatedTimestamp());
        zzd.zza((Parcel)parcel2, (int)9, (Parcelable)questEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)10, (String)questEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)questEntity.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)13, (long)questEntity.zzhny);
        zzd.zza((Parcel)parcel2, (int)14, (long)questEntity.getStartTimestamp());
        zzd.zzc((Parcel)parcel2, (int)15, (int)questEntity.getState());
        zzd.zzc((Parcel)parcel2, (int)16, (int)questEntity.zzeda);
        zzd.zzc((Parcel)parcel2, (int)17, questEntity.zzarw(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

