/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.zza;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class GameRequestEntity
extends zzc
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new zza();
    private final GameEntity zzhiw;
    private final PlayerEntity zzhob;
    private final byte[] zzhnh;
    private final String zzcjq;
    private final ArrayList<PlayerEntity> zzhoc;
    private final int zzeda;
    private final long mCreationTimestamp;
    private final long zzhod;
    private final Bundle zzhoe;
    private final int zzbyx;

    public GameRequestEntity(GameRequest gameRequest) {
        this.zzhiw = new GameEntity(gameRequest.getGame());
        this.zzhob = new PlayerEntity(gameRequest.getSender());
        this.zzcjq = gameRequest.getRequestId();
        this.zzeda = gameRequest.getType();
        this.mCreationTimestamp = gameRequest.getCreationTimestamp();
        this.zzhod = gameRequest.getExpirationTimestamp();
        this.zzbyx = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzhnh = null;
        } else {
            this.zzhnh = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzhnh, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzhoc = new ArrayList(n);
        this.zzhoe = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzhoc.add((PlayerEntity)player);
            this.zzhoe.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zzhiw = gameEntity;
        this.zzhob = playerEntity;
        this.zzhnh = byArray;
        this.zzcjq = string;
        this.zzhoc = arrayList;
        this.zzeda = n;
        this.mCreationTimestamp = l;
        this.zzhod = l2;
        this.zzhoe = bundle;
        this.zzbyx = n2;
    }

    @Override
    public final String getRequestId() {
        return this.zzcjq;
    }

    @Override
    public final Game getGame() {
        return this.zzhiw;
    }

    @Override
    public final Player getSender() {
        return this.zzhob;
    }

    @Override
    public final List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzhoc);
    }

    @Override
    public final boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public final byte[] getData() {
        return this.zzhnh;
    }

    @Override
    public final int getType() {
        return this.zzeda;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final long getExpirationTimestamp() {
        return this.zzhod;
    }

    @Override
    public final int getRecipientStatus(String string) {
        return this.zzhoe.getInt(string, 0);
    }

    @Override
    public final int getStatus() {
        return this.zzbyx;
    }

    public final GameRequest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return Arrays.hashCode(new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public final boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzbf.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzbf.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzbf.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzbf.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzbf.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzbf.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzbf.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public final String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzbf.zzt((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameRequestEntity gameRequestEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (Parcelable)gameRequestEntity.getGame(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)gameRequestEntity.getSender(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (byte[])gameRequestEntity.getData(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)gameRequestEntity.getRequestId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, gameRequestEntity.getRecipients(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)gameRequestEntity.getType());
        zzd.zza((Parcel)parcel2, (int)9, (long)gameRequestEntity.getCreationTimestamp());
        zzd.zza((Parcel)parcel2, (int)10, (long)gameRequestEntity.getExpirationTimestamp());
        zzd.zza((Parcel)parcel2, (int)11, (Bundle)gameRequestEntity.zzhoe, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)12, (int)gameRequestEntity.getStatus());
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

