/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.zza;
import java.util.Arrays;

public final class VideoCapabilities
extends zzc {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new zza();
    private final boolean zzhpm;
    private final boolean zzhpn;
    private final boolean zzhpo;
    private final boolean[] zzhpp;
    private final boolean[] zzhpq;

    public VideoCapabilities(boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.zzhpm = bl;
        this.zzhpn = bl2;
        this.zzhpo = bl3;
        this.zzhpp = blArray;
        this.zzhpq = blArray2;
    }

    public final boolean isMicSupported() {
        return this.zzhpn;
    }

    public final boolean isCameraSupported() {
        return this.zzhpm;
    }

    public final boolean isWriteStorageSupported() {
        return this.zzhpo;
    }

    public final boolean[] getSupportedCaptureModes() {
        return this.zzhpp;
    }

    public final boolean[] getSupportedQualityLevels() {
        return this.zzhpq;
    }

    public final boolean supportsCaptureMode(int n) {
        zzbp.zzbg((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzhpp[n];
    }

    public final boolean supportsQualityLevel(int n) {
        zzbp.zzbg((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zzhpq[n];
    }

    public final boolean isFullySupported(int n, int n2) {
        return this.zzhpm && this.zzhpn && this.zzhpo && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzbf.equal((Object)videoCapabilities.getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && zzbf.equal((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && zzbf.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzbf.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzbf.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public final String toString() {
        return zzbf.zzt((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).zzg("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoCapabilities videoCapabilities = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (boolean)videoCapabilities.isCameraSupported());
        zzd.zza((Parcel)parcel2, (int)2, (boolean)videoCapabilities.isMicSupported());
        zzd.zza((Parcel)parcel2, (int)3, (boolean)videoCapabilities.isWriteStorageSupported());
        zzd.zza((Parcel)parcel2, (int)4, (boolean[])videoCapabilities.getSupportedCaptureModes(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (boolean[])videoCapabilities.getSupportedQualityLevels(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }
}

