/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.games.video.zzb;

public final class VideoConfiguration
extends zza {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zzhpr;
    private final int zzhpk;
    private final String zzhps;
    private final String zzhpt;
    private final String zzhpu;
    private final String zzhpv;
    private final boolean zzhpw;

    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbp.zzbh((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbp.zzbh((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zzhpr = n;
        this.zzhpk = n2;
        this.zzhpw = bl;
        if (n2 == 1) {
            this.zzhpt = string2;
            this.zzhps = string;
            this.zzhpu = string3;
            this.zzhpv = string4;
            return;
        }
        zzbp.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbp.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbp.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbp.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zzhpt = null;
        this.zzhps = null;
        this.zzhpu = null;
        this.zzhpv = null;
    }

    public final int getQualityLevel() {
        return this.zzhpr;
    }

    public final int getCaptureMode() {
        return this.zzhpk;
    }

    public final String getStreamUrl() {
        return this.zzhps;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzd.zzc((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzd.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zzhpt, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zzhpu, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zzhpv, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzhpw);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzhpr;
        private int zzhpk;
        private boolean zzhpw;
        private String zzhps;
        private String zzhpt;
        private String zzhpu;
        private String zzhpv;

        public Builder(int n, int n2) {
            this.zzhpr = n;
            this.zzhpk = n2;
            this.zzhpw = true;
            this.zzhps = null;
            this.zzhpt = null;
            this.zzhpu = null;
            this.zzhpv = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zzhpr = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zzhpk = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zzhpr, this.zzhpk, null, null, null, null, this.zzhpw);
        }
    }
}

