/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzg;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzezu;
    private String zzebw;
    private final Uri zzhbl;
    private final Uri zzhbm;
    private final long zzhcv;
    private final int zzhcw;
    private final long zzhcx;
    private final String zzhbw;
    private final String zzhbx;
    private final String zzehj;
    private final zzb zzhcy;
    private final PlayerLevelInfo zzhcz;
    private final boolean zzhda;
    private final boolean zzhdb;
    private final String zzhdc;
    private final String mName;
    private final Uri zzhdd;
    private final String zzhde;
    private final Uri zzhdf;
    private final String zzhdg;
    private final int zzhdh;
    private final long zzhdi;
    private final boolean zzdii;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    private PlayerEntity(Player player, boolean bl) {
        this.zzezu = player.getPlayerId();
        this.zzebw = player.getDisplayName();
        this.zzhbl = player.getIconImageUri();
        this.zzhbw = player.getIconImageUrl();
        this.zzhbm = player.getHiResImageUri();
        this.zzhbx = player.getHiResImageUrl();
        this.zzhcv = player.getRetrievedTimestamp();
        this.zzhcw = player.zzapq();
        this.zzhcx = player.getLastPlayedWithTimestamp();
        this.zzehj = player.getTitle();
        this.zzhda = player.zzapr();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzaps();
        this.zzhcy = zza2 == null ? null : new zzb(zza2);
        this.zzhcz = player.getLevelInfo();
        this.zzhdb = player.zzapp();
        this.zzhdc = player.zzapo();
        this.mName = player.getName();
        this.zzhdd = player.getBannerImageLandscapeUri();
        this.zzhde = player.getBannerImageLandscapeUrl();
        this.zzhdf = player.getBannerImagePortraitUri();
        this.zzhdg = player.getBannerImagePortraitUrl();
        this.zzhdh = player.zzapt();
        this.zzhdi = player.zzapu();
        this.zzdii = player.isMuted();
        zzc.zzr((Object)this.zzezu);
        zzc.zzr((Object)this.zzebw);
        zzc.zzbg((this.zzhcv > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzezu = string;
        this.zzebw = string2;
        this.zzhbl = uri;
        this.zzhbw = string3;
        this.zzhbm = uri2;
        this.zzhbx = string4;
        this.zzhcv = l;
        this.zzhcw = n;
        this.zzhcx = l2;
        this.zzehj = string5;
        this.zzhda = bl;
        this.zzhcy = zzb2;
        this.zzhcz = playerLevelInfo;
        this.zzhdb = bl2;
        this.zzhdc = string6;
        this.mName = string7;
        this.zzhdd = uri3;
        this.zzhde = string8;
        this.zzhdf = uri4;
        this.zzhdg = string9;
        this.zzhdh = n2;
        this.zzhdi = l3;
        this.zzdii = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzezu;
    }

    @Override
    public final String getDisplayName() {
        return this.zzebw;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzg.zzb((String)this.zzebw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String zzapo() {
        return this.zzhdc;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final boolean zzapp() {
        return this.zzhdb;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhbl;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhbw;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhbm;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhbx;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzhcv;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzhcx;
    }

    @Override
    public final int zzapq() {
        return this.zzhcw;
    }

    @Override
    public final boolean zzapr() {
        return this.zzhda;
    }

    @Override
    public final String getTitle() {
        return this.zzehj;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzg.zzb((String)this.zzehj, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzhcz;
    }

    @Override
    public final com.google.android.gms.games.internal.player.zza zzaps() {
        return this.zzhcy;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzhdd;
    }

    @Override
    public final String getBannerImageLandscapeUrl() {
        return this.zzhde;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzhdf;
    }

    @Override
    public final String getBannerImagePortraitUrl() {
        return this.zzhdg;
    }

    @Override
    public final int zzapt() {
        return this.zzhdh;
    }

    @Override
    public final long zzapu() {
        return this.zzhdi;
    }

    @Override
    public final boolean isMuted() {
        return this.zzdii;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzapp(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzapo(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzapt(), player.zzapu(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbf.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbf.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbf.equal((Object)player2.zzapp(), (Object)player.zzapp()) && zzbf.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbf.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbf.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbf.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbf.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbf.equal((Object)player2.zzapo(), (Object)player.zzapo()) && zzbf.equal((Object)player2.getName(), (Object)player.getName()) && zzbf.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbf.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbf.equal((Object)player2.zzapt(), (Object)player.zzapt()) && zzbf.equal((Object)player2.zzapu(), (Object)player.zzapu()) && zzbf.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbf.zzt((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzapp()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzapo()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzapt()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzapu()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzbcn.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzhcw);
        zzbcn.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzhcy, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzhda);
        zzbcn.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzhdb);
        zzbcn.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzhdc, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzhdh);
        zzbcn.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzhdi);
        zzbcn.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzdii);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzg {
        zza() {
        }

        @Override
        public final PlayerEntity zzj(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzakd()) || PlayerEntity.zzgb((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzj(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzg)this).zzj(parcel);
        }
    }
}

