/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzhds;
    private final int zzecy;
    private final String mName;
    private final String zzdmt;
    private final Uri zzhdt;
    private final String zzhdu;
    private final Uri zzhdv;
    private final String zzhdw;
    private final int zzhdx;
    private final String zzhdy;
    private final PlayerEntity zzhdz;
    private final int mState;
    private final int zzhea;
    private final String zzheb;
    private final long zzhec;
    private final long zzhed;

    public AchievementEntity(Achievement achievement) {
        this.zzhds = achievement.getAchievementId();
        this.zzecy = achievement.getType();
        this.mName = achievement.getName();
        this.zzdmt = achievement.getDescription();
        this.zzhdt = achievement.getUnlockedImageUri();
        this.zzhdu = achievement.getUnlockedImageUrl();
        this.zzhdv = achievement.getRevealedImageUri();
        this.zzhdw = achievement.getRevealedImageUrl();
        this.zzhdz = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzhec = achievement.getLastUpdatedTimestamp();
        this.zzhed = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzhdx = achievement.getTotalSteps();
            this.zzhdy = achievement.getFormattedTotalSteps();
            this.zzhea = achievement.getCurrentSteps();
            this.zzheb = achievement.getFormattedCurrentSteps();
        } else {
            this.zzhdx = 0;
            this.zzhdy = null;
            this.zzhea = 0;
            this.zzheb = null;
        }
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzhds);
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzdmt);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzhds = string;
        this.zzecy = n;
        this.mName = string2;
        this.zzdmt = string3;
        this.zzhdt = uri;
        this.zzhdu = string4;
        this.zzhdv = uri2;
        this.zzhdw = string5;
        this.zzhdx = n2;
        this.zzhdy = string6;
        this.zzhdz = playerEntity;
        this.mState = n3;
        this.zzhea = n4;
        this.zzheb = string7;
        this.zzhec = l;
        this.zzhed = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzhds;
    }

    @Override
    public final int getType() {
        return this.zzecy;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdmt;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzhdt;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzhdu;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzhdv;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzhdw;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhdx;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhdy;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhdy, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzhdz;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhea;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzheb;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzheb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhec;
    }

    @Override
    public final long getXpValue() {
        return this.zzhed;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbf.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbf.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbf.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbf.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbf.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbf.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbf.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbf.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbf.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbf.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbh zzbh2 = zzbf.zzt((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbh2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbh2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbh2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzbcn.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzhdx);
        zzbcn.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzhdy, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzbcn.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzhea);
        zzbcn.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzheb, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

