/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.zze;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzhnh;
    private final TurnBasedMatchBuffer zzhni;
    private final TurnBasedMatchBuffer zzhnj;
    private final TurnBasedMatchBuffer zzhnk;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzhnh = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzhni = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzhnj = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        if (dataHolder4 != null) {
            this.zzhnk = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzhnk = null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zze.zzx("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zzhnh;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzhni;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzhnj;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzhnk;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zzhnh != null) {
            this.zzhnh.release();
        }
        if (this.zzhni != null) {
            this.zzhni.release();
        }
        if (this.zzhnj != null) {
            this.zzhnj.release();
        }
        if (this.zzhnk != null) {
            this.zzhnk.release();
        }
    }

    public final boolean hasData() {
        if (this.zzhnh != null && this.zzhnh.getCount() > 0) {
            return true;
        }
        if (this.zzhni != null && this.zzhni.getCount() > 0) {
            return true;
        }
        if (this.zzhnj != null && this.zzhnj.getCount() > 0) {
            return true;
        }
        return this.zzhnk != null && this.zzhnk.getCount() > 0;
    }
}

