/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntity;
import java.util.ArrayList;

public final class zzd
extends zzc
implements TurnBasedMatch {
    private final Game zzhlf;
    private final int zzhlg;

    zzd(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.zzhlf = new GameRef(dataHolder, n);
        this.zzhlg = n2;
    }

    @Override
    public final Game getGame() {
        return this.zzhlf;
    }

    @Override
    public final String getMatchId() {
        return this.getString("external_match_id");
    }

    @Override
    public final String getCreatorId() {
        return this.getString("creator_external");
    }

    @Override
    public final long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public final int getStatus() {
        return this.getInteger("status");
    }

    @Override
    public final int getTurnStatus() {
        return this.getInteger("user_match_status");
    }

    @Override
    public final String getDescription() {
        return this.getString("description");
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("description", charArrayBuffer);
    }

    @Override
    public final String getDescriptionParticipantId() {
        return this.getString("description_participant_id");
    }

    @Override
    public final Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public final int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public final ArrayList<Participant> getParticipants() {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.zzhlg);
        for (int i = 0; i < this.zzhlg; ++i) {
            arrayList.add(new ParticipantRef(this.zzfle, this.zzfqg + i));
        }
        return arrayList;
    }

    @Override
    public final String getLastUpdaterId() {
        return this.getString("last_updater_external");
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.getLong("last_updated_timestamp");
    }

    @Override
    public final String getPendingParticipantId() {
        return this.getString("pending_participant_external");
    }

    @Override
    public final byte[] getData() {
        return this.getByteArray("data");
    }

    @Override
    public final int getVersion() {
        return this.getInteger("version");
    }

    @Override
    public final String getRematchId() {
        return this.getString("rematch_id");
    }

    @Override
    public final byte[] getPreviousMatchData() {
        return this.getByteArray("previous_match_data");
    }

    @Override
    public final int getMatchNumber() {
        return this.getInteger("match_number");
    }

    @Override
    public final Bundle getAutoMatchCriteria() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return null;
        }
        int n = this.getInteger("automatch_min_players");
        int n2 = this.getInteger("automatch_max_players");
        long l = this.getLong("automatch_bit_mask");
        return TurnBasedMatchConfig.createAutoMatchCriteria(n, n2, l);
    }

    @Override
    public final int getAvailableAutoMatchSlots() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return 0;
        }
        return this.getInteger("automatch_max_players");
    }

    @Override
    public final boolean canRematch() {
        return this.getTurnStatus() == 3 && this.getRematchId() == null && this.getParticipants().size() > 1;
    }

    @Override
    public final boolean isLocallyModified() {
        return this.getBoolean("upsync_required");
    }

    @Override
    public final int getParticipantStatus(String string) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, string);
    }

    @Override
    public final ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public final String getParticipantId(String string) {
        return TurnBasedMatchEntity.zzb(this, string);
    }

    @Override
    public final Participant getParticipant(String string) {
        return TurnBasedMatchEntity.zzc(this, string);
    }

    public final int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, object);
    }

    public final String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((TurnBasedMatchEntity)((TurnBasedMatch)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        zzd zzd2 = this;
        return new TurnBasedMatchEntity(zzd2);
    }
}

