/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.zzc;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class QuestEntity
extends com.google.android.gms.games.internal.zzc
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new zzc();
    private final GameEntity zzhje;
    private final String zzhnz;
    private final long zzhoa;
    private final Uri zzhob;
    private final String zzhoc;
    private final String zzdmt;
    private final long zzhod;
    private final long zzhec;
    private final Uri zzhoe;
    private final String zzhof;
    private final String mName;
    private final long zzhog;
    private final long zzhoh;
    private final int mState;
    private final int zzecy;
    private final ArrayList<MilestoneEntity> zzhoi;

    public QuestEntity(Quest quest) {
        this.zzhje = new GameEntity(quest.getGame());
        this.zzhnz = quest.getQuestId();
        this.zzhoa = quest.getAcceptedTimestamp();
        this.zzdmt = quest.getDescription();
        this.zzhob = quest.getBannerImageUri();
        this.zzhoc = quest.getBannerImageUrl();
        this.zzhod = quest.getEndTimestamp();
        this.zzhoe = quest.getIconImageUri();
        this.zzhof = quest.getIconImageUrl();
        this.zzhec = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzhog = quest.zzarz();
        this.zzhoh = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzecy = quest.getType();
        List<Milestone> list = quest.zzary();
        int n = list.size();
        this.zzhoi = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhoi.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n, int n2, ArrayList<MilestoneEntity> arrayList) {
        this.zzhje = gameEntity;
        this.zzhnz = string;
        this.zzhoa = l;
        this.zzhob = uri;
        this.zzhoc = string2;
        this.zzdmt = string3;
        this.zzhod = l2;
        this.zzhec = l3;
        this.zzhoe = uri2;
        this.zzhof = string4;
        this.mName = string5;
        this.zzhog = l4;
        this.zzhoh = l5;
        this.mState = n;
        this.zzecy = n2;
        this.zzhoi = arrayList;
    }

    @Override
    public final String getQuestId() {
        return this.zzhnz;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdmt;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhoe;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhof;
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzhob;
    }

    @Override
    public final String getBannerImageUrl() {
        return this.zzhoc;
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzary().get(0);
    }

    @Override
    public final List<Milestone> zzary() {
        return new ArrayList<Milestone>(this.zzhoi);
    }

    @Override
    public final Game getGame() {
        return this.zzhje;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getType() {
        return this.zzecy;
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.zzhoa;
    }

    @Override
    public final long getEndTimestamp() {
        return this.zzhod;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhec;
    }

    @Override
    public final long zzarz() {
        return this.zzhog;
    }

    @Override
    public final long getStartTimestamp() {
        return this.zzhoh;
    }

    @Override
    public final boolean isEndingSoon() {
        return this.zzhog <= System.currentTimeMillis() + 1800000L;
    }

    public final Quest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return Arrays.hashCode(new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzary(), quest.getName(), quest.zzarz(), quest.getStartTimestamp(), quest.getState()});
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzbf.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzbf.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzbf.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzbf.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzbf.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzbf.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzbf.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzbf.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzbf.equal(quest2.zzary(), quest.zzary()) && zzbf.equal((Object)quest2.getName(), (Object)quest.getName()) && zzbf.equal((Object)quest2.zzarz(), (Object)quest.zzarz()) && zzbf.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzbf.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzbf.zzt((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzary()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzarz()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        QuestEntity questEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (Parcelable)questEntity.getGame(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)questEntity.getQuestId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (long)questEntity.getAcceptedTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)questEntity.getBannerImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (String)questEntity.getBannerImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (String)questEntity.getDescription(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (long)questEntity.getEndTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)8, (long)questEntity.getLastUpdatedTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)9, (Parcelable)questEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)10, (String)questEntity.getIconImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)12, (String)questEntity.getName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)13, (long)questEntity.zzhog);
        zzbcn.zza((Parcel)parcel2, (int)14, (long)questEntity.getStartTimestamp());
        zzbcn.zzc((Parcel)parcel2, (int)15, (int)questEntity.getState());
        zzbcn.zzc((Parcel)parcel2, (int)16, (int)questEntity.zzecy);
        zzbcn.zzc((Parcel)parcel2, (int)17, questEntity.zzary(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

