/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotMetadataRef
extends zzc
implements SnapshotMetadata {
    private final Game zzhlf;
    private final Player zzhpf;

    public SnapshotMetadataRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
        this.zzhlf = new GameRef(dataHolder, n);
        this.zzhpf = new PlayerRef(dataHolder, n);
    }

    @Override
    public final Game getGame() {
        return this.zzhlf;
    }

    @Override
    public final Player getOwner() {
        return this.zzhpf;
    }

    @Override
    public final String getSnapshotId() {
        return this.getString("external_snapshot_id");
    }

    @Override
    public final Uri getCoverImageUri() {
        return this.zzfv("cover_icon_image_uri");
    }

    @Override
    public final String getCoverImageUrl() {
        return this.getString("cover_icon_image_url");
    }

    @Override
    public final float getCoverImageAspectRatio() {
        float f = this.getFloat("cover_icon_image_height");
        float f2 = this.getFloat("cover_icon_image_width");
        if (f == 0.0f) {
            return 0.0f;
        }
        return f2 / f;
    }

    @Override
    public final String getUniqueName() {
        return this.getString("unique_name");
    }

    @Override
    public final String getTitle() {
        return this.getString("title");
    }

    @Override
    public final String getDescription() {
        return this.getString("description");
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("description", charArrayBuffer);
    }

    @Override
    public final long getLastModifiedTimestamp() {
        return this.getLong("last_modified_timestamp");
    }

    @Override
    public final long getPlayedTime() {
        return this.getLong("duration");
    }

    @Override
    public final boolean hasChangePending() {
        return this.getInteger("pending_change_count") > 0;
    }

    @Override
    public final long getProgressValue() {
        return this.getLong("progress_value");
    }

    @Override
    public final String getDeviceName() {
        return this.getString("device_name");
    }

    public final int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return SnapshotMetadataEntity.zza(this, object);
    }

    public final String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((SnapshotMetadataEntity)((SnapshotMetadata)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        SnapshotMetadataRef snapshotMetadataRef = this;
        return new SnapshotMetadataEntity(snapshotMetadataRef);
    }
}

