/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.internal.zze;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.zzb;
import com.google.android.gms.internal.zzbcn;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public final class zza
extends zzc
implements SnapshotContents {
    private static final Object zzhon = new Object();
    public static final Parcelable.Creator<zza> CREATOR = new zzb();
    private com.google.android.gms.drive.zzc zzghr;

    public zza(com.google.android.gms.drive.zzc zzc2) {
        this.zzghr = zzc2;
    }

    @Override
    public final ParcelFileDescriptor getParcelFileDescriptor() {
        zzbp.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Cannot mutate closed contents!");
        return this.zzghr.getParcelFileDescriptor();
    }

    @Override
    public final com.google.android.gms.drive.zzc zzamr() {
        return this.zzghr;
    }

    @Override
    public final void close() {
        this.zzghr = null;
    }

    @Override
    public final boolean isClosed() {
        return this.zzghr == null;
    }

    @Override
    public final byte[] readFully() throws IOException {
        zzbp.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened Snapshot");
        Object object = zzhon;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.zzghr.getParcelFileDescriptor();
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                fileInputStream.getChannel().position(0L);
                byte[] byArray = zzm.zza((InputStream)bufferedInputStream, (boolean)false);
                fileInputStream.getChannel().position(0L);
                return byArray;
            }
            catch (IOException iOException) {
                zze.zzc("SnapshotContentsEntity", "Failed to read snapshot data", iOException);
                throw iOException;
            }
        }
    }

    @Override
    public final boolean writeBytes(byte[] byArray) {
        return this.zza(0, byArray, 0, byArray.length, true);
    }

    @Override
    public final boolean modifyBytes(int n, byte[] byArray, int n2, int n3) {
        return this.zza(n, byArray, n2, byArray.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, byte[] byArray, int n2, int n3, boolean bl) {
        zzbp.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened SnapshotContents");
        Object object = zzhon;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.zzghr.getParcelFileDescriptor();
            FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.position(n);
                ((OutputStream)bufferedOutputStream).write(byArray, n2, n3);
                if (bl) {
                    fileChannel.truncate(byArray.length);
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            catch (IOException iOException) {
                zze.zzb("SnapshotContentsEntity", "Failed to write snapshot data", iOException);
                return false;
            }
            return true;
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zza zza2 = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (Parcelable)zza2.zzghr, (int)n, (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

