/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzg;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzezv;
    private String zzebx;
    private final Uri zzhbm;
    private final Uri zzhbn;
    private final long zzhcw;
    private final int zzhcx;
    private final long zzhcy;
    private final String zzhbx;
    private final String zzhby;
    private final String zzehk;
    private final zzb zzhcz;
    private final PlayerLevelInfo zzhda;
    private final boolean zzhdb;
    private final boolean zzhdc;
    private final String zzhdd;
    private final String mName;
    private final Uri zzhde;
    private final String zzhdf;
    private final Uri zzhdg;
    private final String zzhdh;
    private final int zzhdi;
    private final long zzhdj;
    private final boolean zzdij;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    private PlayerEntity(Player player, boolean bl) {
        this.zzezv = player.getPlayerId();
        this.zzebx = player.getDisplayName();
        this.zzhbm = player.getIconImageUri();
        this.zzhbx = player.getIconImageUrl();
        this.zzhbn = player.getHiResImageUri();
        this.zzhby = player.getHiResImageUrl();
        this.zzhcw = player.getRetrievedTimestamp();
        this.zzhcx = player.zzapp();
        this.zzhcy = player.getLastPlayedWithTimestamp();
        this.zzehk = player.getTitle();
        this.zzhdb = player.zzapq();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzapr();
        this.zzhcz = zza2 == null ? null : new zzb(zza2);
        this.zzhda = player.getLevelInfo();
        this.zzhdc = player.zzapo();
        this.zzhdd = player.zzapn();
        this.mName = player.getName();
        this.zzhde = player.getBannerImageLandscapeUri();
        this.zzhdf = player.getBannerImageLandscapeUrl();
        this.zzhdg = player.getBannerImagePortraitUri();
        this.zzhdh = player.getBannerImagePortraitUrl();
        this.zzhdi = player.zzaps();
        this.zzhdj = player.zzapt();
        this.zzdij = player.isMuted();
        zzc.zzr((Object)this.zzezv);
        zzc.zzr((Object)this.zzebx);
        zzc.zzbg((this.zzhcw > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzezv = string;
        this.zzebx = string2;
        this.zzhbm = uri;
        this.zzhbx = string3;
        this.zzhbn = uri2;
        this.zzhby = string4;
        this.zzhcw = l;
        this.zzhcx = n;
        this.zzhcy = l2;
        this.zzehk = string5;
        this.zzhdb = bl;
        this.zzhcz = zzb2;
        this.zzhda = playerLevelInfo;
        this.zzhdc = bl2;
        this.zzhdd = string6;
        this.mName = string7;
        this.zzhde = uri3;
        this.zzhdf = string8;
        this.zzhdg = uri4;
        this.zzhdh = string9;
        this.zzhdi = n2;
        this.zzhdj = l3;
        this.zzdij = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzezv;
    }

    @Override
    public final String getDisplayName() {
        return this.zzebx;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzg.zzb((String)this.zzebx, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String zzapn() {
        return this.zzhdd;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final boolean zzapo() {
        return this.zzhdc;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhbm;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhbx;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhbn;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhby;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzhcw;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzhcy;
    }

    @Override
    public final int zzapp() {
        return this.zzhcx;
    }

    @Override
    public final boolean zzapq() {
        return this.zzhdb;
    }

    @Override
    public final String getTitle() {
        return this.zzehk;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzg.zzb((String)this.zzehk, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzhda;
    }

    @Override
    public final com.google.android.gms.games.internal.player.zza zzapr() {
        return this.zzhcz;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzhde;
    }

    @Override
    public final String getBannerImageLandscapeUrl() {
        return this.zzhdf;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzhdg;
    }

    @Override
    public final String getBannerImagePortraitUrl() {
        return this.zzhdh;
    }

    @Override
    public final int zzaps() {
        return this.zzhdi;
    }

    @Override
    public final long zzapt() {
        return this.zzhdj;
    }

    @Override
    public final boolean isMuted() {
        return this.zzdij;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzapo(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzapn(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzaps(), player.zzapt(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbf.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbf.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbf.equal((Object)player2.zzapo(), (Object)player.zzapo()) && zzbf.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbf.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbf.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbf.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbf.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbf.equal((Object)player2.zzapn(), (Object)player.zzapn()) && zzbf.equal((Object)player2.getName(), (Object)player.getName()) && zzbf.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbf.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbf.equal((Object)player2.zzaps(), (Object)player.zzaps()) && zzbf.equal((Object)player2.zzapt(), (Object)player.zzapt()) && zzbf.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbf.zzt((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzapo()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzapn()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzaps()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzapt()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzbcn.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzhcx);
        zzbcn.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzhcz, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzhdb);
        zzbcn.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzhdc);
        zzbcn.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzhdd, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzhdi);
        zzbcn.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzhdj);
        zzbcn.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzdij);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzg {
        zza() {
        }

        @Override
        public final PlayerEntity zzj(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzakc()) || PlayerEntity.zzgb((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzj(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzg)this).zzj(parcel);
        }
    }
}

