/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzbvs;
import com.google.android.gms.internal.zzbvu;
import com.google.android.gms.internal.zzbvv;
import com.google.android.gms.internal.zzcqc;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends com.google.android.gms.common.internal.zzaa<com.google.android.gms.games.internal.zzj> {
    private zzbvu zzheh = new com.google.android.gms.games.internal.zzd(this);
    private final String zzhei;
    private PlayerEntity zzhej;
    private GameEntity zzhek;
    private final com.google.android.gms.games.internal.zzn zzhel;
    private boolean zzhem = false;
    private final Binder zzhen;
    private final long zzheo;
    private final Games.GamesOptions zzhep;
    private boolean zzheq = false;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzq zzq2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzhei = zzq2.zzaju();
        this.zzhen = new Binder();
        int n = zzq2.zzajq();
        GamesClientImpl gamesClientImpl = this;
        this.zzhel = new com.google.android.gms.games.internal.zzq(gamesClientImpl, n);
        this.zzheo = ((Object)((Object)this)).hashCode();
        this.zzhep = gamesOptions;
        if (!this.zzhep.zzhcu) {
            this.zzs(zzq2.zzajw());
        }
    }

    public final boolean zzaac() {
        return true;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzhem = false;
    }

    public final void zzdd(int n) {
        int n2;
        this.zzhel.zzhhd.gravity = n2 = n;
    }

    public final void zzs(View view) {
        this.zzhel.zzt(view);
    }

    protected final Set<Scope> zzb(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            com.google.android.gms.common.internal.zzbp.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            com.google.android.gms.common.internal.zzbp.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public final void zza(com.google.android.gms.common.internal.zzj zzj2) {
        GamesClientImpl gamesClientImpl = this;
        this.zzhej = null;
        gamesClientImpl.zzhek = null;
        super.zza(zzj2);
    }

    public final void disconnect() {
        this.zzhem = false;
        if (this.isConnected()) {
            try {
                com.google.android.gms.games.internal.zzj zzj2 = (com.google.android.gms.games.internal.zzj)this.zzajj();
                zzj2.zzaqt();
                this.zzheh.flush();
                zzj2.zzac(this.zzheo);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.games.internal.zze.zzw("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected final String zzhc() {
        return "com.google.android.gms.games.service.START";
    }

    protected final String zzhd() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    public final Bundle zzaeh() {
        try {
            Bundle bundle = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaeh();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    protected final Bundle zzzu() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzhep.zzapm();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzhei);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzhel.zzhhd.zzhhe));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzcqc.zza((com.google.android.gms.common.internal.zzq)this.zzakd()));
        return bundle;
    }

    public final String zzapw() {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzapw();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzb(String string, com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) throws RemoteException {
        com.google.android.gms.common.internal.zzbp.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(string, new zzy(zzn2));
    }

    public final String zzbj(boolean bl) {
        if (this.zzhej != null) {
            return this.zzhej.getPlayerId();
        }
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqv();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Player zzapx() {
        this.zzaji();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhej == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqw());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzhej = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesClientImpl.zzd(remoteException);
                }
            }
        }
        return this.zzhej;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Game zzapy() {
        this.zzaji();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhek == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqx());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzhek = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesClientImpl.zzd(remoteException);
                }
            }
        }
        return this.zzhek;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzbn(zzn2), string, bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbn(zzn2), n, bl, bl2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbn(zzn2), string, n, bl, bl2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc((com.google.android.gms.games.internal.zzf)new zzbn(zzn2), bl);
    }

    public final Intent zzapz() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzapz();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzj(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzk(string, n, n2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzai(zzn2), bl);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, String string, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzai(zzn2), string, bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2, String string, String string2, int n, int n2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbl(zzn2), null, string2, n, n2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(new zzah(zzn2), string, n, n2, n3, bl);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(new zzah(zzn2), string, n, n2, n3, bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzah(zzn2), leaderboardScoreBuffer.zzarr().asBundle(), n, n2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2, String string, long l, String string2) throws RemoteException {
        zzcl zzcl2 = zzn2 == null ? null : new zzcl(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zzcl2, string, l, string2);
    }

    public final Intent zzaqa() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqa();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzf(zzn2), bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zze2, string, this.zzhel.zzhhd.zzhhe, this.zzhel.zzhhd.zzara());
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(zze2, string, this.zzhel.zzhhd.zzhhe, this.zzhel.zzhhd.zzara());
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zze2, string, n, this.zzhel.zzhhd.zzhhe, this.zzhel.zzhhd.zzara());
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(zze2, string, n, this.zzhel.zzhhd.zzhhe, this.zzhel.zzhhd.zzara());
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl) throws RemoteException {
        this.zzheh.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zze((com.google.android.gms.games.internal.zzf)new zzu(zzn2), bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzheh.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzu(zzn2), bl, stringArray);
    }

    public final void zzp(String string, int n) {
        this.zzheh.zzp(string, n);
    }

    public final Intent zzaqb() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqb();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzaqc() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqc();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzcj<OnInvitationReceivedListener> zzcj2) {
        try {
            zzab zzab2 = new zzab(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zzab2, this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqd() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzad(this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzcj<OnTurnBasedMatchUpdateReceivedListener> zzcj2) {
        try {
            zzaz zzaz2 = new zzaz(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)zzaz2, this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqe() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzae(this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzcj<QuestUpdateListener> zzcj2) {
        try {
            zzbs zzbs2 = new zzbs(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd((com.google.android.gms.games.internal.zzf)zzbs2, this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqf() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzag(this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzcj<OnRequestReceivedListener> zzcj2) {
        try {
            zzbw zzbw2 = new zzbw(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc((com.google.android.gms.games.internal.zzf)zzbw2, this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqg() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaf(this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzaqh() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqh();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzaqi() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqi();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(new zzx(zzn2));
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) throws RemoteException {
        this.zzheh.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(new zzcg(zzn2));
    }

    public final int zzaqj() {
        int n = 4368;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqj();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final String getAppId() {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).getAppId();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzae(zzn2), n);
    }

    public final void zzq(String string, int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzq(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzr(String string, int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzr(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzco(zzn2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzarw(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzco(zzn2), string);
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc((com.google.android.gms.games.internal.zzf)new zzco(zzn2), string);
    }

    public final int zzaqk() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqk();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcs(zzn2), string, byArray, string2, participantResultArray);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcs(zzn2), string, byArray, participantResultArray);
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zze((com.google.android.gms.games.internal.zzf)new zzcp(zzn2), string);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string, String string2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcp(zzn2), string, string2);
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd((com.google.android.gms.games.internal.zzf)new zzcn(zzn2), string);
    }

    public final void zzhj(String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzhm(string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2, int n, int[] nArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzct(zzn2), n, nArray);
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzf((com.google.android.gms.games.internal.zzf)new zzcq(zzn2), string);
    }

    public final Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzcj<RoomUpdateListener> zzcj2, com.google.android.gms.common.api.internal.zzcj<RoomStatusUpdateListener> zzcj3, com.google.android.gms.common.api.internal.zzcj<RealTimeMessageReceivedListener> zzcj4, RoomConfig roomConfig) {
        try {
            zzcc zzcc2 = new zzcc(zzcj2, zzcj3, zzcj4);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(zzcc2, (IBinder)this.zzhen, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzcj<RoomUpdateListener> zzcj2, com.google.android.gms.common.api.internal.zzcj<RoomStatusUpdateListener> zzcj3, com.google.android.gms.common.api.internal.zzcj<RealTimeMessageReceivedListener> zzcj4, RoomConfig roomConfig) {
        try {
            zzcc zzcc2 = new zzcc(zzcj2, zzcj3, zzcj4);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zzcc2, (IBinder)this.zzhen, roomConfig.getInvitationId(), false, this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzcj<RoomUpdateListener> zzcj2, String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcc(zzcj2), string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zza(com.google.android.gms.common.api.internal.zzcj<RealTimeMultiplayer.ReliableMessageSentCallback> zzcj2, byte[] byArray, String string, String string2) {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbv(zzcj2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string, String[] stringArray) {
        com.google.android.gms.common.internal.zzbp.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzd(byte[] byArray, String string) {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zzde(int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzde(n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzaql() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaql();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(n, byArray, n2, string);
            com.google.android.gms.common.internal.zzbp.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final int zzaqm() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqm();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzaqn() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqn();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzca(zzn2), stringArray);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzca(zzn2), stringArray);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2, int n, int n2, int n3) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbz(zzn2), n, n2, n3);
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzf((com.google.android.gms.games.internal.zzf)new zzbm(zzn2), bl);
    }

    public final Intent zzd(int[] nArray) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd(nArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzhk(String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzhk(string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2, String string) throws RemoteException {
        this.zzheh.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzh(new zzbp(zzn2), string);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string, String string2) throws RemoteException {
        this.zzheh.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzbr(zzn2, string2), string, string2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzheh.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbt(zzn2), nArray, n, bl);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzheh.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbt(zzn2), stringArray, bl);
    }

    public final void zzhl(String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(string, this.zzhel.zzhhd.zzhhe, this.zzhel.zzhhd.zzara());
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zzaqo() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqo();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzaqp() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqp();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd((com.google.android.gms.games.internal.zzf)new zzck(zzn2), bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, boolean bl, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcj(zzn2), string, bl, n);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbp.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzarz();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzamq();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzch(zzn2), snapshot.getMetadata().getSnapshotId(), (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
    }

    public final void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbp.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzamq();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzg(new zzci(zzn2), string);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        com.google.android.gms.common.internal.zzbp.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzarz();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzamq();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcj(zzn2), string, string2, (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc(new zzj(zzn2));
    }

    public final Intent zzaqq() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqy();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd(new zzn(zzn2));
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzh(zzn2), n);
    }

    public final boolean zzaqr() {
        boolean bl = false;
        try {
            bl = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqr();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return bl;
    }

    public final void zze(com.google.android.gms.common.api.internal.zzcj<Videos.CaptureOverlayStateListener> zzcj2) {
        try {
            zzl zzl2 = new zzl(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zze((com.google.android.gms.games.internal.zzf)zzl2, this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqs() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzah(this.zzheo);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    public final void zzaqt() {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqt();
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    private static void zzd(RemoteException remoteException) {
        com.google.android.gms.games.internal.zze.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzak(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.zzb zzb2 = new com.google.android.gms.games.multiplayer.realtime.zzb(dataHolder);
        Room room = null;
        try {
            if (zzb2.getCount() > 0) {
                room = (Room)((Room)zzb2.get(0)).freeze();
            }
        }
        finally {
            zzb2.release();
        }
        return room;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzheq = this.zzhem = bundle.getBoolean("show_welcome_popup");
            this.zzhej = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzhek = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        com.google.android.gms.games.internal.zzj zzj2 = (com.google.android.gms.games.internal.zzj)iInterface;
        GamesClientImpl gamesClientImpl = this;
        super.zza((IInterface)zzj2);
        if (gamesClientImpl.zzhem) {
            gamesClientImpl.zzhel.zzaqz();
            gamesClientImpl.zzhem = false;
        }
        if (!gamesClientImpl.zzhep.zzhcm && !gamesClientImpl.zzhep.zzhcu) {
            com.google.android.gms.games.internal.zzj zzj3 = zzj2;
            GamesClientImpl gamesClientImpl2 = gamesClientImpl;
            try {
                zzbo zzbo2 = new zzbo(gamesClientImpl2.zzhel);
                zzj3.zza(zzbo2, gamesClientImpl2.zzheo);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof com.google.android.gms.games.internal.zzj) {
            return (com.google.android.gms.games.internal.zzj)iInterface;
        }
        return new com.google.android.gms.games.internal.zzk(iBinder2);
    }

    static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final String zzad;

        public final Status getStatus() {
            throw new NoSuchMethodError();
        }

        @Override
        public final String getUrl() {
            return this.zzad;
        }
    }

    static final class zzo
    implements Videos.CaptureStateResult {
        private final Status mStatus;
        private final CaptureState zzhey;

        zzo(Status status, CaptureState captureState) {
            this.mStatus = status;
            this.zzhey = captureState;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final CaptureState getCaptureState() {
            return this.zzhey;
        }
    }

    static final class zzk
    implements Videos.CaptureCapabilitiesResult {
        private final Status mStatus;
        private final VideoCapabilities zzhew;

        zzk(Status status, VideoCapabilities videoCapabilities) {
            this.mStatus = status;
            this.zzhew = videoCapabilities;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final VideoCapabilities getCapabilities() {
            return this.zzhew;
        }
    }

    static final class zzi
    implements Videos.CaptureAvailableResult {
        private final Status mStatus;
        private final boolean zzhev;

        zzi(Status status, boolean bl) {
            this.mStatus = status;
            this.zzhev = bl;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final boolean isAvailable() {
            return this.zzhev;
        }
    }

    static final class zzs
    implements Snapshots.DeleteSnapshotResult {
        private final Status mStatus;
        private final String zzhfb;

        zzs(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdc(n);
            this.zzhfb = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getSnapshotId() {
            return this.zzhfb;
        }
    }

    static final class zzq
    extends zzw
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzhfa;

        zzq(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzhfa = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
                return;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public final SnapshotMetadata getSnapshotMetadata() {
            return this.zzhfa;
        }
    }

    static final class zzbc
    extends zzw
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzhfu;
        private final String zzhfv;
        private final Snapshot zzhfw;
        private final com.google.android.gms.drive.zzc zzhfx;
        private final SnapshotContents zzhfy;

        zzbc(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        zzbc(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzhfu = null;
                    this.zzhfw = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzc.zzbg((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhfu = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    this.zzhfw = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhfu = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzhfw = new SnapshotEntity(snapshotMetadataEntity2, new com.google.android.gms.games.snapshot.zza(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzhfv = string;
            this.zzhfx = zzc4;
            this.zzhfy = new com.google.android.gms.games.snapshot.zza(zzc4);
        }

        @Override
        public final Snapshot getSnapshot() {
            return this.zzhfu;
        }

        @Override
        public final String getConflictId() {
            return this.zzhfv;
        }

        @Override
        public final Snapshot getConflictingSnapshot() {
            return this.zzhfw;
        }

        @Override
        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzhfy;
        }
    }

    static final class zzax
    extends zzw
    implements Snapshots.LoadSnapshotsResult {
        zzax(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzflf);
        }
    }

    static final class zzas
    extends zzw
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzhfm;

        zzas(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzhfm = playerStatsBuffer.getCount() > 0 ? new com.google.android.gms.games.stats.zza((PlayerStats)playerStatsBuffer.get(0)) : null;
                return;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public final PlayerStats getPlayerStats() {
            return this.zzhfm;
        }
    }

    static final class zzp
    extends zzw
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzhez;
        private final Quest zzhet;

        zzp(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzhet = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzhet.zzarx();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzhez = list.get(i);
                        return;
                    }
                    this.zzhez = null;
                } else {
                    this.zzhez = null;
                    this.zzhet = null;
                }
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Milestone getMilestone() {
            return this.zzhez;
        }

        @Override
        public final Quest getQuest() {
            return this.zzhet;
        }
    }

    static final class zzd
    extends zzw
    implements Quests.AcceptQuestResult {
        private final Quest zzhet;

        zzd(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzhet = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Quest getQuest() {
            return this.zzhet;
        }
    }

    static final class zzau
    extends zzw
    implements Quests.LoadQuestsResult {
        private final DataHolder zzflf;

        zzau(DataHolder dataHolder) {
            super(dataHolder);
            this.zzflf = dataHolder;
        }

        @Override
        public final QuestBuffer getQuests() {
            return new QuestBuffer(this.zzflf);
        }
    }

    static final class zzav
    implements Requests.LoadRequestsResult {
        private final Status mStatus;
        private final Bundle zzhfo;

        zzav(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhfo = bundle;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final GameRequestBuffer getRequests(int n) {
            String string;
            switch (n) {
                case 1: {
                    String string2 = "GIFT";
                    break;
                }
                case 2: {
                    String string2 = "WISH";
                    break;
                }
                default: {
                    com.google.android.gms.games.internal.zze.zzx("RequestType", new StringBuilder(33).append("Unknown request type: ").append(n).toString());
                    String string2 = string = "UNKNOWN_TYPE";
                }
            }
            if (!this.zzhfo.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzhfo.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public final void release() {
            for (String string : this.zzhfo.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzhfo.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    static final class zzcw
    extends zzw
    implements Requests.UpdateRequestsResult {
        private final zzbvv zzhgx;

        zzcw(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhgx = zzbvv.zzan(dataHolder);
        }

        @Override
        public final int getRequestOutcome(String string) {
            return this.zzhgx.getRequestOutcome(string);
        }

        @Override
        public final Set<String> getRequestIds() {
            return this.zzhgx.getRequestIds();
        }
    }

    static final class zzz
    implements Games.GetServerAuthCodeResult {
        private final Status mStatus;
        private final String zzhfc;

        zzz(Status status, String string) {
            this.mStatus = status;
            this.zzhfc = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getCode() {
            return this.zzhfc;
        }
    }

    static final class zzg
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status mStatus;
        private final String zzheu;

        zzg(Status status, String string) {
            this.mStatus = status;
            this.zzheu = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMatchId() {
            return this.zzheu;
        }
    }

    static final class zzaj
    extends zzcr
    implements TurnBasedMultiplayer.LeaveMatchResult {
        zzaj(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzcv
    extends zzcr
    implements TurnBasedMultiplayer.UpdateMatchResult {
        zzcv(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzaa
    extends zzcr
    implements TurnBasedMultiplayer.InitiateMatchResult {
        zzaa(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzap
    extends zzcr
    implements TurnBasedMultiplayer.LoadMatchResult {
        zzap(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static abstract class zzcr
    extends zzw {
        private TurnBasedMatch zzhfs;

        zzcr(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzhfs = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzhfs;
        }
    }

    static final class zzcm
    extends zzw
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzhgq;

        public zzcm(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzhgq = new ScoreSubmissionData(dataHolder);
                return;
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public final ScoreSubmissionData getScoreData() {
            return this.zzhgq;
        }
    }

    static final class zzat
    extends zzw
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzhfn;

        zzat(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhfn = new PlayerBuffer(dataHolder);
        }

        @Override
        public final PlayerBuffer getPlayers() {
            return this.zzhfn;
        }
    }

    static final class zzaq
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status mStatus;
        private final LoadMatchesResponse zzhfk;

        zzaq(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhfk = new LoadMatchesResponse(bundle);
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final LoadMatchesResponse getMatches() {
            return this.zzhfk;
        }

        public final void release() {
            this.zzhfk.release();
        }
    }

    static final class zzao
    extends zzw
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzhfj;

        zzao(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhfj = new InvitationBuffer(dataHolder);
        }

        @Override
        public final InvitationBuffer getInvitations() {
            return this.zzhfj;
        }
    }

    static final class zzar
    extends zzw
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzhfl;

        zzar(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzhfl = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public final LeaderboardScore getScore() {
            return this.zzhfl;
        }
    }

    static final class zzaw
    extends zzw
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzhfp;
        private final LeaderboardScoreBuffer zzhfq;

        zzaw(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzhfp = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzhfq = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public final Leaderboard getLeaderboard() {
            return this.zzhfp;
        }

        @Override
        public final LeaderboardScoreBuffer getScores() {
            return this.zzhfq;
        }
    }

    static final class zzag
    extends zzw
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzhfe;

        zzag(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhfe = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public final LeaderboardBuffer getLeaderboards() {
            return this.zzhfe;
        }
    }

    static final class zzan
    extends zzw
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzhfi;

        zzan(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhfi = new GameBuffer(dataHolder);
        }

        @Override
        public final GameBuffer getGames() {
            return this.zzhfi;
        }
    }

    static final class zzam
    extends zzw
    implements Events.LoadEventsResult {
        private final EventBuffer zzhfh;

        zzam(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhfh = new EventBuffer(dataHolder);
        }

        @Override
        public final EventBuffer getEvents() {
            return this.zzhfh;
        }
    }

    static final class zzcu
    implements Achievements.UpdateAchievementResult {
        private final Status mStatus;
        private final String zzhdt;

        zzcu(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdc(n);
            this.zzhdt = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getAchievementId() {
            return this.zzhdt;
        }
    }

    static final class zzal
    extends zzw
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzhfg;

        zzal(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhfg = new AchievementBuffer(dataHolder);
        }

        @Override
        public final AchievementBuffer getAchievements() {
            return this.zzhfg;
        }
    }

    static abstract class zzw
    extends com.google.android.gms.common.api.internal.zzam {
        protected zzw(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzdc(dataHolder.getStatusCode()));
        }
    }

    static final class zzbu
    implements com.google.android.gms.common.api.internal.zzcm<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzfac;
        private final String zzhge;
        private final int zzhgf;

        zzbu(int n, int n2, String string) {
            this.zzfac = n;
            this.zzhgf = n2;
            this.zzhge = string;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback = (RealTimeMultiplayer.ReliableMessageSentCallback)object;
            zzbu zzbu2 = this;
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(zzbu2.zzfac, zzbu2.zzhgf, zzbu2.zzhge);
            }
        }
    }

    static final class zzbb
    implements com.google.android.gms.common.api.internal.zzcm<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzhft;

        zzbb(RealTimeMessage realTimeMessage) {
            this.zzhft = realTimeMessage;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RealTimeMessageReceivedListener realTimeMessageReceivedListener = (RealTimeMessageReceivedListener)object;
            zzbb zzbb2 = this;
            realTimeMessageReceivedListener.onRealTimeMessageReceived(zzbb2.zzhft);
        }
    }

    static final class zzbe
    implements com.google.android.gms.common.api.internal.zzcm<RoomStatusUpdateListener> {
        private final String zzhfz;

        zzbe(String string) {
            this.zzhfz = string;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbe zzbe2 = this;
            roomStatusUpdateListener.onP2PDisconnected(zzbe2.zzhfz);
        }
    }

    static final class zzbd
    implements com.google.android.gms.common.api.internal.zzcm<RoomStatusUpdateListener> {
        private final String zzhfz;

        zzbd(String string) {
            this.zzhfz = string;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbd zzbd2 = this;
            roomStatusUpdateListener.onP2PConnected(zzbd2.zzhfz);
        }
    }

    static final class zzbh
    extends zza {
        zzbh(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    static final class zzbf
    extends zza {
        zzbf(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    static final class zzbg
    extends zza {
        zzbg(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    static final class zzbk
    extends zza {
        zzbk(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    static final class zzbj
    extends zza {
        zzbj(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    static final class zzbi
    extends zza {
        zzbi(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    static final class zzt
    extends zzc {
        zzt(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    static final class zzr
    extends zzc {
        zzr(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    static final class zzcb
    extends zzc {
        zzcb(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    static final class zzce
    extends zzc {
        zzce(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    static final class zzcd
    extends zzb {
        zzcd(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    static final class zzak
    implements com.google.android.gms.common.api.internal.zzcm<RoomUpdateListener> {
        private final int zzfac;
        private final String zzhff;

        zzak(int n, String string) {
            this.zzfac = n;
            this.zzhff = string;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            zzak zzak2 = this;
            roomUpdateListener.onLeftRoom(zzak2.zzfac, zzak2.zzhff);
        }
    }

    static final class zzaf
    extends zzb {
        public zzaf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    static final class zzcf
    extends zzb {
        public zzcf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    static abstract class zza
    extends zzc {
        private final ArrayList<String> zzhes = new ArrayList();

        zza(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzhes.add(stringArray[i]);
            }
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzhes);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    static abstract class zzc
    extends com.google.android.gms.common.api.internal.zzal<RoomStatusUpdateListener> {
        zzc(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzak(dataHolder2));
        }
    }

    static abstract class zzb
    extends com.google.android.gms.common.api.internal.zzal<RoomUpdateListener> {
        zzb(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            this.zza(roomUpdateListener, GamesClientImpl.zzak(dataHolder2), dataHolder2.getStatusCode());
        }
    }

    static final class zzby
    implements com.google.android.gms.common.api.internal.zzcm<OnRequestReceivedListener> {
        private final String zzcjw;

        zzby(String string) {
            this.zzcjw = string;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzby zzby2 = this;
            onRequestReceivedListener.onRequestRemoved(zzby2.zzcjw);
        }
    }

    static final class zzbx
    implements com.google.android.gms.common.api.internal.zzcm<OnRequestReceivedListener> {
        private final GameRequest zzhgh;

        zzbx(GameRequest gameRequest) {
            this.zzhgh = gameRequest;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzbx zzbx2 = this;
            onRequestReceivedListener.onRequestReceived(zzbx2.zzhgh);
        }
    }

    static final class zzbq
    implements com.google.android.gms.common.api.internal.zzcm<QuestUpdateListener> {
        private final Quest zzhet;

        zzbq(Quest quest) {
            this.zzhet = quest;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            QuestUpdateListener questUpdateListener = (QuestUpdateListener)object;
            zzbq zzbq2 = this;
            questUpdateListener.onQuestCompleted(zzbq2.zzhet);
        }
    }

    static final class zzay
    implements com.google.android.gms.common.api.internal.zzcm<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzhfr;

        zzay(String string) {
            this.zzhfr = string;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzay zzay2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(zzay2.zzhfr);
        }
    }

    static final class zzba
    implements com.google.android.gms.common.api.internal.zzcm<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzhfs;

        zzba(TurnBasedMatch turnBasedMatch) {
            this.zzhfs = turnBasedMatch;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzba zzba2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(zzba2.zzhfs);
        }
    }

    static final class zzad
    implements com.google.android.gms.common.api.internal.zzcm<OnInvitationReceivedListener> {
        private final String zzdwv;

        zzad(String string) {
            this.zzdwv = string;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzad zzad2 = this;
            onInvitationReceivedListener.onInvitationRemoved(zzad2.zzdwv);
        }
    }

    static final class zzac
    implements com.google.android.gms.common.api.internal.zzcm<OnInvitationReceivedListener> {
        private final Invitation zzhfd;

        zzac(Invitation invitation) {
            this.zzhfd = invitation;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzac zzac2 = this;
            onInvitationReceivedListener.onInvitationReceived(zzac2.zzhfd);
        }
    }

    static final class zzm
    implements com.google.android.gms.common.api.internal.zzcm<Videos.CaptureOverlayStateListener> {
        private final int zzhex;

        zzm(int n) {
            this.zzhex = n;
        }

        public final void zzagx() {
        }

        public final /* synthetic */ void zzq(Object object) {
            Videos.CaptureOverlayStateListener captureOverlayStateListener = (Videos.CaptureOverlayStateListener)object;
            zzm zzm2 = this;
            captureOverlayStateListener.onCaptureOverlayStateChanged(zzm2.zzhex);
        }
    }

    static final class zzn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzfwi;

        public zzn(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzd(int n, Bundle bundle) {
            this.zzfwi.setResult((Object)new zzo(new Status(n), CaptureState.zzp(bundle)));
        }
    }

    static final class zzl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<Videos.CaptureOverlayStateListener> zzgia;

        zzl(com.google.android.gms.common.api.internal.zzcj<Videos.CaptureOverlayStateListener> zzcj2) {
            this.zzgia = (com.google.android.gms.common.api.internal.zzcj)com.google.android.gms.common.internal.zzbp.zzb(zzcj2, (Object)"Callback must not be null");
        }

        @Override
        public final void onCaptureOverlayStateChanged(int n) {
            this.zzgia.zza((com.google.android.gms.common.api.internal.zzcm)new zzm(n));
        }
    }

    static final class zzj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzfwi;

        zzj(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzfwi.setResult((Object)new zzk(new Status(n), videoCapabilities));
        }
    }

    static final class zzh
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzfwi;

        zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, boolean bl) {
            this.zzfwi.setResult((Object)new zzi(new Status(n), bl));
        }
    }

    static final class zzci
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzfwi;

        public zzci(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(int n, String string) {
            this.zzfwi.setResult((Object)new zzs(n, string));
        }
    }

    static final class zzch
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzhgn;

        public zzch(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2) {
            this.zzhgn = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzae(DataHolder dataHolder) {
            this.zzhgn.setResult((Object)new zzq(dataHolder));
        }
    }

    static final class zzcj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzhgo;

        public zzcj(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2) {
            this.zzhgo = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzhgo.setResult((Object)new zzbc(dataHolder, zzc2));
        }

        @Override
        public final void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzhgo.setResult((Object)new zzbc(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    static final class zzck
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzhgp;

        public zzck(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2) {
            this.zzhgp = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzad(DataHolder dataHolder) {
            this.zzhgp.setResult((Object)new zzax(dataHolder));
        }
    }

    static final class zzbm
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzfwi;

        public zzbm(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzaj(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzas(dataHolder));
        }
    }

    static final class zzbt
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzhgd;

        public zzbt(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2) {
            this.zzhgd = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzai(DataHolder dataHolder) {
            this.zzhgd.setResult((Object)new zzau(dataHolder));
        }
    }

    static final class zzbr
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzhgb;
        private final String zzhgc;

        public zzbr(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string) {
            this.zzhgb = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
            this.zzhgc = (String)com.google.android.gms.common.internal.zzbp.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public final void zzaf(DataHolder dataHolder) {
            this.zzhgb.setResult((Object)new zzp(dataHolder, this.zzhgc));
        }
    }

    static final class zzbp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzhga;

        public zzbp(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2) {
            this.zzhga = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzag(DataHolder dataHolder) {
            this.zzhga.setResult((Object)new zzd(dataHolder));
        }
    }

    static final class zzbz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzhgi;

        public zzbz(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2) {
            this.zzhgi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdc(n);
            this.zzhgi.setResult((Object)new zzav(status, bundle));
        }
    }

    static final class zzca
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzhgj;

        public zzca(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2) {
            this.zzhgj = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzac(DataHolder dataHolder) {
            this.zzhgj.setResult((Object)new zzcw(dataHolder));
        }
    }

    static final class zzbo
    extends com.google.android.gms.games.internal.zzb {
        private final com.google.android.gms.games.internal.zzn zzhel;

        public zzbo(com.google.android.gms.games.internal.zzn zzn2) {
            this.zzhel = zzn2;
        }

        @Override
        public final com.google.android.gms.games.internal.zzl zzapv() {
            return new com.google.android.gms.games.internal.zzl(this.zzhel.zzhhd);
        }
    }

    static final class zzy
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzfwi;

        public zzy(com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzdc(n);
            this.zzfwi.setResult((Object)new zzz(status, string));
        }
    }

    static final class zzcg
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Status> zzfwi;

        public zzcg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzapu() {
            Status status = GamesStatusCodes.zzdc(0);
            this.zzfwi.setResult((Object)status);
        }
    }

    static final class zzbv
    extends com.google.android.gms.games.internal.zza {
        private com.google.android.gms.common.api.internal.zzcj<RealTimeMultiplayer.ReliableMessageSentCallback> zzhgg;

        public zzbv(com.google.android.gms.common.api.internal.zzcj<RealTimeMultiplayer.ReliableMessageSentCallback> zzcj2) {
            this.zzhgg = zzcj2;
        }

        @Override
        public final void zzb(int n, int n2, String string) {
            if (this.zzhgg != null) {
                this.zzhgg.zza((com.google.android.gms.common.api.internal.zzcm)new zzbu(n, n2, string));
            }
        }
    }

    static final class zzcc
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<? extends RoomUpdateListener> zzhgk;
        private final com.google.android.gms.common.api.internal.zzcj<? extends RoomStatusUpdateListener> zzhgl;
        private final com.google.android.gms.common.api.internal.zzcj<RealTimeMessageReceivedListener> zzhgm;

        public zzcc(com.google.android.gms.common.api.internal.zzcj<RoomUpdateListener> zzcj2) {
            this.zzhgk = (com.google.android.gms.common.api.internal.zzcj)com.google.android.gms.common.internal.zzbp.zzb(zzcj2, (Object)"Callbacks must not be null");
            this.zzhgl = null;
            this.zzhgm = null;
        }

        public zzcc(com.google.android.gms.common.api.internal.zzcj<? extends RoomUpdateListener> zzcj2, com.google.android.gms.common.api.internal.zzcj<? extends RoomStatusUpdateListener> zzcj3, com.google.android.gms.common.api.internal.zzcj<RealTimeMessageReceivedListener> zzcj4) {
            this.zzhgk = (com.google.android.gms.common.api.internal.zzcj)com.google.android.gms.common.internal.zzbp.zzb(zzcj2, (Object)"Callbacks must not be null");
            this.zzhgl = zzcj3;
            this.zzhgm = zzcj4;
        }

        @Override
        public final void zzu(DataHolder dataHolder) {
            this.zzhgk.zza((com.google.android.gms.common.api.internal.zzcm)new zzcf(dataHolder));
        }

        @Override
        public final void zzv(DataHolder dataHolder) {
            this.zzhgk.zza((com.google.android.gms.common.api.internal.zzcm)new zzaf(dataHolder));
        }

        @Override
        public final void onLeftRoom(int n, String string) {
            this.zzhgk.zza((com.google.android.gms.common.api.internal.zzcm)new zzak(n, string));
        }

        @Override
        public final void zzy(DataHolder dataHolder) {
            this.zzhgk.zza((com.google.android.gms.common.api.internal.zzcm)new zzcd(dataHolder));
        }

        @Override
        public final void zzw(DataHolder dataHolder) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzce(dataHolder));
            }
        }

        @Override
        public final void zzx(DataHolder dataHolder) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzcb(dataHolder));
            }
        }

        @Override
        public final void zzz(DataHolder dataHolder) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzr(dataHolder));
            }
        }

        @Override
        public final void zzaa(DataHolder dataHolder) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzt(dataHolder));
            }
        }

        @Override
        public final void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzbf(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzbh(dataHolder, stringArray));
            }
        }

        @Override
        public final void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzbi(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzbj(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzbk(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzbg(dataHolder, stringArray));
            }
        }

        @Override
        public final void onP2PConnected(String string) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzbd(string));
            }
        }

        @Override
        public final void onP2PDisconnected(String string) {
            if (this.zzhgl != null) {
                this.zzhgl.zza((com.google.android.gms.common.api.internal.zzcm)new zzbe(string));
            }
        }

        @Override
        public final void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzhgm != null) {
                this.zzhgm.zza((com.google.android.gms.common.api.internal.zzcm)new zzbb(realTimeMessage));
            }
        }
    }

    static final class zzcn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzhgr;

        public zzcn(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2) {
            this.zzhgr = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzdc(n);
            this.zzhgr.setResult((Object)new zzg(status, string));
        }
    }

    static final class zzcp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzhgt;

        public zzcp(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2) {
            this.zzhgt = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzs(DataHolder dataHolder) {
            this.zzhgt.setResult((Object)new zzaj(dataHolder));
        }
    }

    static final class zzcs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzhgv;

        public zzcs(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2) {
            this.zzhgv = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzr(DataHolder dataHolder) {
            this.zzhgv.setResult((Object)new zzcv(dataHolder));
        }
    }

    static final class zzco
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzhgs;

        public zzco(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2) {
            this.zzhgs = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzq(DataHolder dataHolder) {
            this.zzhgs.setResult((Object)new zzaa(dataHolder));
        }
    }

    static final class zzcq
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzhgu;

        public zzcq(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2) {
            this.zzhgu = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzp(DataHolder dataHolder) {
            this.zzhgu.setResult((Object)new zzap(dataHolder));
        }
    }

    static final class zzct
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzhgw;

        public zzct(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2) {
            this.zzhgw = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdc(n);
            this.zzhgw.setResult((Object)new zzaq(status, bundle));
        }
    }

    static final class zzcl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzfwi;

        public zzcl(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzcm(dataHolder));
        }
    }

    static final class zzbn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzfwi;

        zzbn(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzat(dataHolder));
        }

        @Override
        public final void zzk(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzat(dataHolder));
        }
    }

    static final class zzbw
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<OnRequestReceivedListener> zzgia;

        zzbw(com.google.android.gms.common.api.internal.zzcj<OnRequestReceivedListener> zzcj2) {
            this.zzgia = zzcj2;
        }

        @Override
        public final void zzo(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzgia.zza((com.google.android.gms.common.api.internal.zzcm)new zzbx(gameRequest));
            }
        }

        @Override
        public final void onRequestRemoved(String string) {
            this.zzgia.zza((com.google.android.gms.common.api.internal.zzcm)new zzby(string));
        }
    }

    static final class zzbs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<QuestUpdateListener> zzgia;

        zzbs(com.google.android.gms.common.api.internal.zzcj<QuestUpdateListener> zzcj2) {
            this.zzgia = zzcj2;
        }

        @Override
        public final void zzah(DataHolder dataHolder) {
            Quest quest = zzbs.zzam(dataHolder);
            if (quest != null) {
                this.zzgia.zza((com.google.android.gms.common.api.internal.zzcm)new zzbq(quest));
            }
        }

        private static Quest zzam(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    static final class zzaz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<OnTurnBasedMatchUpdateReceivedListener> zzgia;

        zzaz(com.google.android.gms.common.api.internal.zzcj<OnTurnBasedMatchUpdateReceivedListener> zzcj2) {
            this.zzgia = zzcj2;
        }

        @Override
        public final void zzt(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzgia.zza((com.google.android.gms.common.api.internal.zzcm)new zzba(turnBasedMatch));
            }
        }

        @Override
        public final void onTurnBasedMatchRemoved(String string) {
            this.zzgia.zza((com.google.android.gms.common.api.internal.zzcm)new zzay(string));
        }
    }

    static final class zzab
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<OnInvitationReceivedListener> zzgia;

        zzab(com.google.android.gms.common.api.internal.zzcj<OnInvitationReceivedListener> zzcj2) {
            this.zzgia = zzcj2;
        }

        @Override
        public final void zzn(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzgia.zza((com.google.android.gms.common.api.internal.zzcm)new zzac(invitation));
            }
        }

        @Override
        public final void onInvitationRemoved(String string) {
            this.zzgia.zza((com.google.android.gms.common.api.internal.zzcm)new zzad(string));
        }
    }

    static final class zzae
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzfwi;

        zzae(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzm(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzao(dataHolder));
        }
    }

    static final class zzbl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzfwi;

        zzbl(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzab(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzar(dataHolder));
        }
    }

    static final class zzah
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzfwi;

        zzah(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzfwi.setResult((Object)new zzaw(dataHolder, dataHolder2));
        }
    }

    static final class zzai
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzfwi;

        zzai(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzag(dataHolder));
        }
    }

    static final class zzu
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzfwi;

        zzu(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzam(dataHolder));
        }
    }

    static final class zzx
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzfwi;

        zzx(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzl(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzan(dataHolder));
        }
    }

    static final class zze
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzfwi;

        zze(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, String string) {
            this.zzfwi.setResult((Object)new zzcu(n, string));
        }
    }

    static final class zzf
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzfwi;

        zzf(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2) {
            this.zzfwi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzf(DataHolder dataHolder) {
            this.zzfwi.setResult((Object)new zzal(dataHolder));
        }
    }

    final class zzv
    extends zzbvs {
        private /* synthetic */ GamesClientImpl zzher;

        public zzv(GamesClientImpl gamesClientImpl) {
            this.zzher = gamesClientImpl;
            super(gamesClientImpl.getContext().getMainLooper(), 1000);
        }

        @Override
        protected final void zzs(String string, int n) {
            try {
                if (this.zzher.isConnected()) {
                    ((com.google.android.gms.games.internal.zzj)this.zzher.zzajj()).zzp(string, n);
                    return;
                }
                com.google.android.gms.games.internal.zze.zzx("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
                return;
            }
        }
    }
}

