/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzhlj;
    private final String zzhlk;
    private final String zzhll;
    private final long zzhlm;
    private final long zzhln;
    private final String zzhlo;
    private final Uri zzhlp;
    private final Uri zzhlq;
    private final PlayerEntity zzhlr;
    private final String zzhls;
    private final String zzhlt;
    private final String zzhlu;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzhlj = leaderboardScore.getRank();
        this.zzhlk = (String)zzbp.zzu((Object)leaderboardScore.getDisplayRank());
        this.zzhll = (String)zzbp.zzu((Object)leaderboardScore.getDisplayScore());
        this.zzhlm = leaderboardScore.getRawScore();
        this.zzhln = leaderboardScore.getTimestampMillis();
        this.zzhlo = leaderboardScore.getScoreHolderDisplayName();
        this.zzhlp = leaderboardScore.getScoreHolderIconImageUri();
        this.zzhlq = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzhlr = player == null ? null : (PlayerEntity)player.freeze();
        this.zzhls = leaderboardScore.getScoreTag();
        this.zzhlt = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzhlu = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zzhlj;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzhlk;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhlk, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zzhll;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhll, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzhlm;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zzhln;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzhlr == null) {
            return this.zzhlo;
        }
        return this.zzhlr.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhlr == null) {
            zzg.zzb((String)this.zzhlo, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhlr.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzhlr == null) {
            return this.zzhlp;
        }
        return this.zzhlr.getIconImageUri();
    }

    @Override
    public final String getScoreHolderIconImageUrl() {
        if (this.zzhlr == null) {
            return this.zzhlt;
        }
        return this.zzhlr.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzhlr == null) {
            return this.zzhlq;
        }
        return this.zzhlr.getHiResImageUri();
    }

    @Override
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzhlr == null) {
            return this.zzhlu;
        }
        return this.zzhlr.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zzhlr;
    }

    @Override
    public final String getScoreTag() {
        return this.zzhls;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbf.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbf.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbf.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbf.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbf.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbf.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbf.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbf.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbf.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbf.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbf.zzt((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

