/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.zze;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzhni;
    private final TurnBasedMatchBuffer zzhnj;
    private final TurnBasedMatchBuffer zzhnk;
    private final TurnBasedMatchBuffer zzhnl;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzhni = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzhnj = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzhnk = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        if (dataHolder4 != null) {
            this.zzhnl = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzhnl = null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zze.zzx("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zzhni;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzhnj;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzhnk;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzhnl;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zzhni != null) {
            this.zzhni.release();
        }
        if (this.zzhnj != null) {
            this.zzhnj.release();
        }
        if (this.zzhnk != null) {
            this.zzhnk.release();
        }
        if (this.zzhnl != null) {
            this.zzhnl.release();
        }
    }

    public final boolean hasData() {
        if (this.zzhni != null && this.zzhni.getCount() > 0) {
            return true;
        }
        if (this.zzhnj != null && this.zzhnj.getCount() > 0) {
            return true;
        }
        if (this.zzhnk != null && this.zzhnk.getCount() > 0) {
            return true;
        }
        return this.zzhnl != null && this.zzhnl.getCount() > 0;
    }
}

