/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzp;
import com.google.android.gms.games.zza;
import com.google.android.gms.games.zzb;
import com.google.android.gms.games.zzc;
import com.google.android.gms.games.zzd;
import com.google.android.gms.games.zze;
import com.google.android.gms.tasks.Task;

public class AchievementsClient
extends com.google.android.gms.games.internal.api.zzp {
    private static final zzbo<Achievements.LoadAchievementsResult, AchievementBuffer> zzhgu = new zzb();
    private static final zzbo<Achievements.UpdateAchievementResult, Void> zzhgv = new zzc();
    private static final zzbo<Achievements.UpdateAchievementResult, Boolean> zzhgw = new zzd();
    private static final zzp zzhgx = new zze();

    AchievementsClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    AchievementsClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Intent> getAchievementsIntent() {
        return this.zza(new zza(this));
    }

    public Task<AnnotatedData<AchievementBuffer>> load(boolean bl) {
        return zzg.zzc(Games.Achievements.load(this.zzagc(), bl), zzhgu);
    }

    public void reveal(@NonNull String string) {
        Games.Achievements.reveal(this.zzagc(), string);
    }

    public Task<Void> revealImmediate(@NonNull String string) {
        return AchievementsClient.zzc(Games.Achievements.revealImmediate(this.zzagc(), string));
    }

    public void unlock(@NonNull String string) {
        Games.Achievements.unlock(this.zzagc(), string);
    }

    public Task<Void> unlockImmediate(@NonNull String string) {
        return AchievementsClient.zzc(Games.Achievements.unlockImmediate(this.zzagc(), string));
    }

    public void increment(@NonNull String string, @IntRange(from=0L) int n) {
        Games.Achievements.increment(this.zzagc(), string, n);
    }

    public Task<Boolean> incrementImmediate(@NonNull String string, @IntRange(from=0L) int n) {
        return AchievementsClient.zzd(Games.Achievements.incrementImmediate(this.zzagc(), string, n));
    }

    public void setSteps(@NonNull String string, @IntRange(from=0L) int n) {
        Games.Achievements.setSteps(this.zzagc(), string, n);
    }

    public Task<Boolean> setStepsImmediate(@NonNull String string, @IntRange(from=0L) int n) {
        return AchievementsClient.zzd(Games.Achievements.setStepsImmediate(this.zzagc(), string, n));
    }

    private static Task<Void> zzc(@NonNull PendingResult<Achievements.UpdateAchievementResult> pendingResult) {
        return zzg.zza(pendingResult, zzhgx, zzhgv);
    }

    private static Task<Boolean> zzd(@NonNull PendingResult<Achievements.UpdateAchievementResult> pendingResult) {
        return zzg.zza(pendingResult, zzhgx, zzhgw);
    }
}

