/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzo;
import com.google.android.gms.games.internal.zzp;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.zzab;
import com.google.android.gms.games.zzac;
import com.google.android.gms.games.zzad;
import com.google.android.gms.games.zzae;
import com.google.android.gms.games.zzaf;
import com.google.android.gms.games.zzag;
import com.google.android.gms.games.zzah;
import com.google.android.gms.games.zzai;
import com.google.android.gms.games.zzaj;
import com.google.android.gms.games.zzak;
import com.google.android.gms.games.zzal;
import com.google.android.gms.games.zzam;
import com.google.android.gms.games.zzan;
import com.google.android.gms.tasks.Task;

public class LeaderboardsClient
extends com.google.android.gms.games.internal.api.zzp {
    private static final zzbo<Leaderboards.LeaderboardMetadataResult, LeaderboardBuffer> zzhiv = new zzal();
    private static final zzbo<Leaderboards.LeaderboardMetadataResult, Leaderboard> zzhiw = new zzam();
    private static final zzo<Leaderboards.LeaderboardMetadataResult> zzhix = new zzan();
    private static final zzbo<Leaderboards.LoadPlayerScoreResult, LeaderboardScore> zzhiy = new zzac();
    private static final zzp zzhiz = new zzad();
    private static final zzbo<Leaderboards.SubmitScoreResult, ScoreSubmissionData> zzhja = new zzae();
    private static final zzbo<Leaderboards.LoadScoresResult, LeaderboardScores> zzhjb = new zzaf();

    LeaderboardsClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    LeaderboardsClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Intent> getAllLeaderboardsIntent() {
        return this.zza(new zzab(this));
    }

    public Task<Intent> getLeaderboardIntent(@NonNull String string) {
        return this.zza(new zzag(this, string));
    }

    public Task<Intent> getLeaderboardIntent(@NonNull String string, int n) {
        return this.zza(new zzah(this, string, n));
    }

    public Task<Intent> getLeaderboardIntent(@NonNull String string, int n, int n2) {
        return this.zza(new zzai(this, string, n, n2));
    }

    public Task<AnnotatedData<LeaderboardBuffer>> loadLeaderboardMetadata(boolean bl) {
        return zzg.zzc(Games.Leaderboards.loadLeaderboardMetadata(this.zzagc(), bl), zzhiv);
    }

    public Task<AnnotatedData<Leaderboard>> loadLeaderboardMetadata(@NonNull String string, boolean bl) {
        return zzg.zza(Games.Leaderboards.loadLeaderboardMetadata(this.zzagc(), string, bl), zzhiw, zzhix);
    }

    public Task<AnnotatedData<LeaderboardScore>> loadCurrentPlayerLeaderboardScore(@NonNull String string, int n, int n2) {
        return zzg.zzb(Games.Leaderboards.loadCurrentPlayerLeaderboardScore(this.zzagc(), string, n, n2), zzhiy);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadTopScores(@NonNull String string, int n, int n2, @IntRange(from=1L, to=25L) int n3) {
        return zzg.zzc(Games.Leaderboards.loadTopScores(this.zzagc(), string, n, n2, n3), zzhjb);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadTopScores(@NonNull String string, int n, int n2, @IntRange(from=1L, to=25L) int n3, boolean bl) {
        return zzg.zzc(Games.Leaderboards.loadTopScores(this.zzagc(), string, n, n2, n3, bl), zzhjb);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadPlayerCenteredScores(@NonNull String string, int n, int n2, @IntRange(from=1L, to=25L) int n3) {
        return zzg.zzc(Games.Leaderboards.loadPlayerCenteredScores(this.zzagc(), string, n, n2, n3), zzhjb);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadPlayerCenteredScores(@NonNull String string, int n, int n2, @IntRange(from=1L, to=25L) int n3, boolean bl) {
        return zzg.zzc(Games.Leaderboards.loadPlayerCenteredScores(this.zzagc(), string, n, n2, n3, bl), zzhjb);
    }

    public Task<AnnotatedData<LeaderboardScores>> loadMoreScores(@NonNull LeaderboardScoreBuffer leaderboardScoreBuffer, @IntRange(from=1L, to=25L) int n, int n2) {
        return zzg.zzc(Games.Leaderboards.loadMoreScores(this.zzagc(), leaderboardScoreBuffer, n, n2), zzhjb);
    }

    public void submitScore(@NonNull String string, long l) {
        this.zzb(new zzaj(this, string, l));
    }

    public void submitScore(@NonNull String string, long l, @NonNull String string2) {
        this.zzb(new zzak(this, string, l, string2));
    }

    public Task<ScoreSubmissionData> submitScoreImmediate(@NonNull String string, long l) {
        return zzg.zza(Games.Leaderboards.submitScoreImmediate(this.zzagc(), string, l), zzhiz, zzhja);
    }

    public Task<ScoreSubmissionData> submitScoreImmediate(@NonNull String string, long l, @NonNull String string2) {
        return zzg.zza(Games.Leaderboards.submitScoreImmediate(this.zzagc(), string, l, string2), zzhiz, zzhja);
    }

    public static class LeaderboardScores
    implements Releasable {
        private final Leaderboard zzhjh;
        private final LeaderboardScoreBuffer zzhji;

        LeaderboardScores(@Nullable Leaderboard leaderboard, @NonNull LeaderboardScoreBuffer leaderboardScoreBuffer) {
            this.zzhjh = leaderboard;
            this.zzhji = leaderboardScoreBuffer;
        }

        @Nullable
        public Leaderboard getLeaderboard() {
            return this.zzhjh;
        }

        @NonNull
        public LeaderboardScoreBuffer getScores() {
            return this.zzhji;
        }

        public void release() {
            if (this.zzhji != null) {
                this.zzhji.release();
            }
        }
    }
}

