/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzap;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzfct;
    private String zzeeg;
    private final Uri zzhhf;
    private final Uri zzhhg;
    private final long zzhjk;
    private final int zzhjl;
    private final long zzhjm;
    private final String zzhhq;
    private final String zzhhr;
    private final String zzekd;
    private final zzb zzhjn;
    private final PlayerLevelInfo zzhjo;
    private final boolean zzhjp;
    private final boolean zzhjq;
    private final String zzhjr;
    private final String mName;
    private final Uri zzhjs;
    private final String zzhjt;
    private final Uri zzhju;
    private final String zzhjv;
    private final int zzhjw;
    private final long zzhjx;
    private final boolean zzhjy;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    private PlayerEntity(Player player, boolean bl) {
        this.zzfct = player.getPlayerId();
        this.zzeeg = player.getDisplayName();
        this.zzhhf = player.getIconImageUri();
        this.zzhhq = player.getIconImageUrl();
        this.zzhhg = player.getHiResImageUri();
        this.zzhhr = player.getHiResImageUrl();
        this.zzhjk = player.getRetrievedTimestamp();
        this.zzhjl = player.zzara();
        this.zzhjm = player.getLastPlayedWithTimestamp();
        this.zzekd = player.getTitle();
        this.zzhjp = player.zzarb();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzarc();
        this.zzhjn = zza2 == null ? null : new zzb(zza2);
        this.zzhjo = player.getLevelInfo();
        this.zzhjq = player.zzaqz();
        this.zzhjr = player.zzaqy();
        this.mName = player.getName();
        this.zzhjs = player.getBannerImageLandscapeUri();
        this.zzhjt = player.getBannerImageLandscapeUrl();
        this.zzhju = player.getBannerImagePortraitUri();
        this.zzhjv = player.getBannerImagePortraitUrl();
        this.zzhjw = player.zzard();
        this.zzhjx = player.zzare();
        this.zzhjy = player.isMuted();
        zzc.zzu((Object)this.zzfct);
        zzc.zzu((Object)this.zzeeg);
        zzc.checkState((this.zzhjk > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzfct = string;
        this.zzeeg = string2;
        this.zzhhf = uri;
        this.zzhhq = string3;
        this.zzhhg = uri2;
        this.zzhhr = string4;
        this.zzhjk = l;
        this.zzhjl = n;
        this.zzhjm = l2;
        this.zzekd = string5;
        this.zzhjp = bl;
        this.zzhjn = zzb2;
        this.zzhjo = playerLevelInfo;
        this.zzhjq = bl2;
        this.zzhjr = string6;
        this.mName = string7;
        this.zzhjs = uri3;
        this.zzhjt = string8;
        this.zzhju = uri4;
        this.zzhjv = string9;
        this.zzhjw = n2;
        this.zzhjx = l3;
        this.zzhjy = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzfct;
    }

    @Override
    public final String getDisplayName() {
        return this.zzeeg;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzeeg, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String zzaqy() {
        return this.zzhjr;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final boolean zzaqz() {
        return this.zzhjq;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhhf;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhhq;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhhg;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhhr;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzhjk;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzhjm;
    }

    @Override
    public final int zzara() {
        return this.zzhjl;
    }

    @Override
    public final boolean zzarb() {
        return this.zzhjp;
    }

    @Override
    public final String getTitle() {
        return this.zzekd;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzekd, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzhjo;
    }

    @Override
    public final com.google.android.gms.games.internal.player.zza zzarc() {
        return this.zzhjn;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzhjs;
    }

    @Override
    public final String getBannerImageLandscapeUrl() {
        return this.zzhjt;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzhju;
    }

    @Override
    public final String getBannerImagePortraitUrl() {
        return this.zzhjv;
    }

    @Override
    public final int zzard() {
        return this.zzhjw;
    }

    @Override
    public final long zzare() {
        return this.zzhjx;
    }

    @Override
    public final boolean isMuted() {
        return this.zzhjy;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzaqz(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzaqy(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzard(), player.zzare(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbg.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbg.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbg.equal((Object)player2.zzaqz(), (Object)player.zzaqz()) && zzbg.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbg.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbg.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbg.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbg.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbg.equal((Object)player2.zzaqy(), (Object)player.zzaqy()) && zzbg.equal((Object)player2.getName(), (Object)player.getName()) && zzbg.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbg.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbg.equal((Object)player2.zzard(), (Object)player.zzard()) && zzbg.equal((Object)player2.zzare(), (Object)player.zzare()) && zzbg.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbg.zzw((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzaqz()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzaqy()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzard()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzare()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzbem.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzhjl);
        zzbem.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzbem.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzhjn, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzhjp);
        zzbem.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzhjq);
        zzbem.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzhjr, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzhjw);
        zzbem.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzhjx);
        zzbem.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzhjy);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzap {
        zza() {
        }

        @Override
        public final PlayerEntity zzj(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzakv()) || PlayerEntity.zzgd((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzj(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzap)this).zzj(parcel);
        }
    }
}

