/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.internal.api.zzp;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzo;
import com.google.android.gms.games.zzat;
import com.google.android.gms.games.zzau;
import com.google.android.gms.games.zzav;
import com.google.android.gms.games.zzaw;
import com.google.android.gms.games.zzax;
import com.google.android.gms.games.zzay;
import com.google.android.gms.tasks.Task;

public class PlayersClient
extends zzp {
    private static final zzbo<Players.LoadPlayersResult, PlayerBuffer> zzhkj = new zzaw();
    private static final zzo<Players.LoadPlayersResult> zzhkk = new zzax();
    private static final zzbo<Players.LoadPlayersResult, Player> zzhkl = new zzay();

    PlayersClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    PlayersClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<String> getCurrentPlayerId() {
        return this.zza(new zzat(this));
    }

    public Task<Player> getCurrentPlayer() {
        return this.zza(new zzau(this));
    }

    public Task<AnnotatedData<Player>> loadPlayer(@NonNull String string) {
        return this.loadPlayer(string, false);
    }

    public Task<AnnotatedData<Player>> loadPlayer(@NonNull String string, boolean bl) {
        return zzg.zza(Games.Players.loadPlayer(this.zzagc(), string, bl), zzhkl, zzhkk);
    }

    public Task<AnnotatedData<PlayerBuffer>> loadRecentlyPlayedWithPlayers(@IntRange(from=1L, to=25L) int n, boolean bl) {
        return zzg.zzc(Games.Players.loadRecentlyPlayedWithPlayers(this.zzagc(), n, bl), zzhkj);
    }

    public Task<AnnotatedData<PlayerBuffer>> loadMoreRecentlyPlayedWithPlayers(@IntRange(from=1L, to=25L) int n) {
        return zzg.zzc(Games.Players.loadMoreRecentlyPlayedWithPlayers(this.zzagc(), n), zzhkj);
    }

    public Task<Intent> getCompareProfileIntent(@NonNull Player player) {
        return this.zza(new zzav(this, player));
    }
}

