/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzhmi;
    private final int zzefo;
    private final String mName;
    private final String zzdou;
    private final Uri zzhmj;
    private final String zzhmk;
    private final Uri zzhml;
    private final String zzhmm;
    private final int zzhmn;
    private final String zzhmo;
    private final PlayerEntity zzhmp;
    private final int mState;
    private final int zzhmq;
    private final String zzhmr;
    private final long zzhms;
    private final long zzhmt;

    public AchievementEntity(Achievement achievement) {
        this.zzhmi = achievement.getAchievementId();
        this.zzefo = achievement.getType();
        this.mName = achievement.getName();
        this.zzdou = achievement.getDescription();
        this.zzhmj = achievement.getUnlockedImageUri();
        this.zzhmk = achievement.getUnlockedImageUrl();
        this.zzhml = achievement.getRevealedImageUri();
        this.zzhmm = achievement.getRevealedImageUrl();
        this.zzhmp = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzhms = achievement.getLastUpdatedTimestamp();
        this.zzhmt = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzhmn = achievement.getTotalSteps();
            this.zzhmo = achievement.getFormattedTotalSteps();
            this.zzhmq = achievement.getCurrentSteps();
            this.zzhmr = achievement.getFormattedCurrentSteps();
        } else {
            this.zzhmn = 0;
            this.zzhmo = null;
            this.zzhmq = 0;
            this.zzhmr = null;
        }
        com.google.android.gms.common.internal.zzc.zzu((Object)this.zzhmi);
        com.google.android.gms.common.internal.zzc.zzu((Object)this.zzdou);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzhmi = string;
        this.zzefo = n;
        this.mName = string2;
        this.zzdou = string3;
        this.zzhmj = uri;
        this.zzhmk = string4;
        this.zzhml = uri2;
        this.zzhmm = string5;
        this.zzhmn = n2;
        this.zzhmo = string6;
        this.zzhmp = playerEntity;
        this.mState = n3;
        this.zzhmq = n4;
        this.zzhmr = string7;
        this.zzhms = l;
        this.zzhmt = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzhmi;
    }

    @Override
    public final int getType() {
        return this.zzefo;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdou;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdou, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzhmj;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzhmk;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzhml;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzhmm;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhmn;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhmo;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhmo, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzhmp;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhmq;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhmr;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhmr, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhms;
    }

    @Override
    public final long getXpValue() {
        return this.zzhmt;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbg.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbg.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbg.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbg.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbg.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbg.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbg.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbg.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbg.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbg.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbi zzbi2 = zzbg.zzw((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbi2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbi2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbi2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzbem.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzhmn);
        zzbem.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzhmo, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzbem.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzhmq);
        zzbem.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzhmr, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzbem.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }
}

