/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesClientStatusCodes;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzcac;
import com.google.android.gms.internal.zzcae;
import com.google.android.gms.internal.zzcaf;
import com.google.android.gms.internal.zzcwl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GamesClientImpl
extends com.google.android.gms.common.internal.zzab<com.google.android.gms.games.internal.zzw> {
    private zzcae zzhmw = new com.google.android.gms.games.internal.zzd(this);
    private final String zzhmx;
    private PlayerEntity zzhmy;
    private GameEntity zzhmz;
    private final com.google.android.gms.games.internal.zzaa zzhna;
    private boolean zzhnb = false;
    private final Binder zzhnc;
    private final long zzhnd;
    private final Games.GamesOptions zzhne;
    private boolean zzhnf = false;
    private Bundle zzhng;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzr zzr2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzhmx = zzr2.zzakn();
        this.zzhnc = new Binder();
        int n = zzr2.zzakj();
        GamesClientImpl gamesClientImpl = this;
        this.zzhna = new com.google.android.gms.games.internal.zzad(gamesClientImpl, n);
        this.zzhnd = ((Object)((Object)this)).hashCode();
        this.zzhne = gamesOptions;
        if (!this.zzhne.zzhim && (zzr2.zzakp() != null || context instanceof Activity)) {
            this.zzu(zzr2.zzakp());
        }
    }

    public final boolean zzaan() {
        return true;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzhnb = false;
    }

    public final void zzdj(int n) {
        int n2;
        this.zzhna.zzhqb.gravity = n2 = n;
    }

    public final void zzu(View view) {
        this.zzhna.zzv(view);
    }

    protected final Set<Scope> zzb(Set<Scope> set) {
        HashSet<Scope> hashSet = new HashSet<Scope>(set);
        boolean bl = set.contains(Games.SCOPE_GAMES);
        boolean bl2 = set.contains(Games.SCOPE_GAMES_LITE);
        if (set.contains(Games.zzhhy)) {
            com.google.android.gms.common.internal.zzbq.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            com.google.android.gms.common.internal.zzbq.zza((bl || bl2 ? 1 : 0) != 0, (String)"Games APIs requires %s function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games_lite"});
            if (bl2 && bl) {
                hashSet.remove(Games.SCOPE_GAMES_LITE);
            }
        }
        return hashSet;
    }

    public final void zza(com.google.android.gms.common.internal.zzj zzj2) {
        GamesClientImpl gamesClientImpl = this;
        this.zzhmy = null;
        gamesClientImpl.zzhmz = null;
        super.zza(zzj2);
    }

    public final void disconnect() {
        this.zzhnb = false;
        if (this.isConnected()) {
            try {
                com.google.android.gms.games.internal.zzw zzw2 = (com.google.android.gms.games.internal.zzw)this.zzakc();
                zzw2.zzast();
                this.zzhmw.flush();
                zzw2.zzab(this.zzhnd);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.games.internal.zzf.zzv("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected final String zzhf() {
        return "com.google.android.gms.games.service.START";
    }

    protected final String zzhg() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    public final Bundle zzaex() {
        try {
            Bundle bundle = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzaex();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
                this.zzhng = bundle;
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    @Nullable
    public final Bundle zzarg() {
        Bundle bundle = this.zzaex();
        if (bundle == null) {
            bundle = this.zzhng;
        }
        this.zzhng = null;
        return bundle;
    }

    protected final Bundle zzaae() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzhne.zzaqx();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzhmx);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzhna.zzhqb.zzhqc));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzcwl.zza((com.google.android.gms.common.internal.zzr)this.zzakw()));
        return bundle;
    }

    public final String zzarh() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzarh();
    }

    public final String zzari() {
        try {
            return this.zzarh();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzb(String string, com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) throws RemoteException {
        com.google.android.gms.common.internal.zzbq.zzh((String)string, (Object)"Please provide a valid serverClientId");
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(string, new zzy(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final String zzbg(boolean bl) throws RemoteException {
        if (this.zzhmy != null) {
            return this.zzhmy.getPlayerId();
        }
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasv();
    }

    public final String zzbh(boolean bl) {
        try {
            return this.zzbg(true);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Player zzarj() throws RemoteException {
        this.zzakb();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhmy == null) {
                PlayerBuffer playerBuffer = new PlayerBuffer(((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasw());
                try {
                    if (playerBuffer.getCount() > 0) {
                        this.zzhmy = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                    }
                }
                finally {
                    playerBuffer.release();
                }
            }
        }
        return this.zzhmy;
    }

    public final Player zzark() {
        try {
            return this.zzarj();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Game zzarl() throws RemoteException {
        this.zzakb();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhmz == null) {
                GameBuffer gameBuffer = new GameBuffer(((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasx());
                try {
                    if (gameBuffer.getCount() > 0) {
                        this.zzhmz = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                    }
                }
                finally {
                    gameBuffer.release();
                }
            }
        }
        return this.zzhmz;
    }

    public final Game zzarm() {
        try {
            return this.zzarl();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, int n, boolean bl, boolean bl2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), string, n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzc((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzarn() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzarn();
    }

    public final Intent zzaro() {
        try {
            return this.zzarn();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzj(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzk(string, n, n2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb((com.google.android.gms.games.internal.zzs)new zzai(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, String string, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzai(zzn2), string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2, String string, String string2, int n, int n2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzbl(zzn2), null, string2, n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(new zzah(zzn2), string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb(new zzah(zzn2), string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzah(zzn2), leaderboardScoreBuffer.zzats().asBundle(), n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2, String string, long l, String string2) throws RemoteException {
        zzcl zzcl2 = zzn2 == null ? null : new zzcl(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)zzcl2, string, l, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzarp() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzarp();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzf(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)zze2, string, this.zzhna.zzhqb.zzhqc, this.zzhna.zzhqb.zzatb());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb(zze2, string, this.zzhna.zzhqb.zzhqc, this.zzhna.zzhqb.zzatb());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)zze2, string, n, this.zzhna.zzhqb.zzhqc, this.zzhna.zzhqb.zzatb());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb(zze2, string, n, this.zzhna.zzhqb.zzhqc, this.zzhna.zzhqb.zzatb());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl) throws RemoteException {
        this.zzhmw.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zze((com.google.android.gms.games.internal.zzs)new zzu(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzhmw.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzu(zzn2), bl, stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzp(String string, int n) {
        this.zzhmw.zzp(string, n);
    }

    public final Intent zzarq() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzarq();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzarr() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzarr();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zze(com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> zzcl2) throws RemoteException {
        zzab zzab2 = new zzab(zzcl2);
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)zzab2, this.zzhnd);
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> zzcl2) {
        try {
            this.zze(zzcl2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzars() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzac(this.zzhnd);
    }

    public final void zzart() {
        try {
            this.zzars();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> zzcl2) throws RemoteException {
        zzaz zzaz2 = new zzaz(zzcl2);
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb((com.google.android.gms.games.internal.zzs)zzaz2, this.zzhnd);
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> zzcl2) {
        try {
            this.zzg(zzcl2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaru() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzad(this.zzhnd);
    }

    public final void zzarv() {
        try {
            this.zzaru();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzcl<QuestUpdateListener> zzcl2) {
        try {
            zzbs zzbs2 = new zzbs(zzcl2);
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzd((com.google.android.gms.games.internal.zzs)zzbs2, this.zzhnd);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzarw() {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzaf(this.zzhnd);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzj(com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> zzcl2) {
        try {
            zzbw zzbw2 = new zzbw(zzcl2);
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzc((com.google.android.gms.games.internal.zzs)zzbw2, this.zzhnd);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzarx() {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzae(this.zzhnd);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zza(PlayerEntity playerEntity) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(playerEntity);
    }

    public final Intent zzb(PlayerEntity playerEntity) {
        try {
            return this.zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzary() {
        try {
            return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasy();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zza(Room room, int n) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((RoomEntity)room.freeze(), n);
    }

    public final Intent zzb(Room room, int n) {
        try {
            return this.zza(room, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final Intent zzarz() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzarz();
    }

    public final Intent zzasa() {
        try {
            return this.zzarz();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb(new zzx(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(@NonNull com.google.android.gms.common.internal.zzp zzp2) {
        try {
            this.zzg(new com.google.android.gms.games.internal.zze(this, zzp2));
            return;
        }
        catch (RemoteException remoteException) {
            zzp2.zzaiu();
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) throws RemoteException {
        this.zzhmw.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(new zzcg(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final int zzasb() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasb();
    }

    public final int zzasc() {
        try {
            return this.zzasb();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return 4368;
        }
    }

    public final String getAppId() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).getAppId();
    }

    public final String zzasd() {
        try {
            return this.getAppId();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzae(zzn2), n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzq(String string, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzq(string, n);
    }

    public final void zzr(String string, int n) {
        try {
            this.zzq(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzs(String string, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzs(string, n);
    }

    public final void zzt(String string, int n) {
        try {
            this.zzs(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzb(int n, int n2, boolean bl) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb(n, n2, bl);
    }

    public final Intent zzc(int n, int n2, boolean bl) {
        try {
            return this.zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzco(zzn2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzaty(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb((com.google.android.gms.games.internal.zzs)new zzco(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzc((com.google.android.gms.games.internal.zzs)new zzco(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final int zzase() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzase();
    }

    public final int zzasf() {
        try {
            return this.zzase();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzcs(zzn2), string, byArray, string2, participantResultArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzcs(zzn2), string, byArray, participantResultArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zze((com.google.android.gms.games.internal.zzs)new zzcp(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string, String string2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzcp(zzn2), string, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzd((com.google.android.gms.games.internal.zzs)new zzcn(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzhl(String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzhp(string);
    }

    public final void zzhm(String string) {
        try {
            this.zzhl(string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2, int n, int[] nArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzct(zzn2), n, nArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzf((com.google.android.gms.games.internal.zzs)new zzcq(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzd(int n, int n2, boolean bl) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzd(n, n2, bl);
    }

    public final Intent zze(int n, int n2, boolean bl) {
        try {
            return this.zzd(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzcl2, com.google.android.gms.common.api.internal.zzcl<? extends RoomStatusUpdateListener> zzcl3, com.google.android.gms.common.api.internal.zzcl<? extends RealTimeMessageReceivedListener> zzcl4, RoomConfig roomConfig) throws RemoteException {
        zzcc zzcc2 = new zzcc(zzcl2, zzcl3, zzcl4);
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(zzcc2, (IBinder)this.zzhnc, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzhnd);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzcl2, com.google.android.gms.common.api.internal.zzcl<? extends RoomStatusUpdateListener> zzcl3, com.google.android.gms.common.api.internal.zzcl<? extends RealTimeMessageReceivedListener> zzcl4, RoomConfig roomConfig) {
        try {
            this.zza(zzcl2, zzcl3, zzcl4, roomConfig);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzcl2, com.google.android.gms.common.api.internal.zzcl<? extends RoomStatusUpdateListener> zzcl3, com.google.android.gms.common.api.internal.zzcl<? extends RealTimeMessageReceivedListener> zzcl4, RoomConfig roomConfig) throws RemoteException {
        zzcc zzcc2 = new zzcc(zzcl2, zzcl3, zzcl4);
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)zzcc2, (IBinder)this.zzhnc, roomConfig.getInvitationId(), false, this.zzhnd);
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzcl2, com.google.android.gms.common.api.internal.zzcl<? extends RoomStatusUpdateListener> zzcl3, com.google.android.gms.common.api.internal.zzcl<? extends RealTimeMessageReceivedListener> zzcl4, RoomConfig roomConfig) {
        try {
            this.zzc(zzcl2, zzcl3, zzcl4, roomConfig);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzcl2, String string) {
        try {
            String string2 = string;
            com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzcl3 = zzcl2;
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzcc(zzcl3), string2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zza(com.google.android.gms.common.api.internal.zzcl<RealTimeMultiplayer.ReliableMessageSentCallback> zzcl2, byte[] byArray, String string, String string2) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzbv(zzcl2), byArray, string, string2);
    }

    public final int zzb(com.google.android.gms.common.api.internal.zzcl<RealTimeMultiplayer.ReliableMessageSentCallback> zzcl2, byte[] byArray, String string, String string2) {
        try {
            return this.zza(zzcl2, byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string, String[] stringArray) {
        com.google.android.gms.common.internal.zzbq.checkNotNull((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            String[] stringArray2 = stringArray;
            String string2 = string;
            byte[] byArray2 = byArray;
            GamesClientImpl gamesClientImpl = this;
            com.google.android.gms.common.internal.zzbq.checkNotNull((Object)stringArray2, (Object)"Participant IDs must not be null");
            return ((com.google.android.gms.games.internal.zzw)gamesClientImpl.zzakc()).zzb(byArray2, string2, stringArray2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzd(byte[] byArray, String string) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb(byArray, string, null);
    }

    public final int zze(byte[] byArray, String string) {
        try {
            return this.zzd(byArray, string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zzdk(int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzdk(n);
    }

    public final void zzdl(int n) {
        try {
            this.zzdk(n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzasg() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasg();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(n, byArray, n2, string);
            com.google.android.gms.common.internal.zzbq.checkNotNull((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final int zzash() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzash();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzasi() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasi();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzca(zzn2), stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb((com.google.android.gms.games.internal.zzs)new zzca(zzn2), stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2, int n, int n2, int n3) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzbz(zzn2), n, n2, n3);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzf((com.google.android.gms.games.internal.zzs)new zzbm(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzd(int[] nArray) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzd(nArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzhn(String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzhn(string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2, String string) throws RemoteException {
        this.zzhmw.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzh(new zzbp(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string, String string2) throws RemoteException {
        this.zzhmw.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb((com.google.android.gms.games.internal.zzs)new zzbr(zzn2, string2), string, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzhmw.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzbt(zzn2), nArray, n, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzhmw.flush();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzbt(zzn2), stringArray, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzho(String string) {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(string, this.zzhna.zzhqb.zzhqc, this.zzhna.zzhqb.zzatb());
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zzasj() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasj();
    }

    public final int zzask() {
        try {
            return this.zzasj();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzasl() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasl();
    }

    public final int zzasm() {
        try {
            return this.zzasl();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final Intent zza(String string, boolean bl, boolean bl2, int n) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(string, bl, bl2, n);
    }

    public final Intent zzb(String string, boolean bl, boolean bl2, int n) {
        try {
            return this.zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzd((com.google.android.gms.games.internal.zzs)new zzck(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, boolean bl, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzcj(zzn2), string, bl, n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzaub();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzanq();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzch(zzn2), snapshot.getMetadata().getSnapshotId(), (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(Snapshot snapshot) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzanq();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(zzc2);
    }

    public final void zzb(Snapshot snapshot) {
        try {
            this.zza(snapshot);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzg(new zzci(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzaub();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.setTempDir(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzanq();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza((com.google.android.gms.games.internal.zzs)new zzcj(zzn2), string, string2, (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzc(new zzj(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzasn() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasz();
    }

    public final Intent zzaso() {
        try {
            return this.zzasn();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzd(new zzn(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzb((com.google.android.gms.games.internal.zzs)new zzh(zzn2), n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final boolean zzasp() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzasp();
    }

    public final boolean zzasq() {
        try {
            return this.zzasp();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return false;
        }
    }

    public final void zzk(com.google.android.gms.common.api.internal.zzcl<Videos.CaptureOverlayStateListener> zzcl2) throws RemoteException {
        zzl zzl2 = new zzl(zzcl2);
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zze((com.google.android.gms.games.internal.zzs)zzl2, this.zzhnd);
    }

    public final void zzl(com.google.android.gms.common.api.internal.zzcl<Videos.CaptureOverlayStateListener> zzcl2) {
        try {
            this.zzk(zzcl2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzasr() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzag(this.zzhnd);
    }

    public final void zzass() {
        try {
            this.zzasr();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzw)this.zzakc()).zza(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    public final void zzast() {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzw)this.zzakc()).zzast();
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    private static void zzd(RemoteException remoteException) {
        com.google.android.gms.games.internal.zzf.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static void zza(SecurityException securityException) {
        com.google.android.gms.games.internal.zzf.zzd("GamesClientImpl", "Is player signed out?", securityException);
    }

    private static <R> void zza(com.google.android.gms.common.api.internal.zzn<R> zzn2, SecurityException securityException) {
        if (zzn2 != null) {
            zzn2.zzv(GamesClientStatusCodes.zzdh(4));
        }
    }

    private static Room zzak(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.zzb zzb2 = new com.google.android.gms.games.multiplayer.realtime.zzb(dataHolder);
        Room room = null;
        try {
            if (zzb2.getCount() > 0) {
                room = (Room)((Room)zzb2.get(0)).freeze();
            }
        }
        finally {
            zzb2.release();
        }
        return room;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzhnf = this.zzhnb = bundle.getBoolean("show_welcome_popup");
            this.zzhmy = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzhmz = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        com.google.android.gms.games.internal.zzw zzw2 = (com.google.android.gms.games.internal.zzw)iInterface;
        GamesClientImpl gamesClientImpl = this;
        super.zza((IInterface)zzw2);
        if (gamesClientImpl.zzhnb) {
            gamesClientImpl.zzhna.zzata();
            gamesClientImpl.zzhnb = false;
        }
        if (!gamesClientImpl.zzhne.zzhie && !gamesClientImpl.zzhne.zzhim) {
            com.google.android.gms.games.internal.zzw zzw3 = zzw2;
            GamesClientImpl gamesClientImpl2 = gamesClientImpl;
            try {
                zzbo zzbo2 = new zzbo(gamesClientImpl2.zzhna);
                zzw3.zza(zzbo2, gamesClientImpl2.zzhnd);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof com.google.android.gms.games.internal.zzw) {
            return (com.google.android.gms.games.internal.zzw)iInterface;
        }
        return new com.google.android.gms.games.internal.zzx(iBinder2);
    }

    static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final String zzad;

        public final Status getStatus() {
            throw new NoSuchMethodError();
        }

        @Override
        public final String getUrl() {
            return this.zzad;
        }
    }

    static final class zzo
    implements Videos.CaptureStateResult {
        private final Status mStatus;
        private final CaptureState zzhnp;

        zzo(Status status, CaptureState captureState) {
            this.mStatus = status;
            this.zzhnp = captureState;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final CaptureState getCaptureState() {
            return this.zzhnp;
        }
    }

    static final class zzk
    implements Videos.CaptureCapabilitiesResult {
        private final Status mStatus;
        private final VideoCapabilities zzhnn;

        zzk(Status status, VideoCapabilities videoCapabilities) {
            this.mStatus = status;
            this.zzhnn = videoCapabilities;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final VideoCapabilities getCapabilities() {
            return this.zzhnn;
        }
    }

    static final class zzi
    implements Videos.CaptureAvailableResult {
        private final Status mStatus;
        private final boolean zzhnm;

        zzi(Status status, boolean bl) {
            this.mStatus = status;
            this.zzhnm = bl;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final boolean isAvailable() {
            return this.zzhnm;
        }
    }

    static final class zzs
    implements Snapshots.DeleteSnapshotResult {
        private final Status mStatus;
        private final String zzhns;

        zzs(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdh(n);
            this.zzhns = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getSnapshotId() {
            return this.zzhns;
        }
    }

    static final class zzq
    extends zzw
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzhnr;

        zzq(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzhnr = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
                return;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public final SnapshotMetadata getSnapshotMetadata() {
            return this.zzhnr;
        }
    }

    static final class zzbc
    extends zzw
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzhol;
        private final String zzhom;
        private final Snapshot zzhon;
        private final com.google.android.gms.drive.zzc zzhoo;
        private final SnapshotContents zzhop;

        zzbc(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        zzbc(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzhol = null;
                    this.zzhon = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzc.checkState((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhol = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    this.zzhon = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhol = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzhon = new SnapshotEntity(snapshotMetadataEntity2, new com.google.android.gms.games.snapshot.zza(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzhom = string;
            this.zzhoo = zzc4;
            this.zzhop = new com.google.android.gms.games.snapshot.zza(zzc4);
        }

        @Override
        public final Snapshot getSnapshot() {
            return this.zzhol;
        }

        @Override
        public final String getConflictId() {
            return this.zzhom;
        }

        @Override
        public final Snapshot getConflictingSnapshot() {
            return this.zzhon;
        }

        @Override
        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzhop;
        }
    }

    static final class zzax
    extends zzw
    implements Snapshots.LoadSnapshotsResult {
        zzax(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzfoj);
        }
    }

    static final class zzas
    extends zzw
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzhod;

        zzas(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzhod = playerStatsBuffer.getCount() > 0 ? new com.google.android.gms.games.stats.zza((PlayerStats)playerStatsBuffer.get(0)) : null;
                return;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public final PlayerStats getPlayerStats() {
            return this.zzhod;
        }
    }

    static final class zzp
    extends zzw
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzhnq;
        private final Quest zzhnk;

        zzp(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzhnk = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzhnk.zzatz();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzhnq = list.get(i);
                        return;
                    }
                    this.zzhnq = null;
                } else {
                    this.zzhnq = null;
                    this.zzhnk = null;
                }
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Milestone getMilestone() {
            return this.zzhnq;
        }

        @Override
        public final Quest getQuest() {
            return this.zzhnk;
        }
    }

    static final class zzd
    extends zzw
    implements Quests.AcceptQuestResult {
        private final Quest zzhnk;

        zzd(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzhnk = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Quest getQuest() {
            return this.zzhnk;
        }
    }

    static final class zzau
    extends zzw
    implements Quests.LoadQuestsResult {
        private final DataHolder zzfoj;

        zzau(DataHolder dataHolder) {
            super(dataHolder);
            this.zzfoj = dataHolder;
        }

        @Override
        public final QuestBuffer getQuests() {
            return new QuestBuffer(this.zzfoj);
        }
    }

    static final class zzav
    implements Requests.LoadRequestsResult {
        private final Status mStatus;
        private final Bundle zzhof;

        zzav(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhof = bundle;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final GameRequestBuffer getRequests(int n) {
            String string;
            switch (n) {
                case 1: {
                    String string2 = "GIFT";
                    break;
                }
                case 2: {
                    String string2 = "WISH";
                    break;
                }
                default: {
                    com.google.android.gms.games.internal.zzf.zzw("RequestType", new StringBuilder(33).append("Unknown request type: ").append(n).toString());
                    String string2 = string = "UNKNOWN_TYPE";
                }
            }
            if (!this.zzhof.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzhof.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public final void release() {
            for (String string : this.zzhof.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzhof.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    static final class zzcw
    extends zzw
    implements Requests.UpdateRequestsResult {
        private final zzcaf zzhpo;

        zzcw(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhpo = zzcaf.zzan(dataHolder);
        }

        @Override
        public final int getRequestOutcome(String string) {
            return this.zzhpo.getRequestOutcome(string);
        }

        @Override
        public final Set<String> getRequestIds() {
            return this.zzhpo.getRequestIds();
        }
    }

    static final class zzz
    implements Games.GetServerAuthCodeResult {
        private final Status mStatus;
        private final String zzhnt;

        zzz(Status status, String string) {
            this.mStatus = status;
            this.zzhnt = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getCode() {
            return this.zzhnt;
        }
    }

    static final class zzg
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status mStatus;
        private final String zzhnl;

        zzg(Status status, String string) {
            this.mStatus = status;
            this.zzhnl = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMatchId() {
            return this.zzhnl;
        }
    }

    static final class zzaj
    extends zzcr
    implements TurnBasedMultiplayer.LeaveMatchResult {
        zzaj(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzcv
    extends zzcr
    implements TurnBasedMultiplayer.UpdateMatchResult {
        zzcv(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzaa
    extends zzcr
    implements TurnBasedMultiplayer.InitiateMatchResult {
        zzaa(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzap
    extends zzcr
    implements TurnBasedMultiplayer.LoadMatchResult {
        zzap(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static abstract class zzcr
    extends zzw {
        private TurnBasedMatch zzhoj;

        zzcr(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzhoj = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzhoj;
        }
    }

    static final class zzcm
    extends zzw
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzhph;

        public zzcm(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzhph = new ScoreSubmissionData(dataHolder);
                return;
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public final ScoreSubmissionData getScoreData() {
            return this.zzhph;
        }
    }

    static final class zzat
    extends zzw
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzhoe;

        zzat(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhoe = new PlayerBuffer(dataHolder);
        }

        @Override
        public final PlayerBuffer getPlayers() {
            return this.zzhoe;
        }
    }

    static final class zzaq
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status mStatus;
        private final LoadMatchesResponse zzhob;

        zzaq(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhob = new LoadMatchesResponse(bundle);
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final LoadMatchesResponse getMatches() {
            return this.zzhob;
        }

        public final void release() {
            this.zzhob.release();
        }
    }

    static final class zzao
    extends zzw
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzhoa;

        zzao(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhoa = new InvitationBuffer(dataHolder);
        }

        @Override
        public final InvitationBuffer getInvitations() {
            return this.zzhoa;
        }
    }

    static final class zzar
    extends zzw
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzhoc;

        zzar(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzhoc = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public final LeaderboardScore getScore() {
            return this.zzhoc;
        }
    }

    static final class zzaw
    extends zzw
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzhog;
        private final LeaderboardScoreBuffer zzhoh;

        zzaw(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzhog = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzhoh = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public final Leaderboard getLeaderboard() {
            return this.zzhog;
        }

        @Override
        public final LeaderboardScoreBuffer getScores() {
            return this.zzhoh;
        }
    }

    static final class zzag
    extends zzw
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzhnv;

        zzag(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhnv = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public final LeaderboardBuffer getLeaderboards() {
            return this.zzhnv;
        }
    }

    static final class zzan
    extends zzw
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzhnz;

        zzan(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhnz = new GameBuffer(dataHolder);
        }

        @Override
        public final GameBuffer getGames() {
            return this.zzhnz;
        }
    }

    static final class zzam
    extends zzw
    implements Events.LoadEventsResult {
        private final EventBuffer zzhny;

        zzam(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhny = new EventBuffer(dataHolder);
        }

        @Override
        public final EventBuffer getEvents() {
            return this.zzhny;
        }
    }

    static final class zzcu
    implements Achievements.UpdateAchievementResult {
        private final Status mStatus;
        private final String zzhmi;

        zzcu(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdh(n);
            this.zzhmi = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getAchievementId() {
            return this.zzhmi;
        }
    }

    static final class zzal
    extends zzw
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzhnx;

        zzal(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhnx = new AchievementBuffer(dataHolder);
        }

        @Override
        public final AchievementBuffer getAchievements() {
            return this.zzhnx;
        }
    }

    static abstract class zzw
    extends com.google.android.gms.common.api.internal.zzam {
        protected zzw(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzdh(dataHolder.getStatusCode()));
        }
    }

    static final class zzbu
    implements com.google.android.gms.common.api.internal.zzco<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzfda;
        private final String zzhov;
        private final int zzhow;

        zzbu(int n, int n2, String string) {
            this.zzfda = n;
            this.zzhow = n2;
            this.zzhov = string;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback = (RealTimeMultiplayer.ReliableMessageSentCallback)object;
            zzbu zzbu2 = this;
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(zzbu2.zzfda, zzbu2.zzhow, zzbu2.zzhov);
            }
        }
    }

    static final class zzbb
    implements com.google.android.gms.common.api.internal.zzco<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzhok;

        zzbb(RealTimeMessage realTimeMessage) {
            this.zzhok = realTimeMessage;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            RealTimeMessageReceivedListener realTimeMessageReceivedListener = (RealTimeMessageReceivedListener)object;
            zzbb zzbb2 = this;
            realTimeMessageReceivedListener.onRealTimeMessageReceived(zzbb2.zzhok);
        }
    }

    static final class zzbe
    implements com.google.android.gms.common.api.internal.zzco<RoomStatusUpdateListener> {
        private final String zzhoq;

        zzbe(String string) {
            this.zzhoq = string;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbe zzbe2 = this;
            roomStatusUpdateListener.onP2PDisconnected(zzbe2.zzhoq);
        }
    }

    static final class zzbd
    implements com.google.android.gms.common.api.internal.zzco<RoomStatusUpdateListener> {
        private final String zzhoq;

        zzbd(String string) {
            this.zzhoq = string;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbd zzbd2 = this;
            roomStatusUpdateListener.onP2PConnected(zzbd2.zzhoq);
        }
    }

    static final class zzbh
    extends zza {
        zzbh(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    static final class zzbf
    extends zza {
        zzbf(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    static final class zzbg
    extends zza {
        zzbg(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    static final class zzbk
    extends zza {
        zzbk(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    static final class zzbj
    extends zza {
        zzbj(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    static final class zzbi
    extends zza {
        zzbi(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    static final class zzt
    extends zzc {
        zzt(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    static final class zzr
    extends zzc {
        zzr(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    static final class zzcb
    extends zzc {
        zzcb(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    static final class zzce
    extends zzc {
        zzce(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    static final class zzcd
    extends zzb {
        zzcd(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    static final class zzak
    implements com.google.android.gms.common.api.internal.zzco<RoomUpdateListener> {
        private final int zzfda;
        private final String zzhnw;

        zzak(int n, String string) {
            this.zzfda = n;
            this.zzhnw = string;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            zzak zzak2 = this;
            roomUpdateListener.onLeftRoom(zzak2.zzfda, zzak2.zzhnw);
        }
    }

    static final class zzaf
    extends zzb {
        public zzaf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    static final class zzcf
    extends zzb {
        public zzcf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    static abstract class zza
    extends zzc {
        private final ArrayList<String> zzhnj = new ArrayList();

        zza(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzhnj.add(stringArray[i]);
            }
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzhnj);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    static abstract class zzc
    extends com.google.android.gms.common.api.internal.zzal<RoomStatusUpdateListener> {
        zzc(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzak(dataHolder2));
        }
    }

    static abstract class zzb
    extends com.google.android.gms.common.api.internal.zzal<RoomUpdateListener> {
        zzb(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            this.zza(roomUpdateListener, GamesClientImpl.zzak(dataHolder2), dataHolder2.getStatusCode());
        }
    }

    static final class zzby
    implements com.google.android.gms.common.api.internal.zzco<OnRequestReceivedListener> {
        private final String zzcqb;

        zzby(String string) {
            this.zzcqb = string;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzby zzby2 = this;
            onRequestReceivedListener.onRequestRemoved(zzby2.zzcqb);
        }
    }

    static final class zzbx
    implements com.google.android.gms.common.api.internal.zzco<OnRequestReceivedListener> {
        private final GameRequest zzhoy;

        zzbx(GameRequest gameRequest) {
            this.zzhoy = gameRequest;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzbx zzbx2 = this;
            onRequestReceivedListener.onRequestReceived(zzbx2.zzhoy);
        }
    }

    static final class zzbq
    implements com.google.android.gms.common.api.internal.zzco<QuestUpdateListener> {
        private final Quest zzhnk;

        zzbq(Quest quest) {
            this.zzhnk = quest;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            QuestUpdateListener questUpdateListener = (QuestUpdateListener)object;
            zzbq zzbq2 = this;
            questUpdateListener.onQuestCompleted(zzbq2.zzhnk);
        }
    }

    static final class zzay
    implements com.google.android.gms.common.api.internal.zzco<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzhoi;

        zzay(String string) {
            this.zzhoi = string;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzay zzay2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(zzay2.zzhoi);
        }
    }

    static final class zzba
    implements com.google.android.gms.common.api.internal.zzco<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzhoj;

        zzba(TurnBasedMatch turnBasedMatch) {
            this.zzhoj = turnBasedMatch;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzba zzba2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(zzba2.zzhoj);
        }
    }

    static final class zzad
    implements com.google.android.gms.common.api.internal.zzco<OnInvitationReceivedListener> {
        private final String zzdyn;

        zzad(String string) {
            this.zzdyn = string;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzad zzad2 = this;
            onInvitationReceivedListener.onInvitationRemoved(zzad2.zzdyn);
        }
    }

    static final class zzac
    implements com.google.android.gms.common.api.internal.zzco<OnInvitationReceivedListener> {
        private final Invitation zzhnu;

        zzac(Invitation invitation) {
            this.zzhnu = invitation;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzac zzac2 = this;
            onInvitationReceivedListener.onInvitationReceived(zzac2.zzhnu);
        }
    }

    static final class zzm
    implements com.google.android.gms.common.api.internal.zzco<Videos.CaptureOverlayStateListener> {
        private final int zzhno;

        zzm(int n) {
            this.zzhno = n;
        }

        public final void zzaho() {
        }

        public final /* synthetic */ void zzt(Object object) {
            Videos.CaptureOverlayStateListener captureOverlayStateListener = (Videos.CaptureOverlayStateListener)object;
            zzm zzm2 = this;
            captureOverlayStateListener.onCaptureOverlayStateChanged(zzm2.zzhno);
        }
    }

    static final class zzn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzfzm;

        public zzn(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzd(int n, Bundle bundle) {
            this.zzfzm.setResult((Object)new zzo(new Status(n), CaptureState.zzp(bundle)));
        }
    }

    static final class zzl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcl<Videos.CaptureOverlayStateListener> zzglx;

        zzl(com.google.android.gms.common.api.internal.zzcl<Videos.CaptureOverlayStateListener> zzcl2) {
            this.zzglx = (com.google.android.gms.common.api.internal.zzcl)com.google.android.gms.common.internal.zzbq.checkNotNull(zzcl2, (Object)"Callback must not be null");
        }

        @Override
        public final void onCaptureOverlayStateChanged(int n) {
            this.zzglx.zza((com.google.android.gms.common.api.internal.zzco)new zzm(n));
        }
    }

    static final class zzj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzfzm;

        zzj(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzfzm.setResult((Object)new zzk(new Status(n), videoCapabilities));
        }
    }

    static final class zzh
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzfzm;

        zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, boolean bl) {
            this.zzfzm.setResult((Object)new zzi(new Status(n), bl));
        }
    }

    static final class zzci
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzfzm;

        public zzci(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(int n, String string) {
            this.zzfzm.setResult((Object)new zzs(n, string));
        }
    }

    static final class zzch
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzhpe;

        public zzch(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2) {
            this.zzhpe = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzae(DataHolder dataHolder) {
            this.zzhpe.setResult((Object)new zzq(dataHolder));
        }
    }

    static final class zzcj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzhpf;

        public zzcj(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2) {
            this.zzhpf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzhpf.setResult((Object)new zzbc(dataHolder, zzc2));
        }

        @Override
        public final void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzhpf.setResult((Object)new zzbc(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    static final class zzck
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzhpg;

        public zzck(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2) {
            this.zzhpg = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzad(DataHolder dataHolder) {
            this.zzhpg.setResult((Object)new zzax(dataHolder));
        }
    }

    static final class zzbm
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzfzm;

        public zzbm(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzaj(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzas(dataHolder));
        }
    }

    static final class zzbt
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzhou;

        public zzbt(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2) {
            this.zzhou = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzai(DataHolder dataHolder) {
            this.zzhou.setResult((Object)new zzau(dataHolder));
        }
    }

    static final class zzbr
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzhos;
        private final String zzhot;

        public zzbr(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string) {
            this.zzhos = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
            this.zzhot = (String)com.google.android.gms.common.internal.zzbq.checkNotNull((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public final void zzaf(DataHolder dataHolder) {
            this.zzhos.setResult((Object)new zzp(dataHolder, this.zzhot));
        }
    }

    static final class zzbp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzhor;

        public zzbp(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2) {
            this.zzhor = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzag(DataHolder dataHolder) {
            this.zzhor.setResult((Object)new zzd(dataHolder));
        }
    }

    static final class zzbz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzhoz;

        public zzbz(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2) {
            this.zzhoz = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdh(n);
            this.zzhoz.setResult((Object)new zzav(status, bundle));
        }
    }

    static final class zzca
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzhpa;

        public zzca(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2) {
            this.zzhpa = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzac(DataHolder dataHolder) {
            this.zzhpa.setResult((Object)new zzcw(dataHolder));
        }
    }

    static final class zzbo
    extends com.google.android.gms.games.internal.zzb {
        private final com.google.android.gms.games.internal.zzaa zzhna;

        public zzbo(com.google.android.gms.games.internal.zzaa zzaa2) {
            this.zzhna = zzaa2;
        }

        @Override
        public final com.google.android.gms.games.internal.zzy zzarf() {
            return new com.google.android.gms.games.internal.zzy(this.zzhna.zzhqb);
        }
    }

    static final class zzy
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzfzm;

        public zzy(com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzdh(n);
            this.zzfzm.setResult((Object)new zzz(status, string));
        }
    }

    static final class zzcg
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Status> zzfzm;

        public zzcg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzaiu() {
            Status status = GamesStatusCodes.zzdh(0);
            this.zzfzm.setResult((Object)status);
        }
    }

    static final class zzbv
    extends com.google.android.gms.games.internal.zza {
        private com.google.android.gms.common.api.internal.zzcl<RealTimeMultiplayer.ReliableMessageSentCallback> zzhox;

        public zzbv(com.google.android.gms.common.api.internal.zzcl<RealTimeMultiplayer.ReliableMessageSentCallback> zzcl2) {
            this.zzhox = zzcl2;
        }

        @Override
        public final void zzb(int n, int n2, String string) {
            if (this.zzhox != null) {
                this.zzhox.zza((com.google.android.gms.common.api.internal.zzco)new zzbu(n, n2, string));
            }
        }
    }

    static final class zzcc
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzhpb;
        private final com.google.android.gms.common.api.internal.zzcl<? extends RoomStatusUpdateListener> zzhpc;
        private final com.google.android.gms.common.api.internal.zzcl<? extends RealTimeMessageReceivedListener> zzhpd;

        public zzcc(com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzcl2) {
            this.zzhpb = (com.google.android.gms.common.api.internal.zzcl)com.google.android.gms.common.internal.zzbq.checkNotNull(zzcl2, (Object)"Callbacks must not be null");
            this.zzhpc = null;
            this.zzhpd = null;
        }

        public zzcc(com.google.android.gms.common.api.internal.zzcl<? extends RoomUpdateListener> zzcl2, com.google.android.gms.common.api.internal.zzcl<? extends RoomStatusUpdateListener> zzcl3, com.google.android.gms.common.api.internal.zzcl<? extends RealTimeMessageReceivedListener> zzcl4) {
            this.zzhpb = (com.google.android.gms.common.api.internal.zzcl)com.google.android.gms.common.internal.zzbq.checkNotNull(zzcl2, (Object)"Callbacks must not be null");
            this.zzhpc = zzcl3;
            this.zzhpd = zzcl4;
        }

        @Override
        public final void zzu(DataHolder dataHolder) {
            this.zzhpb.zza((com.google.android.gms.common.api.internal.zzco)new zzcf(dataHolder));
        }

        @Override
        public final void zzv(DataHolder dataHolder) {
            this.zzhpb.zza((com.google.android.gms.common.api.internal.zzco)new zzaf(dataHolder));
        }

        @Override
        public final void onLeftRoom(int n, String string) {
            this.zzhpb.zza((com.google.android.gms.common.api.internal.zzco)new zzak(n, string));
        }

        @Override
        public final void zzy(DataHolder dataHolder) {
            this.zzhpb.zza((com.google.android.gms.common.api.internal.zzco)new zzcd(dataHolder));
        }

        @Override
        public final void zzw(DataHolder dataHolder) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzce(dataHolder));
            }
        }

        @Override
        public final void zzx(DataHolder dataHolder) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzcb(dataHolder));
            }
        }

        @Override
        public final void zzz(DataHolder dataHolder) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzr(dataHolder));
            }
        }

        @Override
        public final void zzaa(DataHolder dataHolder) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzt(dataHolder));
            }
        }

        @Override
        public final void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzbf(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzbh(dataHolder, stringArray));
            }
        }

        @Override
        public final void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzbi(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzbj(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzbk(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzbg(dataHolder, stringArray));
            }
        }

        @Override
        public final void onP2PConnected(String string) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzbd(string));
            }
        }

        @Override
        public final void onP2PDisconnected(String string) {
            if (this.zzhpc != null) {
                this.zzhpc.zza((com.google.android.gms.common.api.internal.zzco)new zzbe(string));
            }
        }

        @Override
        public final void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzhpd != null) {
                this.zzhpd.zza((com.google.android.gms.common.api.internal.zzco)new zzbb(realTimeMessage));
            }
        }
    }

    static final class zzcn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzhpi;

        public zzcn(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2) {
            this.zzhpi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzdh(n);
            this.zzhpi.setResult((Object)new zzg(status, string));
        }
    }

    static final class zzcp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzhpk;

        public zzcp(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2) {
            this.zzhpk = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzs(DataHolder dataHolder) {
            this.zzhpk.setResult((Object)new zzaj(dataHolder));
        }
    }

    static final class zzcs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzhpm;

        public zzcs(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2) {
            this.zzhpm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzr(DataHolder dataHolder) {
            this.zzhpm.setResult((Object)new zzcv(dataHolder));
        }
    }

    static final class zzco
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzhpj;

        public zzco(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2) {
            this.zzhpj = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzq(DataHolder dataHolder) {
            this.zzhpj.setResult((Object)new zzaa(dataHolder));
        }
    }

    static final class zzcq
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzhpl;

        public zzcq(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2) {
            this.zzhpl = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzp(DataHolder dataHolder) {
            this.zzhpl.setResult((Object)new zzap(dataHolder));
        }
    }

    static final class zzct
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzhpn;

        public zzct(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2) {
            this.zzhpn = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdh(n);
            this.zzhpn.setResult((Object)new zzaq(status, bundle));
        }
    }

    static final class zzcl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzfzm;

        public zzcl(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzcm(dataHolder));
        }
    }

    static final class zzbn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzfzm;

        zzbn(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzat(dataHolder));
        }

        @Override
        public final void zzk(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzat(dataHolder));
        }
    }

    static final class zzbw
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> zzglx;

        zzbw(com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> zzcl2) {
            this.zzglx = zzcl2;
        }

        @Override
        public final void zzo(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzglx.zza((com.google.android.gms.common.api.internal.zzco)new zzbx(gameRequest));
            }
        }

        @Override
        public final void onRequestRemoved(String string) {
            this.zzglx.zza((com.google.android.gms.common.api.internal.zzco)new zzby(string));
        }
    }

    static final class zzbs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcl<QuestUpdateListener> zzglx;

        zzbs(com.google.android.gms.common.api.internal.zzcl<QuestUpdateListener> zzcl2) {
            this.zzglx = zzcl2;
        }

        @Override
        public final void zzah(DataHolder dataHolder) {
            Quest quest = zzbs.zzam(dataHolder);
            if (quest != null) {
                this.zzglx.zza((com.google.android.gms.common.api.internal.zzco)new zzbq(quest));
            }
        }

        private static Quest zzam(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    static final class zzaz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> zzglx;

        zzaz(com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> zzcl2) {
            this.zzglx = zzcl2;
        }

        @Override
        public final void zzt(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzglx.zza((com.google.android.gms.common.api.internal.zzco)new zzba(turnBasedMatch));
            }
        }

        @Override
        public final void onTurnBasedMatchRemoved(String string) {
            this.zzglx.zza((com.google.android.gms.common.api.internal.zzco)new zzay(string));
        }
    }

    static final class zzab
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> zzglx;

        zzab(com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> zzcl2) {
            this.zzglx = zzcl2;
        }

        @Override
        public final void zzn(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzglx.zza((com.google.android.gms.common.api.internal.zzco)new zzac(invitation));
            }
        }

        @Override
        public final void onInvitationRemoved(String string) {
            this.zzglx.zza((com.google.android.gms.common.api.internal.zzco)new zzad(string));
        }
    }

    static final class zzae
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzfzm;

        zzae(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzm(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzao(dataHolder));
        }
    }

    static final class zzbl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzfzm;

        zzbl(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzab(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzar(dataHolder));
        }
    }

    static final class zzah
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzfzm;

        zzah(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzfzm.setResult((Object)new zzaw(dataHolder, dataHolder2));
        }
    }

    static final class zzai
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzfzm;

        zzai(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzag(dataHolder));
        }
    }

    static final class zzu
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzfzm;

        zzu(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzam(dataHolder));
        }
    }

    static final class zzx
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzfzm;

        zzx(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzl(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzan(dataHolder));
        }
    }

    static final class zze
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzfzm;

        zze(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, String string) {
            this.zzfzm.setResult((Object)new zzcu(n, string));
        }
    }

    static final class zzf
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzfzm;

        zzf(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2) {
            this.zzfzm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.checkNotNull(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzf(DataHolder dataHolder) {
            this.zzfzm.setResult((Object)new zzal(dataHolder));
        }
    }

    final class zzv
    extends zzcac {
        private /* synthetic */ GamesClientImpl zzhnh;

        public zzv(GamesClientImpl gamesClientImpl) {
            this.zzhnh = gamesClientImpl;
            super(gamesClientImpl.getContext().getMainLooper(), 1000);
        }

        @Override
        protected final void zzu(String string, int n) {
            try {
                if (this.zzhnh.isConnected()) {
                    ((com.google.android.gms.games.internal.zzw)this.zzhnh.zzakc()).zzp(string, n);
                    return;
                }
                com.google.android.gms.games.internal.zzf.zzw("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
                return;
            }
            catch (SecurityException securityException) {
                GamesClientImpl.zza(securityException);
                return;
            }
        }
    }
}

