/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcab;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] zzhtr = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String zzhtt;
    private String zzfct;
    private int zzfda;
    private HashMap<Integer, Result> zzhuy;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.zzfda = dataHolder.getStatusCode();
        this.zzhuy = new HashMap();
        int n = dataHolder.getCount();
        zzbq.checkArgument((n == 3 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            int n2 = dataHolder.zzca(i);
            if (i == 0) {
                this.zzhtt = dataHolder.zzd("leaderboardId", i, n2);
                this.zzfct = dataHolder.zzd("playerId", i, n2);
            }
            if (!dataHolder.zze("hasResult", i, n2)) continue;
            Result result = new Result(dataHolder.zzb("rawScore", i, n2), dataHolder.zzd("formattedScore", i, n2), dataHolder.zzd("scoreTag", i, n2), dataHolder.zze("newBest", i, n2));
            int n3 = dataHolder.zzc("timeSpan", i, n2);
            Result result2 = result;
            this.zzhuy.put(n3, result2);
        }
    }

    public final String getLeaderboardId() {
        return this.zzhtt;
    }

    public final String getPlayerId() {
        return this.zzfct;
    }

    public final Result getScoreResult(int n) {
        return this.zzhuy.get(n);
    }

    public final String toString() {
        zzbi zzbi2 = zzbg.zzw((Object)this).zzg("PlayerId", (Object)this.zzfct).zzg("StatusCode", (Object)this.zzfda);
        for (int i = 0; i < 3; ++i) {
            Result result = this.zzhuy.get(i);
            zzbi2.zzg("TimesSpan", (Object)zzcab.zzdn(i));
            zzbi2.zzg("Result", (Object)(result == null ? "null" : result.toString()));
        }
        return zzbi2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long l, String string, String string2, boolean bl) {
            this.rawScore = l;
            this.formattedScore = string;
            this.scoreTag = string2;
            this.newBest = bl;
        }

        public final String toString() {
            return zzbg.zzw((Object)this).zzg("RawScore", (Object)this.rawScore).zzg("FormattedScore", (Object)this.formattedScore).zzg("ScoreTag", (Object)this.scoreTag).zzg("NewBest", (Object)this.newBest).toString();
        }
    }
}

