/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.zzh;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new zza();
    private final String zzekh;
    private final String zzedu;
    private final String zzhgs;
    private final String zzhgt;
    private final String zzdou;
    private final String zzhgu;
    private final Uri zzhgv;
    private final Uri zzhgw;
    private final Uri zzhgx;
    private final boolean zzhgy;
    private final boolean zzhgz;
    private final String zzhha;
    private final int zzhhb;
    private final int zzhhc;
    private final int zzhhd;
    private final boolean zzhhe;
    private final boolean zzhhf;
    private final String zzhhg;
    private final String zzhhh;
    private final String zzhhi;
    private final boolean zzdhg;
    private final boolean zzhhj;
    private final boolean zzhhk;
    private final String zzhhl;
    private final boolean zzhhm;

    public GameEntity(Game game) {
        this.zzekh = game.getApplicationId();
        this.zzhgs = game.getPrimaryCategory();
        this.zzhgt = game.getSecondaryCategory();
        this.zzdou = game.getDescription();
        this.zzhgu = game.getDeveloperName();
        this.zzedu = game.getDisplayName();
        this.zzhgv = game.getIconImageUri();
        this.zzhhg = game.getIconImageUrl();
        this.zzhgw = game.getHiResImageUri();
        this.zzhhh = game.getHiResImageUrl();
        this.zzhgx = game.getFeaturedImageUri();
        this.zzhhi = game.getFeaturedImageUrl();
        this.zzhgy = game.zzaqr();
        this.zzhgz = game.zzaqt();
        this.zzhha = game.zzaqu();
        this.zzhhb = 1;
        this.zzhhc = game.getAchievementTotalCount();
        this.zzhhd = game.getLeaderboardCount();
        this.zzhhe = game.isRealTimeMultiplayerEnabled();
        this.zzhhf = game.isTurnBasedMultiplayerEnabled();
        this.zzdhg = game.isMuted();
        this.zzhhj = game.zzaqs();
        this.zzhhk = game.areSnapshotsEnabled();
        this.zzhhl = game.getThemeColor();
        this.zzhhm = game.hasGamepadSupport();
    }

    GameEntity(String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n, int n2, int n3, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.zzekh = string;
        this.zzedu = string2;
        this.zzhgs = string3;
        this.zzhgt = string4;
        this.zzdou = string5;
        this.zzhgu = string6;
        this.zzhgv = uri;
        this.zzhhg = string8;
        this.zzhgw = uri2;
        this.zzhhh = string9;
        this.zzhgx = uri3;
        this.zzhhi = string10;
        this.zzhgy = bl;
        this.zzhgz = bl2;
        this.zzhha = string7;
        this.zzhhb = n;
        this.zzhhc = n2;
        this.zzhhd = n3;
        this.zzhhe = bl3;
        this.zzhhf = bl4;
        this.zzdhg = bl5;
        this.zzhhj = bl6;
        this.zzhhk = bl7;
        this.zzhhl = string11;
        this.zzhhm = bl8;
    }

    @Override
    public final String getApplicationId() {
        return this.zzekh;
    }

    @Override
    public final String getDisplayName() {
        return this.zzedu;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzedu, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getPrimaryCategory() {
        return this.zzhgs;
    }

    @Override
    public final String getSecondaryCategory() {
        return this.zzhgt;
    }

    @Override
    public final String getDescription() {
        return this.zzdou;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdou, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDeveloperName() {
        return this.zzhgu;
    }

    @Override
    public final void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzhgu, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhgv;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhhg;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhgw;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhhh;
    }

    @Override
    public final Uri getFeaturedImageUri() {
        return this.zzhgx;
    }

    @Override
    public final String getFeaturedImageUrl() {
        return this.zzhhi;
    }

    @Override
    public final boolean isMuted() {
        return this.zzdhg;
    }

    @Override
    public final boolean zzaqs() {
        return this.zzhhj;
    }

    @Override
    public final boolean zzaqr() {
        return this.zzhgy;
    }

    @Override
    public final boolean zzaqt() {
        return this.zzhgz;
    }

    @Override
    public final String zzaqu() {
        return this.zzhha;
    }

    @Override
    public final int getAchievementTotalCount() {
        return this.zzhhc;
    }

    @Override
    public final int getLeaderboardCount() {
        return this.zzhhd;
    }

    @Override
    public final boolean isRealTimeMultiplayerEnabled() {
        return this.zzhhe;
    }

    @Override
    public final boolean isTurnBasedMultiplayerEnabled() {
        return this.zzhhf;
    }

    @Override
    public final boolean areSnapshotsEnabled() {
        return this.zzhhk;
    }

    @Override
    public final String getThemeColor() {
        return this.zzhhl;
    }

    @Override
    public final boolean hasGamepadSupport() {
        return this.zzhhm;
    }

    public final Game freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return Arrays.hashCode(new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzaqr(), game.zzaqt(), game.zzaqu(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzaqs(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public final boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzbg.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzbg.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzbg.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzbg.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzbg.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzbg.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzbg.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzbg.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzbg.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzbg.equal((Object)game2.zzaqr(), (Object)game.zzaqr()) && zzbg.equal((Object)game2.zzaqt(), (Object)game.zzaqt()) && zzbg.equal((Object)game2.zzaqu(), (Object)game.zzaqu()) && zzbg.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzbg.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzbg.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzbg.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzbg.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzbg.equal((Object)game2.zzaqs(), (Object)game.zzaqs()) ? 1 : 0)) && zzbg.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzbg.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzbg.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public final String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzbg.zzw((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzaqr()).zzg("InstanceInstalled", (Object)game.zzaqt()).zzg("InstancePackageName", (Object)game.zzaqu()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameEntity gameEntity = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (String)gameEntity.getApplicationId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)2, (String)gameEntity.getDisplayName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (String)gameEntity.getPrimaryCategory(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (String)gameEntity.getSecondaryCategory(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (String)gameEntity.getDescription(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (String)gameEntity.getDeveloperName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)gameEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (Parcelable)gameEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)9, (Parcelable)gameEntity.getFeaturedImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)10, (boolean)gameEntity.zzhgy);
        zzbem.zza((Parcel)parcel2, (int)11, (boolean)gameEntity.zzhgz);
        zzbem.zza((Parcel)parcel2, (int)12, (String)gameEntity.zzhha, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)13, (int)gameEntity.zzhhb);
        zzbem.zzc((Parcel)parcel2, (int)14, (int)gameEntity.getAchievementTotalCount());
        zzbem.zzc((Parcel)parcel2, (int)15, (int)gameEntity.getLeaderboardCount());
        zzbem.zza((Parcel)parcel2, (int)16, (boolean)gameEntity.isRealTimeMultiplayerEnabled());
        zzbem.zza((Parcel)parcel2, (int)17, (boolean)gameEntity.isTurnBasedMultiplayerEnabled());
        zzbem.zza((Parcel)parcel2, (int)18, (String)gameEntity.getIconImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)19, (String)gameEntity.getHiResImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)20, (String)gameEntity.getFeaturedImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)21, (boolean)gameEntity.zzdhg);
        zzbem.zza((Parcel)parcel2, (int)22, (boolean)gameEntity.zzhhj);
        zzbem.zza((Parcel)parcel2, (int)23, (boolean)gameEntity.areSnapshotsEnabled());
        zzbem.zza((Parcel)parcel2, (int)24, (String)gameEntity.getThemeColor(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)25, (boolean)gameEntity.hasGamepadSupport());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzh {
        zza() {
        }

        @Override
        public final GameEntity zzi(Parcel parcel) {
            if (GameEntity.zze(GameEntity.zzaku()) || GameEntity.zzgc((String)GameEntity.class.getCanonicalName())) {
                return super.zzi(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl = parcel.readInt() > 0;
            boolean bl2 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            return new GameEntity(string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl, bl2, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzh)this).zzi(parcel);
        }
    }
}

