/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzap;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzfcj;
    private String zzedu;
    private final Uri zzhgv;
    private final Uri zzhgw;
    private final long zzhja;
    private final int zzhjb;
    private final long zzhjc;
    private final String zzhhg;
    private final String zzhhh;
    private final String zzejt;
    private final zzb zzhjd;
    private final PlayerLevelInfo zzhje;
    private final boolean zzhjf;
    private final boolean zzhjg;
    private final String zzhjh;
    private final String mName;
    private final Uri zzhji;
    private final String zzhjj;
    private final Uri zzhjk;
    private final String zzhjl;
    private final int zzhjm;
    private final long zzhjn;
    private final boolean zzhjo;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    private PlayerEntity(Player player, boolean bl) {
        this.zzfcj = player.getPlayerId();
        this.zzedu = player.getDisplayName();
        this.zzhgv = player.getIconImageUri();
        this.zzhhg = player.getIconImageUrl();
        this.zzhgw = player.getHiResImageUri();
        this.zzhhh = player.getHiResImageUrl();
        this.zzhja = player.getRetrievedTimestamp();
        this.zzhjb = player.zzaqz();
        this.zzhjc = player.getLastPlayedWithTimestamp();
        this.zzejt = player.getTitle();
        this.zzhjf = player.zzara();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzarb();
        this.zzhjd = zza2 == null ? null : new zzb(zza2);
        this.zzhje = player.getLevelInfo();
        this.zzhjg = player.zzaqy();
        this.zzhjh = player.zzaqx();
        this.mName = player.getName();
        this.zzhji = player.getBannerImageLandscapeUri();
        this.zzhjj = player.getBannerImageLandscapeUrl();
        this.zzhjk = player.getBannerImagePortraitUri();
        this.zzhjl = player.getBannerImagePortraitUrl();
        this.zzhjm = player.zzarc();
        this.zzhjn = player.zzard();
        this.zzhjo = player.isMuted();
        zzc.zzu((Object)this.zzfcj);
        zzc.zzu((Object)this.zzedu);
        zzc.checkState((this.zzhja > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzfcj = string;
        this.zzedu = string2;
        this.zzhgv = uri;
        this.zzhhg = string3;
        this.zzhgw = uri2;
        this.zzhhh = string4;
        this.zzhja = l;
        this.zzhjb = n;
        this.zzhjc = l2;
        this.zzejt = string5;
        this.zzhjf = bl;
        this.zzhjd = zzb2;
        this.zzhje = playerLevelInfo;
        this.zzhjg = bl2;
        this.zzhjh = string6;
        this.mName = string7;
        this.zzhji = uri3;
        this.zzhjj = string8;
        this.zzhjk = uri4;
        this.zzhjl = string9;
        this.zzhjm = n2;
        this.zzhjn = l3;
        this.zzhjo = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzfcj;
    }

    @Override
    public final String getDisplayName() {
        return this.zzedu;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzedu, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String zzaqx() {
        return this.zzhjh;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final boolean zzaqy() {
        return this.zzhjg;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhgv;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhhg;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhgw;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhhh;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzhja;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzhjc;
    }

    @Override
    public final int zzaqz() {
        return this.zzhjb;
    }

    @Override
    public final boolean zzara() {
        return this.zzhjf;
    }

    @Override
    public final String getTitle() {
        return this.zzejt;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzejt, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzhje;
    }

    @Override
    public final com.google.android.gms.games.internal.player.zza zzarb() {
        return this.zzhjd;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzhji;
    }

    @Override
    public final String getBannerImageLandscapeUrl() {
        return this.zzhjj;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzhjk;
    }

    @Override
    public final String getBannerImagePortraitUrl() {
        return this.zzhjl;
    }

    @Override
    public final int zzarc() {
        return this.zzhjm;
    }

    @Override
    public final long zzard() {
        return this.zzhjn;
    }

    @Override
    public final boolean isMuted() {
        return this.zzhjo;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzaqy(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzaqx(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzarc(), player.zzard(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbg.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbg.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbg.equal((Object)player2.zzaqy(), (Object)player.zzaqy()) && zzbg.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbg.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbg.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbg.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbg.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbg.equal((Object)player2.zzaqx(), (Object)player.zzaqx()) && zzbg.equal((Object)player2.getName(), (Object)player.getName()) && zzbg.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbg.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbg.equal((Object)player2.zzarc(), (Object)player.zzarc()) && zzbg.equal((Object)player2.zzard(), (Object)player.zzard()) && zzbg.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbg.zzw((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzaqy()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzaqx()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzarc()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzard()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzbem.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzhjb);
        zzbem.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzbem.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzhjd, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzhjf);
        zzbem.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzhjg);
        zzbem.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzhjh, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzhjm);
        zzbem.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzhjn);
        zzbem.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzhjo);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzap {
        zza() {
        }

        @Override
        public final PlayerEntity zzj(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzaku()) || PlayerEntity.zzgc((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzj(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzap)this).zzj(parcel);
        }
    }
}

