/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.api.zzp;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzn;
import com.google.android.gms.games.internal.zzo;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchUpdateCallback;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.zzcc;
import com.google.android.gms.games.zzcd;
import com.google.android.gms.games.zzce;
import com.google.android.gms.games.zzcf;
import com.google.android.gms.games.zzcg;
import com.google.android.gms.games.zzch;
import com.google.android.gms.games.zzci;
import com.google.android.gms.games.zzcj;
import com.google.android.gms.games.zzck;
import com.google.android.gms.games.zzcl;
import com.google.android.gms.games.zzcm;
import com.google.android.gms.games.zzcn;
import com.google.android.gms.games.zzco;
import com.google.android.gms.games.zzcp;
import com.google.android.gms.games.zzcq;
import com.google.android.gms.games.zzcr;
import com.google.android.gms.games.zzcs;
import com.google.android.gms.games.zzct;
import com.google.android.gms.games.zzcu;
import com.google.android.gms.tasks.Task;
import java.util.List;

public class TurnBasedMultiplayerClient
extends zzp {
    private static final zzn<TurnBasedMatch> zzhlj = new zzcu();
    private static final zzbo<TurnBasedMultiplayer.LoadMatchesResult, LoadMatchesResponse> zzhlk = new zzcd();
    private static final zzo<TurnBasedMultiplayer.LoadMatchesResult> zzhll = new zzce();
    private static final zzbo<TurnBasedMultiplayer.LoadMatchResult, TurnBasedMatch> zzhlm = new zzcf();
    private static final zzbo<TurnBasedMultiplayer.CancelMatchResult, String> zzhln = new zzcg();
    private static final com.google.android.gms.games.internal.zzp zzhlo = new zzch();
    private static final zzbo<TurnBasedMultiplayer.LeaveMatchResult, Void> zzhlp = new zzci();
    private static final zzbo<TurnBasedMultiplayer.LeaveMatchResult, TurnBasedMatch> zzhlq = new zzcj();
    private static final com.google.android.gms.games.internal.zzp zzhlr = new zzck();
    private static final zzbo<TurnBasedMultiplayer.UpdateMatchResult, TurnBasedMatch> zzhls = new zzcl();
    private static final zzbo<TurnBasedMultiplayer.InitiateMatchResult, TurnBasedMatch> zzhlt = new zzcm();

    TurnBasedMultiplayerClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    TurnBasedMultiplayerClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Intent> getInboxIntent() {
        return this.zza(new zzcc(this));
    }

    public Task<Void> registerTurnBasedMatchUpdateCallback(@NonNull TurnBasedMatchUpdateCallback turnBasedMatchUpdateCallback) {
        com.google.android.gms.common.api.internal.zzcl zzcl2 = this.zza(turnBasedMatchUpdateCallback, TurnBasedMatchUpdateCallback.class.getSimpleName());
        zzcn zzcn2 = new zzcn(this, zzcl2, zzcl2);
        zzco zzco2 = new zzco(this, zzcl2.zzajc());
        return this.zza(zzcn2, zzco2);
    }

    public Task<Boolean> unregisterTurnBasedMatchUpdateCallback(@NonNull TurnBasedMatchUpdateCallback turnBasedMatchUpdateCallback) {
        return this.zza(com.google.android.gms.common.api.internal.zzcp.zzb((Object)turnBasedMatchUpdateCallback, (String)TurnBasedMatchUpdateCallback.class.getSimpleName()));
    }

    public Task<Intent> getSelectOpponentsIntent(@IntRange(from=1L) int n, @IntRange(from=1L) int n2) {
        return this.getSelectOpponentsIntent(n, n2, true);
    }

    public Task<Intent> getSelectOpponentsIntent(@IntRange(from=1L) int n, @IntRange(from=1L) int n2, boolean bl) {
        return this.zza(new zzcp(this, n, n2, bl));
    }

    public Task<TurnBasedMatch> createMatch(@NonNull TurnBasedMatchConfig turnBasedMatchConfig) {
        return zzg.zza(Games.TurnBasedMultiplayer.createMatch(this.zzagb(), turnBasedMatchConfig), zzhlt);
    }

    public Task<TurnBasedMatch> rematch(@NonNull String string) {
        return zzg.zza(Games.TurnBasedMultiplayer.rematch(this.zzagb(), string), zzhlt);
    }

    public Task<TurnBasedMatch> acceptInvitation(@NonNull String string) {
        return zzg.zza(Games.TurnBasedMultiplayer.acceptInvitation(this.zzagb(), string), zzhlt);
    }

    public Task<Void> declineInvitation(@NonNull String string) {
        return this.zzb(new zzcq(this, string));
    }

    public Task<Void> dismissInvitation(@NonNull String string) {
        return this.zzb(new zzcr(this, string));
    }

    public Task<Integer> getMaxMatchDataSize() {
        return this.zza(new zzcs(this));
    }

    public Task<TurnBasedMatch> takeTurn(@NonNull String string, @Nullable byte[] byArray, @Nullable String string2) {
        return TurnBasedMultiplayerClient.zzg(Games.TurnBasedMultiplayer.takeTurn(this.zzagb(), string, byArray, string2));
    }

    public Task<TurnBasedMatch> takeTurn(@NonNull String string, @Nullable byte[] byArray, @Nullable String string2, ParticipantResult ... participantResultArray) {
        return TurnBasedMultiplayerClient.zzg(Games.TurnBasedMultiplayer.takeTurn(this.zzagb(), string, byArray, string2, participantResultArray));
    }

    public Task<TurnBasedMatch> takeTurn(@NonNull String string, @Nullable byte[] byArray, @Nullable String string2, @Nullable List<ParticipantResult> list) {
        return TurnBasedMultiplayerClient.zzg(Games.TurnBasedMultiplayer.takeTurn(this.zzagb(), string, byArray, string2, list));
    }

    public Task<TurnBasedMatch> finishMatch(@NonNull String string) {
        return TurnBasedMultiplayerClient.zzg(Games.TurnBasedMultiplayer.finishMatch(this.zzagb(), string));
    }

    public Task<TurnBasedMatch> finishMatch(@NonNull String string, @Nullable byte[] byArray, ParticipantResult ... participantResultArray) {
        return TurnBasedMultiplayerClient.zzg(Games.TurnBasedMultiplayer.finishMatch(this.zzagb(), string, byArray, participantResultArray));
    }

    public Task<TurnBasedMatch> finishMatch(@NonNull String string, @Nullable byte[] byArray, @Nullable List<ParticipantResult> list) {
        return TurnBasedMultiplayerClient.zzg(Games.TurnBasedMultiplayer.finishMatch(this.zzagb(), string, byArray, list));
    }

    public Task<Void> leaveMatch(@NonNull String string) {
        return TurnBasedMultiplayerClient.zzf(Games.TurnBasedMultiplayer.leaveMatch(this.zzagb(), string));
    }

    public Task<Void> leaveMatchDuringTurn(@NonNull String string, @Nullable String string2) {
        return TurnBasedMultiplayerClient.zzf(Games.TurnBasedMultiplayer.leaveMatchDuringTurn(this.zzagb(), string, string2));
    }

    public Task<String> cancelMatch(@NonNull String string) {
        return zzg.zza(Games.TurnBasedMultiplayer.cancelMatch(this.zzagb(), string), zzhln);
    }

    public Task<Void> dismissMatch(@NonNull String string) {
        return this.zzb(new zzct(this, string));
    }

    public Task<AnnotatedData<LoadMatchesResponse>> loadMatchesByStatus(@NonNull int[] nArray) {
        return zzg.zza(Games.TurnBasedMultiplayer.loadMatchesByStatus(this.zzagb(), nArray), zzhlk, zzhll);
    }

    public Task<AnnotatedData<LoadMatchesResponse>> loadMatchesByStatus(int n, @NonNull int[] nArray) {
        return zzg.zza(Games.TurnBasedMultiplayer.loadMatchesByStatus(this.zzagb(), n, nArray), zzhlk, zzhll);
    }

    public Task<AnnotatedData<TurnBasedMatch>> loadMatch(@NonNull String string) {
        return zzg.zzb(Games.TurnBasedMultiplayer.loadMatch(this.zzagb(), string), zzhlm);
    }

    private static Task<Void> zzf(@NonNull PendingResult<TurnBasedMultiplayer.LeaveMatchResult> pendingResult) {
        return zzg.zza(pendingResult, zzhlo, zzhlp, zzhlq, zzhlj);
    }

    private static Task<TurnBasedMatch> zzg(@NonNull PendingResult<TurnBasedMultiplayer.UpdateMatchResult> pendingResult) {
        return zzg.zza(pendingResult, zzhlr, zzhls, zzhls, zzhlj);
    }

    public static class MatchOutOfDateApiException
    extends ApiException {
        protected final TurnBasedMatch match;

        MatchOutOfDateApiException(@NonNull Status status, @NonNull TurnBasedMatch turnBasedMatch) {
            super(status);
            this.match = turnBasedMatch;
        }

        public TurnBasedMatch getMatch() {
            return this.match;
        }
    }
}

