/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbi;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzhly;
    private final int zzefe;
    private final String mName;
    private final String zzdou;
    private final Uri zzhlz;
    private final String zzhma;
    private final Uri zzhmb;
    private final String zzhmc;
    private final int zzhmd;
    private final String zzhme;
    private final PlayerEntity zzhmf;
    private final int mState;
    private final int zzhmg;
    private final String zzhmh;
    private final long zzhmi;
    private final long zzhmj;

    public AchievementEntity(Achievement achievement) {
        this.zzhly = achievement.getAchievementId();
        this.zzefe = achievement.getType();
        this.mName = achievement.getName();
        this.zzdou = achievement.getDescription();
        this.zzhlz = achievement.getUnlockedImageUri();
        this.zzhma = achievement.getUnlockedImageUrl();
        this.zzhmb = achievement.getRevealedImageUri();
        this.zzhmc = achievement.getRevealedImageUrl();
        this.zzhmf = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzhmi = achievement.getLastUpdatedTimestamp();
        this.zzhmj = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzhmd = achievement.getTotalSteps();
            this.zzhme = achievement.getFormattedTotalSteps();
            this.zzhmg = achievement.getCurrentSteps();
            this.zzhmh = achievement.getFormattedCurrentSteps();
        } else {
            this.zzhmd = 0;
            this.zzhme = null;
            this.zzhmg = 0;
            this.zzhmh = null;
        }
        com.google.android.gms.common.internal.zzc.zzu((Object)this.zzhly);
        com.google.android.gms.common.internal.zzc.zzu((Object)this.zzdou);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzhly = string;
        this.zzefe = n;
        this.mName = string2;
        this.zzdou = string3;
        this.zzhlz = uri;
        this.zzhma = string4;
        this.zzhmb = uri2;
        this.zzhmc = string5;
        this.zzhmd = n2;
        this.zzhme = string6;
        this.zzhmf = playerEntity;
        this.mState = n3;
        this.zzhmg = n4;
        this.zzhmh = string7;
        this.zzhmi = l;
        this.zzhmj = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzhly;
    }

    @Override
    public final int getType() {
        return this.zzefe;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdou;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdou, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzhlz;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzhma;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzhmb;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzhmc;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhmd;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhme;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhme, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzhmf;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhmg;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhmh;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.checkState((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhmh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhmi;
    }

    @Override
    public final long getXpValue() {
        return this.zzhmj;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbg.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbg.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbg.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbg.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbg.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbg.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbg.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbg.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbg.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbg.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbi zzbi2 = zzbg.zzw((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbi2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbi2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbi2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzbem.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzhmd);
        zzbem.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzhme, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzbem.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzhmg);
        zzbem.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzhmh, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzbem.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }
}

