/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.zzc;
import com.google.android.gms.internal.zzbem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class QuestEntity
extends com.google.android.gms.games.internal.zzc
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new zzc();
    private final GameEntity zzhrl;
    private final String zzhwl;
    private final long zzhwm;
    private final Uri zzhwn;
    private final String zzhwo;
    private final String zzdou;
    private final long zzhwp;
    private final long zzhmi;
    private final Uri zzhwq;
    private final String zzhwr;
    private final String mName;
    private final long zzhws;
    private final long zzhwt;
    private final int mState;
    private final int zzefe;
    private final ArrayList<MilestoneEntity> zzhwu;

    public QuestEntity(Quest quest) {
        this.zzhrl = new GameEntity(quest.getGame());
        this.zzhwl = quest.getQuestId();
        this.zzhwm = quest.getAcceptedTimestamp();
        this.zzdou = quest.getDescription();
        this.zzhwn = quest.getBannerImageUri();
        this.zzhwo = quest.getBannerImageUrl();
        this.zzhwp = quest.getEndTimestamp();
        this.zzhwq = quest.getIconImageUri();
        this.zzhwr = quest.getIconImageUrl();
        this.zzhmi = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzhws = quest.zzatz();
        this.zzhwt = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzefe = quest.getType();
        List<Milestone> list = quest.zzaty();
        int n = list.size();
        this.zzhwu = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhwu.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n, int n2, ArrayList<MilestoneEntity> arrayList) {
        this.zzhrl = gameEntity;
        this.zzhwl = string;
        this.zzhwm = l;
        this.zzhwn = uri;
        this.zzhwo = string2;
        this.zzdou = string3;
        this.zzhwp = l2;
        this.zzhmi = l3;
        this.zzhwq = uri2;
        this.zzhwr = string4;
        this.mName = string5;
        this.zzhws = l4;
        this.zzhwt = l5;
        this.mState = n;
        this.zzefe = n2;
        this.zzhwu = arrayList;
    }

    @Override
    public final String getQuestId() {
        return this.zzhwl;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdou;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdou, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhwq;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhwr;
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzhwn;
    }

    @Override
    public final String getBannerImageUrl() {
        return this.zzhwo;
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzaty().get(0);
    }

    @Override
    public final List<Milestone> zzaty() {
        return new ArrayList<Milestone>(this.zzhwu);
    }

    @Override
    public final Game getGame() {
        return this.zzhrl;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getType() {
        return this.zzefe;
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.zzhwm;
    }

    @Override
    public final long getEndTimestamp() {
        return this.zzhwp;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhmi;
    }

    @Override
    public final long zzatz() {
        return this.zzhws;
    }

    @Override
    public final long getStartTimestamp() {
        return this.zzhwt;
    }

    @Override
    public final boolean isEndingSoon() {
        return this.zzhws <= System.currentTimeMillis() + 1800000L;
    }

    public final Quest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return Arrays.hashCode(new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzaty(), quest.getName(), quest.zzatz(), quest.getStartTimestamp(), quest.getState()});
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzbg.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzbg.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzbg.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzbg.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzbg.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzbg.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzbg.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzbg.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzbg.equal(quest2.zzaty(), quest.zzaty()) && zzbg.equal((Object)quest2.getName(), (Object)quest.getName()) && zzbg.equal((Object)quest2.zzatz(), (Object)quest.zzatz()) && zzbg.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzbg.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzbg.zzw((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzaty()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzatz()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        QuestEntity questEntity = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (Parcelable)questEntity.getGame(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)2, (String)questEntity.getQuestId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (long)questEntity.getAcceptedTimestamp());
        zzbem.zza((Parcel)parcel2, (int)4, (Parcelable)questEntity.getBannerImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (String)questEntity.getBannerImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (String)questEntity.getDescription(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (long)questEntity.getEndTimestamp());
        zzbem.zza((Parcel)parcel2, (int)8, (long)questEntity.getLastUpdatedTimestamp());
        zzbem.zza((Parcel)parcel2, (int)9, (Parcelable)questEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)10, (String)questEntity.getIconImageUrl(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)12, (String)questEntity.getName(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)13, (long)questEntity.zzhws);
        zzbem.zza((Parcel)parcel2, (int)14, (long)questEntity.getStartTimestamp());
        zzbem.zzc((Parcel)parcel2, (int)15, (int)questEntity.getState());
        zzbem.zzc((Parcel)parcel2, (int)16, (int)questEntity.zzefe);
        zzbem.zzc((Parcel)parcel2, (int)17, questEntity.zzaty(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }
}

