/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.internal.zzf;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.zzb;
import com.google.android.gms.internal.zzbem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public final class zza
extends zzc
implements SnapshotContents {
    private static final Object zzhwz = new Object();
    public static final Parcelable.Creator<zza> CREATOR = new zzb();
    private com.google.android.gms.drive.zzc zzglf;

    public zza(com.google.android.gms.drive.zzc zzc2) {
        this.zzglf = zzc2;
    }

    @Override
    public final ParcelFileDescriptor getParcelFileDescriptor() {
        zzbq.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Cannot mutate closed contents!");
        return this.zzglf.getParcelFileDescriptor();
    }

    @Override
    public final com.google.android.gms.drive.zzc zzanp() {
        return this.zzglf;
    }

    @Override
    public final void close() {
        this.zzglf = null;
    }

    @Override
    public final boolean isClosed() {
        return this.zzglf == null;
    }

    @Override
    public final byte[] readFully() throws IOException {
        zzbq.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened Snapshot");
        Object object = zzhwz;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.zzglf.getParcelFileDescriptor();
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                fileInputStream.getChannel().position(0L);
                byte[] byArray = zzn.zza((InputStream)bufferedInputStream, (boolean)false);
                fileInputStream.getChannel().position(0L);
                return byArray;
            }
            catch (IOException iOException) {
                zzf.zzc("SnapshotContentsEntity", "Failed to read snapshot data", iOException);
                throw iOException;
            }
        }
    }

    @Override
    public final boolean writeBytes(byte[] byArray) {
        return this.zza(0, byArray, 0, byArray.length, true);
    }

    @Override
    public final boolean modifyBytes(int n, byte[] byArray, int n2, int n3) {
        return this.zza(n, byArray, n2, byArray.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, byte[] byArray, int n2, int n3, boolean bl) {
        zzbq.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened SnapshotContents");
        Object object = zzhwz;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.zzglf.getParcelFileDescriptor();
            FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.position(n);
                ((OutputStream)bufferedOutputStream).write(byArray, n2, n3);
                if (bl) {
                    fileChannel.truncate(byArray.length);
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            catch (IOException iOException) {
                zzf.zzb("SnapshotContentsEntity", "Failed to write snapshot data", iOException);
                return false;
            }
            return true;
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zza zza2 = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (Parcelable)zza2.zzglf, (int)n, (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }
}

