/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.zza;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;

public final class VideoCapabilities
extends zzc {
    public static final Parcelable.Creator<VideoCapabilities> CREATOR = new zza();
    private final boolean zzhyg;
    private final boolean zzhyh;
    private final boolean zzhyi;
    private final boolean[] zzhyj;
    private final boolean[] zzhyk;

    public VideoCapabilities(boolean bl, boolean bl2, boolean bl3, boolean[] blArray, boolean[] blArray2) {
        this.zzhyg = bl;
        this.zzhyh = bl2;
        this.zzhyi = bl3;
        this.zzhyj = blArray;
        this.zzhyk = blArray2;
    }

    public final boolean isMicSupported() {
        return this.zzhyh;
    }

    public final boolean isCameraSupported() {
        return this.zzhyg;
    }

    public final boolean isWriteStorageSupported() {
        return this.zzhyi;
    }

    public final boolean[] getSupportedCaptureModes() {
        return this.zzhyj;
    }

    public final boolean[] getSupportedQualityLevels() {
        return this.zzhyk;
    }

    public final boolean supportsCaptureMode(int n) {
        zzbq.checkState((boolean)VideoConfiguration.isValidCaptureMode(n, false));
        return this.zzhyj[n];
    }

    public final boolean supportsQualityLevel(int n) {
        zzbq.checkState((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        return this.zzhyk[n];
    }

    public final boolean isFullySupported(int n, int n2) {
        return this.zzhyg && this.zzhyh && this.zzhyi && this.supportsCaptureMode(n) && this.supportsQualityLevel(n2);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.getSupportedCaptureModes(), this.getSupportedQualityLevels(), this.isCameraSupported(), this.isMicSupported(), this.isWriteStorageSupported()});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof VideoCapabilities)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        VideoCapabilities videoCapabilities = (VideoCapabilities)((Object)object);
        return zzbg.equal((Object)videoCapabilities.getSupportedCaptureModes(), (Object)this.getSupportedCaptureModes()) && zzbg.equal((Object)videoCapabilities.getSupportedQualityLevels(), (Object)this.getSupportedQualityLevels()) && zzbg.equal((Object)videoCapabilities.isCameraSupported(), (Object)this.isCameraSupported()) && zzbg.equal((Object)videoCapabilities.isMicSupported(), (Object)this.isMicSupported()) && zzbg.equal((Object)videoCapabilities.isWriteStorageSupported(), (Object)this.isWriteStorageSupported());
    }

    public final String toString() {
        return zzbg.zzw((Object)((Object)this)).zzg("SupportedCaptureModes", (Object)this.getSupportedCaptureModes()).zzg("SupportedQualityLevels", (Object)this.getSupportedQualityLevels()).zzg("CameraSupported", (Object)this.isCameraSupported()).zzg("MicSupported", (Object)this.isMicSupported()).zzg("StorageWriteSupported", (Object)this.isWriteStorageSupported()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoCapabilities videoCapabilities = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (boolean)videoCapabilities.isCameraSupported());
        zzbem.zza((Parcel)parcel2, (int)2, (boolean)videoCapabilities.isMicSupported());
        zzbem.zza((Parcel)parcel2, (int)3, (boolean)videoCapabilities.isWriteStorageSupported());
        zzbem.zza((Parcel)parcel2, (int)4, (boolean[])videoCapabilities.getSupportedCaptureModes(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (boolean[])videoCapabilities.getSupportedQualityLevels(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }
}

