/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.zzf;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzhyo;
    private final TurnBasedMatchBuffer zzhyp;
    private final TurnBasedMatchBuffer zzhyq;
    private final TurnBasedMatchBuffer zzhyr;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzhyo = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzhyp = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzhyq = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        if (dataHolder4 != null) {
            this.zzhyr = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzhyr = null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zzf.zzw("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zzhyo;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzhyp;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzhyq;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzhyr;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zzhyo != null) {
            this.zzhyo.release();
        }
        if (this.zzhyp != null) {
            this.zzhyp.release();
        }
        if (this.zzhyq != null) {
            this.zzhyq.release();
        }
        if (this.zzhyr != null) {
            this.zzhyr.release();
        }
    }

    public final boolean hasData() {
        if (this.zzhyo != null && this.zzhyo.getCount() > 0) {
            return true;
        }
        if (this.zzhyp != null && this.zzhyp.getCount() > 0) {
            return true;
        }
        if (this.zzhyq != null && this.zzhyq.getCount() > 0) {
            return true;
        }
        return this.zzhyr != null && this.zzhyr.getCount() > 0;
    }
}

