/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.zzc;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class QuestEntity
extends com.google.android.gms.games.internal.zzc
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new zzc();
    private final GameEntity zzhug;
    private final String zzhzg;
    private final long zzhzh;
    private final Uri zzhzi;
    private final String zzhzj;
    private final String zzdrs;
    private final long zzhzk;
    private final long zzhpd;
    private final Uri zzhzl;
    private final String zzhzm;
    private final String mName;
    private final long zzhzn;
    private final long zzhzo;
    private final int mState;
    private final int zzeie;
    private final ArrayList<MilestoneEntity> zzhzp;

    public QuestEntity(Quest quest) {
        this.zzhug = new GameEntity(quest.getGame());
        this.zzhzg = quest.getQuestId();
        this.zzhzh = quest.getAcceptedTimestamp();
        this.zzdrs = quest.getDescription();
        this.zzhzi = quest.getBannerImageUri();
        this.zzhzj = quest.getBannerImageUrl();
        this.zzhzk = quest.getEndTimestamp();
        this.zzhzl = quest.getIconImageUri();
        this.zzhzm = quest.getIconImageUrl();
        this.zzhpd = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzhzn = quest.zzaul();
        this.zzhzo = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzeie = quest.getType();
        List<Milestone> list = quest.zzauk();
        int n = list.size();
        this.zzhzp = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhzp.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n, int n2, ArrayList<MilestoneEntity> arrayList) {
        this.zzhug = gameEntity;
        this.zzhzg = string;
        this.zzhzh = l;
        this.zzhzi = uri;
        this.zzhzj = string2;
        this.zzdrs = string3;
        this.zzhzk = l2;
        this.zzhpd = l3;
        this.zzhzl = uri2;
        this.zzhzm = string4;
        this.mName = string5;
        this.zzhzn = l4;
        this.zzhzo = l5;
        this.mState = n;
        this.zzeie = n2;
        this.zzhzp = arrayList;
    }

    @Override
    public final String getQuestId() {
        return this.zzhzg;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdrs;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdrs, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhzl;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhzm;
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzhzi;
    }

    @Override
    public final String getBannerImageUrl() {
        return this.zzhzj;
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzauk().get(0);
    }

    @Override
    public final List<Milestone> zzauk() {
        return new ArrayList<Milestone>(this.zzhzp);
    }

    @Override
    public final Game getGame() {
        return this.zzhug;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getType() {
        return this.zzeie;
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.zzhzh;
    }

    @Override
    public final long getEndTimestamp() {
        return this.zzhzk;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhpd;
    }

    @Override
    public final long zzaul() {
        return this.zzhzn;
    }

    @Override
    public final long getStartTimestamp() {
        return this.zzhzo;
    }

    @Override
    public final boolean isEndingSoon() {
        return this.zzhzn <= System.currentTimeMillis() + 1800000L;
    }

    public final Quest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return Arrays.hashCode(new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzauk(), quest.getName(), quest.zzaul(), quest.getStartTimestamp(), quest.getState()});
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzbg.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzbg.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzbg.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzbg.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzbg.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzbg.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzbg.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzbg.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzbg.equal(quest2.zzauk(), quest.zzauk()) && zzbg.equal((Object)quest2.getName(), (Object)quest.getName()) && zzbg.equal((Object)quest2.zzaul(), (Object)quest.zzaul()) && zzbg.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzbg.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzbg.zzx((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzauk()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzaul()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        QuestEntity questEntity = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (Parcelable)questEntity.getGame(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)questEntity.getQuestId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (long)questEntity.getAcceptedTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)4, (Parcelable)questEntity.getBannerImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)questEntity.getBannerImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (String)questEntity.getDescription(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (long)questEntity.getEndTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)8, (long)questEntity.getLastUpdatedTimestamp());
        zzbfp.zza((Parcel)parcel2, (int)9, (Parcelable)questEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)10, (String)questEntity.getIconImageUrl(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)12, (String)questEntity.getName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)13, (long)questEntity.zzhzn);
        zzbfp.zza((Parcel)parcel2, (int)14, (long)questEntity.getStartTimestamp());
        zzbfp.zzc((Parcel)parcel2, (int)15, (int)questEntity.getState());
        zzbfp.zzc((Parcel)parcel2, (int)16, (int)questEntity.zzeie);
        zzbfp.zzc((Parcel)parcel2, (int)17, questEntity.zzauk(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }
}

