/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzaum();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzdrs;
        private Long zzhzx;
        private Long zzhzy;
        private BitmapTeleporter zzhzz;
        private Uri zziaa;

        public Builder() {
        }

        public final Builder setDescription(String string) {
            this.zzdrs = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzhzx = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzhzy = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zzhzz = new BitmapTeleporter(bitmap);
            this.zziaa = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzdrs = snapshotMetadata.getDescription();
            this.zzhzx = snapshotMetadata.getPlayedTime();
            this.zzhzy = snapshotMetadata.getProgressValue();
            if (this.zzhzx == -1L) {
                this.zzhzx = null;
            }
            this.zziaa = snapshotMetadata.getCoverImageUri();
            if (this.zziaa != null) {
                this.zzhzz = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zzdrs, this.zzhzx, this.zzhzz, this.zziaa, this.zzhzy);
        }
    }
}

