/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.internal.zzg;
import com.google.android.gms.games.internal.zzp;
import com.google.android.gms.games.zza;
import com.google.android.gms.games.zzb;
import com.google.android.gms.games.zzc;
import com.google.android.gms.games.zzd;
import com.google.android.gms.games.zze;
import com.google.android.gms.tasks.Task;

public class AchievementsClient
extends com.google.android.gms.games.internal.api.zzp {
    private static final zzbo<Achievements.LoadAchievementsResult, AchievementBuffer> zzb = new zzb();
    private static final zzbo<Achievements.UpdateAchievementResult, Void> zzc = new zzc();
    private static final zzbo<Achievements.UpdateAchievementResult, Boolean> zzd = new zzd();
    private static final zzp zze = new zze();

    @Hide
    AchievementsClient(@NonNull Context context, @NonNull Games.GamesOptions gamesOptions) {
        super(context, gamesOptions);
    }

    @Hide
    AchievementsClient(@NonNull Activity activity, @NonNull Games.GamesOptions gamesOptions) {
        super(activity, gamesOptions);
    }

    public Task<Intent> getAchievementsIntent() {
        return this.zza(new zza(this));
    }

    public Task<AnnotatedData<AchievementBuffer>> load(boolean bl) {
        return zzg.zzc(Games.Achievements.load(this.zze(), bl), zzb);
    }

    public void reveal(@NonNull String string) {
        Games.Achievements.reveal(this.zze(), string);
    }

    public Task<Void> revealImmediate(@NonNull String string) {
        return AchievementsClient.zza(Games.Achievements.revealImmediate(this.zze(), string));
    }

    public void unlock(@NonNull String string) {
        Games.Achievements.unlock(this.zze(), string);
    }

    public Task<Void> unlockImmediate(@NonNull String string) {
        return AchievementsClient.zza(Games.Achievements.unlockImmediate(this.zze(), string));
    }

    public void increment(@NonNull String string, @IntRange(from=0L) int n) {
        Games.Achievements.increment(this.zze(), string, n);
    }

    public Task<Boolean> incrementImmediate(@NonNull String string, @IntRange(from=0L) int n) {
        return AchievementsClient.zzb(Games.Achievements.incrementImmediate(this.zze(), string, n));
    }

    public void setSteps(@NonNull String string, @IntRange(from=0L) int n) {
        Games.Achievements.setSteps(this.zze(), string, n);
    }

    public Task<Boolean> setStepsImmediate(@NonNull String string, @IntRange(from=0L) int n) {
        return AchievementsClient.zzb(Games.Achievements.setStepsImmediate(this.zze(), string, n));
    }

    private static Task<Void> zza(@NonNull PendingResult<Achievements.UpdateAchievementResult> pendingResult) {
        return zzg.zza(pendingResult, zze, zzc);
    }

    private static Task<Boolean> zzb(@NonNull PendingResult<Achievements.UpdateAchievementResult> pendingResult) {
        return zzg.zza(pendingResult, zze, zzd);
    }
}

