/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesClientStatusCodes;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzcct;
import com.google.android.gms.internal.zzccv;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcyt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GamesClientImpl
extends com.google.android.gms.common.internal.zzab<com.google.android.gms.games.internal.zzw> {
    private zzccv zzd = new com.google.android.gms.games.internal.zzd(this);
    private final String zze;
    private PlayerEntity zzf;
    private GameEntity zzg;
    private final com.google.android.gms.games.internal.zzaa zzh;
    private boolean zzi = false;
    private final Binder zzj;
    private final long zzk;
    private final Games.GamesOptions zzl;
    private boolean zzm = false;
    private Bundle zzn;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzr zzr2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zze = zzr2.zzh();
        this.zzj = new Binder();
        int n = zzr2.zzd();
        GamesClientImpl gamesClientImpl = this;
        this.zzh = new com.google.android.gms.games.internal.zzad(gamesClientImpl, n);
        this.zzk = ((Object)((Object)this)).hashCode();
        this.zzl = gamesOptions;
        if (!this.zzl.zzi && (zzr2.zzj() != null || context instanceof Activity)) {
            this.zza(zzr2.zzj());
        }
    }

    public final boolean l_() {
        return true;
    }

    public final void zza(ConnectionResult connectionResult) {
        super.zza(connectionResult);
        this.zzi = false;
    }

    public final void zzc(int n) {
        int n2;
        this.zzh.zzb.zzb = n2 = n;
    }

    public final void zza(View view) {
        this.zzh.zza(view);
    }

    protected final Set<Scope> zza(Set<Scope> set) {
        HashSet<Scope> hashSet = new HashSet<Scope>(set);
        boolean bl = set.contains(Games.SCOPE_GAMES);
        boolean bl2 = set.contains(Games.SCOPE_GAMES_LITE);
        if (set.contains(Games.zzb)) {
            com.google.android.gms.common.internal.zzbq.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            com.google.android.gms.common.internal.zzbq.zza((bl || bl2 ? 1 : 0) != 0, (String)"Games APIs requires %s function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games_lite"});
            if (bl2 && bl) {
                hashSet.remove(Games.SCOPE_GAMES_LITE);
            }
        }
        return hashSet;
    }

    public final void zza(com.google.android.gms.common.internal.zzj zzj2) {
        GamesClientImpl gamesClientImpl = this;
        this.zzf = null;
        gamesClientImpl.zzg = null;
        super.zza(zzj2);
    }

    public final void zzg() {
        this.zzi = false;
        if (this.zzs()) {
            try {
                com.google.android.gms.games.internal.zzw zzw2 = (com.google.android.gms.games.internal.zzw)this.zzaf();
                zzw2.zzc();
                this.zzd.zzb();
                zzw2.zza(this.zzk);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.games.internal.zzf.zza("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.zzg();
    }

    protected final String zza() {
        return "com.google.android.gms.games.service.START";
    }

    protected final String zzb() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    public final Bundle q_() {
        try {
            Bundle bundle = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
                this.zzn = bundle;
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    @Nullable
    public final Bundle zzi() {
        Bundle bundle = this.q_();
        if (bundle == null) {
            bundle = this.zzn;
        }
        this.zzn = null;
        return bundle;
    }

    protected final Bundle zzc() {
        String string = this.zzaa().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzl.zza();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zze);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzh.zzb.zza));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzcyt.zza((com.google.android.gms.common.internal.zzr)this.zzai()));
        return bundle;
    }

    public final String zzj() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzd();
    }

    public final String zzk() {
        try {
            return this.zzj();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    @Hide
    public final void zza(String string, com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) throws RemoteException {
        com.google.android.gms.common.internal.zzbq.zza((String)string, (Object)"Please provide a valid serverClientId");
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(string, new zzy(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final String zza(boolean bl) throws RemoteException {
        if (this.zzf != null) {
            return this.zzf.getPlayerId();
        }
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zze();
    }

    public final String zzb(boolean bl) {
        try {
            return this.zza(true);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Player zzl() throws RemoteException {
        this.zzae();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzf == null) {
                PlayerBuffer playerBuffer = new PlayerBuffer(((com.google.android.gms.games.internal.zzw)this.zzaf()).zzf());
                try {
                    if (playerBuffer.getCount() > 0) {
                        this.zzf = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                    }
                }
                finally {
                    playerBuffer.release();
                }
            }
        }
        return this.zzf;
    }

    public final Player zzm() {
        try {
            return this.zzl();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Game zzn() throws RemoteException {
        this.zzae();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzg == null) {
                GameBuffer gameBuffer = new GameBuffer(((com.google.android.gms.games.internal.zzw)this.zzaf()).zzg());
                try {
                    if (gameBuffer.getCount() > 0) {
                        this.zzg = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                    }
                }
                finally {
                    gameBuffer.release();
                }
            }
        }
        return this.zzg;
    }

    public final Game zzo() {
        try {
            return this.zzn();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    @Hide
    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, int n, boolean bl, boolean bl2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    @Hide
    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), string, n, bl, bl2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzc((com.google.android.gms.games.internal.zzs)new zzbn(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzp() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzi();
    }

    public final Intent zzq() {
        try {
            return this.zzp();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final Intent zza(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(string, n, n2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb((com.google.android.gms.games.internal.zzs)new zzai(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, String string, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzai(zzn2), string, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2, String string, String string2, int n, int n2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzbl(zzn2), null, string2, n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(new zzah(zzn2), string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb(new zzah(zzn2), string, n, n2, n3, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzah(zzn2), leaderboardScoreBuffer.zzb().zza(), n, n2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2, String string, long l, String string2) throws RemoteException {
        zzcl zzcl2 = zzn2 == null ? null : new zzcl(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)zzcl2, string, l, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzr() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzj();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzf(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)zze2, string, this.zzh.zzb.zza, this.zzh.zzb.zza());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb(zze2, string, this.zzh.zzb.zza, this.zzh.zzb.zza());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)zze2, string, n, this.zzh.zzb.zza, this.zzh.zzb.zza());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb(zze2, string, n, this.zzh.zzb.zza, this.zzh.zzb.zza());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl) throws RemoteException {
        this.zzd.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zze((com.google.android.gms.games.internal.zzs)new zzu(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzd.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzu(zzn2), bl, stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(String string, int n) {
        this.zzd.zza(string, n);
    }

    public final Intent zzaj() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzk();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzak() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzl();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) throws RemoteException {
        zzab zzab2 = new zzab(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)zzab2, this.zzk);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) {
        try {
            this.zza(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzal() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb(this.zzk);
    }

    public final void zzam() {
        try {
            this.zzal();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) throws RemoteException {
        zzaz zzaz2 = new zzaz(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb((com.google.android.gms.games.internal.zzs)zzaz2, this.zzk);
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) {
        try {
            this.zzc(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzan() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzc(this.zzk);
    }

    public final void zzao() {
        try {
            this.zzan();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zzci2) {
        try {
            zzbs zzbs2 = new zzbs(zzci2);
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzd((com.google.android.gms.games.internal.zzs)zzbs2, this.zzk);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzap() {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zze(this.zzk);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zzci2) {
        try {
            zzbw zzbw2 = new zzbw(zzci2);
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzc((com.google.android.gms.games.internal.zzs)zzbw2, this.zzk);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzaq() {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzd(this.zzk);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final Intent zza(PlayerEntity playerEntity) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(playerEntity);
    }

    public final Intent zzb(PlayerEntity playerEntity) {
        try {
            return this.zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final Intent zzar() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzm();
    }

    public final Intent zzas() {
        try {
            return this.zzar();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final Intent zza(Room room, int n) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((RoomEntity)room.freeze(), n);
    }

    public final Intent zzb(Room room, int n) {
        try {
            return this.zza(room, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final Intent zzat() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzn();
    }

    public final Intent zzau() {
        try {
            return this.zzat();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb(new zzx(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(@NonNull com.google.android.gms.common.internal.zzp zzp2) {
        try {
            this.zzb(new com.google.android.gms.games.internal.zze(this, zzp2));
            return;
        }
        catch (RemoteException remoteException) {
            zzp2.zza();
            return;
        }
    }

    @Hide
    public final void zzb(com.google.android.gms.common.api.internal.zzn<Status> zzn2) throws RemoteException {
        this.zzd.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(new zzcg(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final int zzav() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzo();
    }

    public final int zzaw() {
        try {
            return this.zzav();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return 4368;
        }
    }

    public final String zzax() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza();
    }

    public final String zzay() {
        try {
            return this.zzax();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzae(zzn2), n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(String string, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb(string, n);
    }

    public final void zzc(String string, int n) {
        try {
            this.zzb(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzd(String string, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(string, n);
    }

    public final void zze(String string, int n) {
        try {
            this.zzd(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final Intent zza(int n, int n2, boolean bl) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(n, n2, bl);
    }

    public final Intent zzb(int n, int n2, boolean bl) {
        try {
            return this.zza(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzco(zzn2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zza(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb((com.google.android.gms.games.internal.zzs)new zzco(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzc((com.google.android.gms.games.internal.zzs)new zzco(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final int zzaz() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzh();
    }

    public final int zzba() {
        try {
            return this.zzaz();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return -1;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzcs(zzn2), string, byArray, string2, participantResultArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzcs(zzn2), string, byArray, participantResultArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zze((com.google.android.gms.games.internal.zzs)new zzcp(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string, String string2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzcp(zzn2), string, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzd((com.google.android.gms.games.internal.zzs)new zzcn(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(string);
    }

    public final void zzb(String string) {
        try {
            this.zza(string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2, int n, int[] nArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzct(zzn2), n, nArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzf((com.google.android.gms.games.internal.zzs)new zzcq(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzc(int n, int n2, boolean bl) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb(n, n2, bl);
    }

    public final Intent zzd(int n, int n2, boolean bl) {
        try {
            return this.zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) throws RemoteException {
        zzcc zzcc2 = new zzcc(zzci2, zzci3, zzci4);
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(zzcc2, (IBinder)this.zzj, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzk);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) {
        try {
            this.zza(zzci2, zzci3, zzci4, roomConfig);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) throws RemoteException {
        zzcc zzcc2 = new zzcc(zzci2, zzci3, zzci4);
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)zzcc2, (IBinder)this.zzj, roomConfig.getInvitationId(), false, this.zzk);
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4, RoomConfig roomConfig) {
        try {
            this.zzc(zzci2, zzci3, zzci4, roomConfig);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, String string) {
        try {
            String string2 = string;
            com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci3 = zzci2;
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzcc(zzci3), string2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final int zza(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2, byte[] byArray, String string, String string2) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzbv(zzci2), byArray, string, string2);
    }

    public final int zzb(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2, byte[] byArray, String string, String string2) {
        try {
            return this.zza(zzci2, byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string, String[] stringArray) {
        com.google.android.gms.common.internal.zzbq.zza((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            String[] stringArray2 = stringArray;
            String string2 = string;
            byte[] byArray2 = byArray;
            GamesClientImpl gamesClientImpl = this;
            com.google.android.gms.common.internal.zzbq.zza((Object)stringArray2, (Object)"Participant IDs must not be null");
            return ((com.google.android.gms.games.internal.zzw)gamesClientImpl.zzaf()).zza(byArray2, string2, stringArray2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(byArray, string, null);
    }

    public final int zzb(byte[] byArray, String string) {
        try {
            return this.zza(byArray, string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return -1;
        }
    }

    public final void zzd(int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(n);
    }

    public final void zze(int n) {
        try {
            this.zzd(n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final Intent zzbb() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzr();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(n, byArray, n2, string);
            com.google.android.gms.common.internal.zzbq.zza((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            intent = null;
        }
        return intent;
    }

    public final int zzbc() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzp();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
        }
        return n;
    }

    public final int zzbd() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzq();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
        }
        return n;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzca(zzn2), stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb((com.google.android.gms.games.internal.zzs)new zzca(zzn2), stringArray);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2, int n, int n2, int n3) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzbz(zzn2), n, n2, n3);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzf((com.google.android.gms.games.internal.zzs)new zzbm(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zza(int[] nArray) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(nArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzc(String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb(string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2, String string) throws RemoteException {
        this.zzd.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzh(new zzbp(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string, String string2) throws RemoteException {
        this.zzd.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb((com.google.android.gms.games.internal.zzs)new zzbr(zzn2, string2), string, string2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzd.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzbt(zzn2), nArray, n, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzd.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzbt(zzn2), stringArray, bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzd(String string) {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(string, this.zzh.zzb.zza, this.zzh.zzb.zza());
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final int zzbe() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzs();
    }

    public final int zzbf() {
        try {
            return this.zzbe();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return -1;
        }
    }

    public final int zzbg() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzt();
    }

    public final int zzbh() {
        try {
            return this.zzbg();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return -1;
        }
    }

    public final Intent zza(String string, boolean bl, boolean bl2, int n) throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(string, bl, bl2, n);
    }

    public final Intent zzb(String string, boolean bl, boolean bl2, int n) {
        try {
            return this.zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2, boolean bl) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzd((com.google.android.gms.games.internal.zzs)new zzck(zzn2), bl);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, boolean bl, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzcj(zzn2), string, bl, n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zza();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zza(this.zzaa().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zza();
        snapshotContents.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzch(zzn2), snapshot.getMetadata().getSnapshotId(), (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(Snapshot snapshot) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zza();
        snapshotContents.zzb();
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(zzc2);
    }

    public final void zzb(Snapshot snapshot) {
        try {
            this.zza(snapshot);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2, String string) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzg(new zzci(zzn2), string);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        com.google.android.gms.common.internal.zzbq.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zza();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zza(this.zzaa().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zza();
        snapshotContents.zzb();
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza((com.google.android.gms.games.internal.zzs)new zzcj(zzn2), string, string2, (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzc(new zzj(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final Intent zzbi() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzu();
    }

    public final Intent zzbj() {
        try {
            return this.zzbi();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return null;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzd(new zzn(zzn2));
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2, int n) throws RemoteException {
        try {
            ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzb((com.google.android.gms.games.internal.zzs)new zzh(zzn2), n);
            return;
        }
        catch (SecurityException securityException) {
            GamesClientImpl.zza(zzn2, securityException);
            return;
        }
    }

    public final boolean zzbk() throws RemoteException {
        return ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzv();
    }

    public final boolean zzbl() {
        try {
            return this.zzbk();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return false;
        }
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) throws RemoteException {
        zzl zzl2 = new zzl(zzci2);
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zze((com.google.android.gms.games.internal.zzs)zzl2, this.zzk);
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) {
        try {
            this.zzg(zzci2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    public final void zzbm() throws RemoteException {
        ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzf(this.zzk);
    }

    public final void zzbn() {
        try {
            this.zzbm();
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zza(remoteException);
            return;
        }
    }

    @Hide
    public final void zza(IBinder iBinder, Bundle bundle) {
        if (this.zzs()) {
            try {
                ((com.google.android.gms.games.internal.zzw)this.zzaf()).zza(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zza(remoteException);
            }
        }
    }

    @Hide
    public final void zzbo() {
        if (this.zzs()) {
            try {
                ((com.google.android.gms.games.internal.zzw)this.zzaf()).zzc();
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zza(remoteException);
            }
        }
    }

    private static void zza(RemoteException remoteException) {
        com.google.android.gms.games.internal.zzf.zzb("GamesClientImpl", "service died", remoteException);
    }

    private static void zza(SecurityException securityException) {
        com.google.android.gms.games.internal.zzf.zzc("GamesClientImpl", "Is player signed out?", securityException);
    }

    private static <R> void zza(com.google.android.gms.common.api.internal.zzn<R> zzn2, SecurityException securityException) {
        if (zzn2 != null) {
            zzn2.zzc(GamesClientStatusCodes.zza(4));
        }
    }

    private static Room zzb(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.zzb zzb2 = new com.google.android.gms.games.multiplayer.realtime.zzb(dataHolder);
        Room room = null;
        try {
            if (zzb2.getCount() > 0) {
                room = (Room)((Room)zzb2.get(0)).freeze();
            }
        }
        finally {
            zzb2.release();
        }
        return room;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzm = this.zzi = bundle.getBoolean("show_welcome_popup");
            this.zzf = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzg = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        com.google.android.gms.games.internal.zzw zzw2 = (com.google.android.gms.games.internal.zzw)iInterface;
        GamesClientImpl gamesClientImpl = this;
        super.zza((IInterface)zzw2);
        if (gamesClientImpl.zzi) {
            gamesClientImpl.zzh.zza();
            gamesClientImpl.zzi = false;
        }
        if (!gamesClientImpl.zzl.zza && !gamesClientImpl.zzl.zzi) {
            com.google.android.gms.games.internal.zzw zzw3 = zzw2;
            GamesClientImpl gamesClientImpl2 = gamesClientImpl;
            try {
                zzbo zzbo2 = new zzbo(gamesClientImpl2.zzh);
                zzw3.zza(zzbo2, gamesClientImpl2.zzk);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zza(remoteException);
            }
        }
    }

    protected final /* synthetic */ IInterface zza(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof com.google.android.gms.games.internal.zzw) {
            return (com.google.android.gms.games.internal.zzw)iInterface;
        }
        return new com.google.android.gms.games.internal.zzx(iBinder2);
    }

    static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final String zza;

        public final Status getStatus() {
            throw new NoSuchMethodError();
        }

        @Override
        public final String getUrl() {
            return this.zza;
        }
    }

    static final class zzo
    implements Videos.CaptureStateResult {
        private final Status zza;
        private final CaptureState zzb;

        zzo(Status status, CaptureState captureState) {
            this.zza = status;
            this.zzb = captureState;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final CaptureState getCaptureState() {
            return this.zzb;
        }
    }

    static final class zzk
    implements Videos.CaptureCapabilitiesResult {
        private final Status zza;
        private final VideoCapabilities zzb;

        zzk(Status status, VideoCapabilities videoCapabilities) {
            this.zza = status;
            this.zzb = videoCapabilities;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final VideoCapabilities getCapabilities() {
            return this.zzb;
        }
    }

    static final class zzi
    implements Videos.CaptureAvailableResult {
        private final Status zza;
        private final boolean zzb;

        zzi(Status status, boolean bl) {
            this.zza = status;
            this.zzb = bl;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final boolean isAvailable() {
            return this.zzb;
        }
    }

    static final class zzs
    implements Snapshots.DeleteSnapshotResult {
        private final Status zza;
        private final String zzb;

        zzs(int n, String string) {
            this.zza = GamesStatusCodes.zza(n);
            this.zzb = string;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final String getSnapshotId() {
            return this.zzb;
        }
    }

    static final class zzq
    extends zzw
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzb;

        zzq(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzb = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
                return;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public final SnapshotMetadata getSnapshotMetadata() {
            return this.zzb;
        }
    }

    static final class zzbc
    extends zzw
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzb;
        private final String zzc;
        private final Snapshot zzd;
        private final com.google.android.gms.drive.zzc zze;
        private final SnapshotContents zzf;

        zzbc(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        zzbc(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzb = null;
                    this.zzd = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzc.zza((dataHolder.zzb() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzb = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    this.zzd = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzb = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzd = new SnapshotEntity(snapshotMetadataEntity2, new com.google.android.gms.games.snapshot.zza(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzc = string;
            this.zze = zzc4;
            this.zzf = new com.google.android.gms.games.snapshot.zza(zzc4);
        }

        @Override
        public final Snapshot getSnapshot() {
            return this.zzb;
        }

        @Override
        public final String getConflictId() {
            return this.zzc;
        }

        @Override
        public final Snapshot getConflictingSnapshot() {
            return this.zzd;
        }

        @Override
        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzf;
        }
    }

    static final class zzax
    extends zzw
    implements Snapshots.LoadSnapshotsResult {
        zzax(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zza);
        }
    }

    static final class zzas
    extends zzw
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzb;

        zzas(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzb = playerStatsBuffer.getCount() > 0 ? new com.google.android.gms.games.stats.zza((PlayerStats)playerStatsBuffer.get(0)) : null;
                return;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public final PlayerStats getPlayerStats() {
            return this.zzb;
        }
    }

    static final class zzp
    extends zzw
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzb;
        private final Quest zzc;

        zzp(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzc = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzc.zza();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzb = list.get(i);
                        return;
                    }
                    this.zzb = null;
                } else {
                    this.zzb = null;
                    this.zzc = null;
                }
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Milestone getMilestone() {
            return this.zzb;
        }

        @Override
        public final Quest getQuest() {
            return this.zzc;
        }
    }

    static final class zzd
    extends zzw
    implements Quests.AcceptQuestResult {
        private final Quest zzb;

        zzd(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzb = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Quest getQuest() {
            return this.zzb;
        }
    }

    static final class zzau
    extends zzw
    implements Quests.LoadQuestsResult {
        private final DataHolder zzb;

        zzau(DataHolder dataHolder) {
            super(dataHolder);
            this.zzb = dataHolder;
        }

        @Override
        public final QuestBuffer getQuests() {
            return new QuestBuffer(this.zzb);
        }
    }

    static final class zzav
    implements Requests.LoadRequestsResult {
        private final Status zza;
        private final Bundle zzb;

        zzav(Status status, Bundle bundle) {
            this.zza = status;
            this.zzb = bundle;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final GameRequestBuffer getRequests(int n) {
            String string;
            switch (n) {
                case 1: {
                    String string2 = "GIFT";
                    break;
                }
                case 2: {
                    String string2 = "WISH";
                    break;
                }
                default: {
                    com.google.android.gms.games.internal.zzf.zzb("RequestType", new StringBuilder(33).append("Unknown request type: ").append(n).toString());
                    String string2 = string = "UNKNOWN_TYPE";
                }
            }
            if (!this.zzb.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzb.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public final void release() {
            for (String string : this.zzb.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzb.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    static final class zzcw
    extends zzw
    implements Requests.UpdateRequestsResult {
        private final zzccw zzb;

        zzcw(DataHolder dataHolder) {
            super(dataHolder);
            this.zzb = zzccw.zza(dataHolder);
        }

        @Override
        public final int getRequestOutcome(String string) {
            return this.zzb.zza(string);
        }

        @Override
        public final Set<String> getRequestIds() {
            return this.zzb.zza();
        }
    }

    static final class zzz
    implements Games.GetServerAuthCodeResult {
        private final Status zza;
        private final String zzb;

        zzz(Status status, String string) {
            this.zza = status;
            this.zzb = string;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final String getCode() {
            return this.zzb;
        }
    }

    static final class zzg
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zza;
        private final String zzb;

        zzg(Status status, String string) {
            this.zza = status;
            this.zzb = string;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final String getMatchId() {
            return this.zzb;
        }
    }

    static final class zzaj
    extends zzcr
    implements TurnBasedMultiplayer.LeaveMatchResult {
        zzaj(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzcv
    extends zzcr
    implements TurnBasedMultiplayer.UpdateMatchResult {
        zzcv(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzaa
    extends zzcr
    implements TurnBasedMultiplayer.InitiateMatchResult {
        zzaa(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzap
    extends zzcr
    implements TurnBasedMultiplayer.LoadMatchResult {
        zzap(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static abstract class zzcr
    extends zzw {
        private TurnBasedMatch zzb;

        zzcr(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzb = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzb;
        }
    }

    static final class zzcm
    extends zzw
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzb;

        public zzcm(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzb = new ScoreSubmissionData(dataHolder);
                return;
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public final ScoreSubmissionData getScoreData() {
            return this.zzb;
        }
    }

    static final class zzat
    extends zzw
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzb;

        zzat(DataHolder dataHolder) {
            super(dataHolder);
            this.zzb = new PlayerBuffer(dataHolder);
        }

        @Override
        public final PlayerBuffer getPlayers() {
            return this.zzb;
        }
    }

    static final class zzaq
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zza;
        private final LoadMatchesResponse zzb;

        zzaq(Status status, Bundle bundle) {
            this.zza = status;
            this.zzb = new LoadMatchesResponse(bundle);
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final LoadMatchesResponse getMatches() {
            return this.zzb;
        }

        public final void release() {
            this.zzb.release();
        }
    }

    static final class zzao
    extends zzw
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzb;

        zzao(DataHolder dataHolder) {
            super(dataHolder);
            this.zzb = new InvitationBuffer(dataHolder);
        }

        @Override
        public final InvitationBuffer getInvitations() {
            return this.zzb;
        }
    }

    static final class zzar
    extends zzw
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzb;

        zzar(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzb = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public final LeaderboardScore getScore() {
            return this.zzb;
        }
    }

    static final class zzaw
    extends zzw
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzb;
        private final LeaderboardScoreBuffer zzc;

        zzaw(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzb = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzc = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public final Leaderboard getLeaderboard() {
            return this.zzb;
        }

        @Override
        public final LeaderboardScoreBuffer getScores() {
            return this.zzc;
        }
    }

    static final class zzag
    extends zzw
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzb;

        zzag(DataHolder dataHolder) {
            super(dataHolder);
            this.zzb = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public final LeaderboardBuffer getLeaderboards() {
            return this.zzb;
        }
    }

    static final class zzan
    extends zzw
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzb;

        zzan(DataHolder dataHolder) {
            super(dataHolder);
            this.zzb = new GameBuffer(dataHolder);
        }

        @Override
        public final GameBuffer getGames() {
            return this.zzb;
        }
    }

    static final class zzam
    extends zzw
    implements Events.LoadEventsResult {
        private final EventBuffer zzb;

        zzam(DataHolder dataHolder) {
            super(dataHolder);
            this.zzb = new EventBuffer(dataHolder);
        }

        @Override
        public final EventBuffer getEvents() {
            return this.zzb;
        }
    }

    static final class zzcu
    implements Achievements.UpdateAchievementResult {
        private final Status zza;
        private final String zzb;

        zzcu(int n, String string) {
            this.zza = GamesStatusCodes.zza(n);
            this.zzb = string;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final String getAchievementId() {
            return this.zzb;
        }
    }

    static final class zzal
    extends zzw
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzb;

        zzal(DataHolder dataHolder) {
            super(dataHolder);
            this.zzb = new AchievementBuffer(dataHolder);
        }

        @Override
        public final AchievementBuffer getAchievements() {
            return this.zzb;
        }
    }

    static abstract class zzw
    extends com.google.android.gms.common.api.internal.zzaj {
        protected zzw(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zza(dataHolder.zzb()));
        }
    }

    static final class zzbu
    implements com.google.android.gms.common.api.internal.zzcl<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zza;
        private final String zzb;
        private final int zzc;

        zzbu(int n, int n2, String string) {
            this.zza = n;
            this.zzc = n2;
            this.zzb = string;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback = (RealTimeMultiplayer.ReliableMessageSentCallback)object;
            zzbu zzbu2 = this;
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(zzbu2.zza, zzbu2.zzc, zzbu2.zzb);
            }
        }
    }

    static final class zzbb
    implements com.google.android.gms.common.api.internal.zzcl<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zza;

        zzbb(RealTimeMessage realTimeMessage) {
            this.zza = realTimeMessage;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            RealTimeMessageReceivedListener realTimeMessageReceivedListener = (RealTimeMessageReceivedListener)object;
            zzbb zzbb2 = this;
            realTimeMessageReceivedListener.onRealTimeMessageReceived(zzbb2.zza);
        }
    }

    static final class zzbe
    implements com.google.android.gms.common.api.internal.zzcl<RoomStatusUpdateListener> {
        private final String zza;

        zzbe(String string) {
            this.zza = string;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbe zzbe2 = this;
            roomStatusUpdateListener.onP2PDisconnected(zzbe2.zza);
        }
    }

    static final class zzbd
    implements com.google.android.gms.common.api.internal.zzcl<RoomStatusUpdateListener> {
        private final String zza;

        zzbd(String string) {
            this.zza = string;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbd zzbd2 = this;
            roomStatusUpdateListener.onP2PConnected(zzbd2.zza);
        }
    }

    static final class zzbh
    extends zza {
        zzbh(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    static final class zzbf
    extends zza {
        zzbf(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    static final class zzbg
    extends zza {
        zzbg(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    static final class zzbk
    extends zza {
        zzbk(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    static final class zzbj
    extends zza {
        zzbj(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    static final class zzbi
    extends zza {
        zzbi(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    static final class zzt
    extends zzc {
        zzt(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    static final class zzr
    extends zzc {
        zzr(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    static final class zzcb
    extends zzc {
        zzcb(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    static final class zzce
    extends zzc {
        zzce(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    static final class zzcd
    extends zzb {
        zzcd(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    static final class zzak
    implements com.google.android.gms.common.api.internal.zzcl<RoomUpdateListener> {
        private final int zza;
        private final String zzb;

        zzak(int n, String string) {
            this.zza = n;
            this.zzb = string;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            zzak zzak2 = this;
            roomUpdateListener.onLeftRoom(zzak2.zza, zzak2.zzb);
        }
    }

    static final class zzaf
    extends zzb {
        public zzaf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    static final class zzcf
    extends zzb {
        public zzcf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    static abstract class zza
    extends zzc {
        private final ArrayList<String> zza = new ArrayList();

        zza(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zza.add(stringArray[i]);
            }
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zza);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    static abstract class zzc
    extends com.google.android.gms.common.api.internal.zzai<RoomStatusUpdateListener> {
        zzc(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzb(dataHolder2));
        }
    }

    static abstract class zzb
    extends com.google.android.gms.common.api.internal.zzai<RoomUpdateListener> {
        zzb(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            this.zza(roomUpdateListener, GamesClientImpl.zzb(dataHolder2), dataHolder2.zzb());
        }
    }

    static final class zzby
    implements com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> {
        private final String zza;

        zzby(String string) {
            this.zza = string;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzby zzby2 = this;
            onRequestReceivedListener.onRequestRemoved(zzby2.zza);
        }
    }

    static final class zzbx
    implements com.google.android.gms.common.api.internal.zzcl<OnRequestReceivedListener> {
        private final GameRequest zza;

        zzbx(GameRequest gameRequest) {
            this.zza = gameRequest;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzbx zzbx2 = this;
            onRequestReceivedListener.onRequestReceived(zzbx2.zza);
        }
    }

    static final class zzbq
    implements com.google.android.gms.common.api.internal.zzcl<QuestUpdateListener> {
        private final Quest zza;

        zzbq(Quest quest) {
            this.zza = quest;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            QuestUpdateListener questUpdateListener = (QuestUpdateListener)object;
            zzbq zzbq2 = this;
            questUpdateListener.onQuestCompleted(zzbq2.zza);
        }
    }

    static final class zzay
    implements com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zza;

        zzay(String string) {
            this.zza = string;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzay zzay2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(zzay2.zza);
        }
    }

    static final class zzba
    implements com.google.android.gms.common.api.internal.zzcl<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zza;

        zzba(TurnBasedMatch turnBasedMatch) {
            this.zza = turnBasedMatch;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzba zzba2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(zzba2.zza);
        }
    }

    static final class zzad
    implements com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> {
        private final String zza;

        zzad(String string) {
            this.zza = string;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzad zzad2 = this;
            onInvitationReceivedListener.onInvitationRemoved(zzad2.zza);
        }
    }

    static final class zzac
    implements com.google.android.gms.common.api.internal.zzcl<OnInvitationReceivedListener> {
        private final Invitation zza;

        zzac(Invitation invitation) {
            this.zza = invitation;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzac zzac2 = this;
            onInvitationReceivedListener.onInvitationReceived(zzac2.zza);
        }
    }

    static final class zzm
    implements com.google.android.gms.common.api.internal.zzcl<Videos.CaptureOverlayStateListener> {
        private final int zza;

        zzm(int n) {
            this.zza = n;
        }

        public final void zza() {
        }

        public final /* synthetic */ void zza(Object object) {
            Videos.CaptureOverlayStateListener captureOverlayStateListener = (Videos.CaptureOverlayStateListener)object;
            zzm zzm2 = this;
            captureOverlayStateListener.onCaptureOverlayStateChanged(zzm2.zza);
        }
    }

    static final class zzn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zza;

        public zzn(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(int n, Bundle bundle) {
            this.zza.zza((Object)new zzo(new Status(n), CaptureState.zza(bundle)));
        }
    }

    static final class zzl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zza;

        zzl(com.google.android.gms.common.api.internal.zzci<Videos.CaptureOverlayStateListener> zzci2) {
            this.zza = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.zza(zzci2, (Object)"Callback must not be null");
        }

        @Override
        public final void zzk(int n) {
            this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzm(n));
        }
    }

    static final class zzj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zza;

        zzj(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, VideoCapabilities videoCapabilities) {
            this.zza.zza((Object)new zzk(new Status(n), videoCapabilities));
        }
    }

    static final class zzh
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zza;

        zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, boolean bl) {
            this.zza.zza((Object)new zzi(new Status(n), bl));
        }
    }

    static final class zzci
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zza;

        public zzci(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zze(int n, String string) {
            this.zza.zza((Object)new zzs(n, string));
        }
    }

    static final class zzch
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zza;

        public zzch(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzah(DataHolder dataHolder) {
            this.zza.zza((Object)new zzq(dataHolder));
        }
    }

    static final class zzcj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zza;

        public zzcj(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zza.zza((Object)new zzbc(dataHolder, zzc2));
        }

        @Override
        public final void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zza.zza((Object)new zzbc(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    static final class zzck
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zza;

        public zzck(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzag(DataHolder dataHolder) {
            this.zza.zza((Object)new zzax(dataHolder));
        }
    }

    static final class zzbm
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zza;

        public zzbm(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzap(DataHolder dataHolder) {
            this.zza.zza((Object)new zzas(dataHolder));
        }
    }

    static final class zzbt
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zza;

        public zzbt(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzam(DataHolder dataHolder) {
            this.zza.zza((Object)new zzau(dataHolder));
        }
    }

    static final class zzbr
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zza;
        private final String zzb;

        public zzbr(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
            this.zzb = (String)com.google.android.gms.common.internal.zzbq.zza((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public final void zzai(DataHolder dataHolder) {
            this.zza.zza((Object)new zzp(dataHolder, this.zzb));
        }
    }

    static final class zzbp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zza;

        public zzbp(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzaj(DataHolder dataHolder) {
            this.zza.zza((Object)new zzd(dataHolder));
        }
    }

    static final class zzbz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zza;

        public zzbz(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zza(n);
            this.zza.zza((Object)new zzav(status, bundle));
        }
    }

    static final class zzca
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zza;

        public zzca(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzad(DataHolder dataHolder) {
            this.zza.zza((Object)new zzcw(dataHolder));
        }
    }

    static final class zzbo
    extends com.google.android.gms.games.internal.zzb {
        private final com.google.android.gms.games.internal.zzaa zza;

        public zzbo(com.google.android.gms.games.internal.zzaa zzaa2) {
            this.zza = zzaa2;
        }

        @Override
        public final com.google.android.gms.games.internal.zzy zza() {
            return new com.google.android.gms.games.internal.zzy(this.zza.zzb);
        }
    }

    static final class zzy
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zza;

        public zzy(com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, String string) {
            Status status = GamesStatusCodes.zza(n);
            this.zza.zza((Object)new zzz(status, string));
        }
    }

    static final class zzcg
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Status> zza;

        public zzcg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza() {
            Status status = GamesStatusCodes.zza(0);
            this.zza.zza((Object)status);
        }
    }

    static final class zzbv
    extends com.google.android.gms.games.internal.zza {
        private com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zza;

        public zzbv(com.google.android.gms.common.api.internal.zzci<RealTimeMultiplayer.ReliableMessageSentCallback> zzci2) {
            this.zza = zzci2;
        }

        @Override
        public final void zza(int n, int n2, String string) {
            if (this.zza != null) {
                this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzbu(n, n2, string));
            }
        }
    }

    static final class zzcc
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zza;
        private final com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzb;
        private final com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzc;

        public zzcc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2) {
            this.zza = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.zza(zzci2, (Object)"Callbacks must not be null");
            this.zzb = null;
            this.zzc = null;
        }

        public zzcc(com.google.android.gms.common.api.internal.zzci<? extends RoomUpdateListener> zzci2, com.google.android.gms.common.api.internal.zzci<? extends RoomStatusUpdateListener> zzci3, com.google.android.gms.common.api.internal.zzci<? extends RealTimeMessageReceivedListener> zzci4) {
            this.zza = (com.google.android.gms.common.api.internal.zzci)com.google.android.gms.common.internal.zzbq.zza(zzci2, (Object)"Callbacks must not be null");
            this.zzb = zzci3;
            this.zzc = zzci4;
        }

        @Override
        public final void zzs(DataHolder dataHolder) {
            this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzcf(dataHolder));
        }

        @Override
        public final void zzt(DataHolder dataHolder) {
            this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzaf(dataHolder));
        }

        @Override
        public final void zza(int n, String string) {
            this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzak(n, string));
        }

        @Override
        public final void zzw(DataHolder dataHolder) {
            this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzcd(dataHolder));
        }

        @Override
        public final void zzu(DataHolder dataHolder) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzce(dataHolder));
            }
        }

        @Override
        public final void zzv(DataHolder dataHolder) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzcb(dataHolder));
            }
        }

        @Override
        public final void zzx(DataHolder dataHolder) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzr(dataHolder));
            }
        }

        @Override
        public final void zzy(DataHolder dataHolder) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzt(dataHolder));
            }
        }

        @Override
        public final void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzbf(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzbh(dataHolder, stringArray));
            }
        }

        @Override
        public final void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzbi(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzbj(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzbk(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzbg(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(String string) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzbd(string));
            }
        }

        @Override
        public final void zze(String string) {
            if (this.zzb != null) {
                this.zzb.zza((com.google.android.gms.common.api.internal.zzcl)new zzbe(string));
            }
        }

        @Override
        public final void zza(RealTimeMessage realTimeMessage) {
            if (this.zzc != null) {
                this.zzc.zza((com.google.android.gms.common.api.internal.zzcl)new zzbb(realTimeMessage));
            }
        }
    }

    static final class zzcn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zza;

        public zzcn(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzd(int n, String string) {
            Status status = GamesStatusCodes.zza(n);
            this.zza.zza((Object)new zzg(status, string));
        }
    }

    static final class zzcp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zza;

        public zzcp(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzq(DataHolder dataHolder) {
            this.zza.zza((Object)new zzaj(dataHolder));
        }
    }

    static final class zzcs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zza;

        public zzcs(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzp(DataHolder dataHolder) {
            this.zza.zza((Object)new zzcv(dataHolder));
        }
    }

    static final class zzco
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zza;

        public zzco(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzo(DataHolder dataHolder) {
            this.zza.zza((Object)new zzaa(dataHolder));
        }
    }

    static final class zzcq
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zza;

        public zzcq(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzn(DataHolder dataHolder) {
            this.zza.zza((Object)new zzap(dataHolder));
        }
    }

    static final class zzct
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zza;

        public zzct(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zza(n);
            this.zza.zza((Object)new zzaq(status, bundle));
        }
    }

    static final class zzcl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zza;

        public zzcl(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzd(DataHolder dataHolder) {
            this.zza.zza((Object)new zzcm(dataHolder));
        }
    }

    static final class zzbn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zza;

        zzbn(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zze(DataHolder dataHolder) {
            this.zza.zza((Object)new zzat(dataHolder));
        }

        @Override
        public final void zzf(DataHolder dataHolder) {
            this.zza.zza((Object)new zzat(dataHolder));
        }
    }

    static final class zzbw
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zza;

        zzbw(com.google.android.gms.common.api.internal.zzci<OnRequestReceivedListener> zzci2) {
            this.zza = zzci2;
        }

        @Override
        public final void zzm(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzbx(gameRequest));
            }
        }

        @Override
        public final void zzb(String string) {
            this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzby(string));
        }
    }

    static final class zzbs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zza;

        zzbs(com.google.android.gms.common.api.internal.zzci<QuestUpdateListener> zzci2) {
            this.zza = zzci2;
        }

        @Override
        public final void zzak(DataHolder dataHolder) {
            Quest quest = zzbs.zzbb(dataHolder);
            if (quest != null) {
                this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzbq(quest));
            }
        }

        private static Quest zzbb(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    static final class zzaz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zza;

        zzaz(com.google.android.gms.common.api.internal.zzci<OnTurnBasedMatchUpdateReceivedListener> zzci2) {
            this.zza = zzci2;
        }

        @Override
        public final void zzr(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzba(turnBasedMatch));
            }
        }

        @Override
        public final void zzc(String string) {
            this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzay(string));
        }
    }

    static final class zzab
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zza;

        zzab(com.google.android.gms.common.api.internal.zzci<OnInvitationReceivedListener> zzci2) {
            this.zza = zzci2;
        }

        @Override
        public final void zzl(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzac(invitation));
            }
        }

        @Override
        public final void zza(String string) {
            this.zza.zza((com.google.android.gms.common.api.internal.zzcl)new zzad(string));
        }
    }

    static final class zzae
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zza;

        zzae(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzk(DataHolder dataHolder) {
            this.zza.zza((Object)new zzao(dataHolder));
        }
    }

    static final class zzbl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zza;

        zzbl(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzac(DataHolder dataHolder) {
            this.zza.zza((Object)new zzar(dataHolder));
        }
    }

    static final class zzah
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zza;

        zzah(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zza.zza((Object)new zzaw(dataHolder, dataHolder2));
        }
    }

    static final class zzai
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zza;

        zzai(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(DataHolder dataHolder) {
            this.zza.zza((Object)new zzag(dataHolder));
        }
    }

    static final class zzu
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zza;

        zzu(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(DataHolder dataHolder) {
            this.zza.zza((Object)new zzam(dataHolder));
        }
    }

    static final class zzx
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zza;

        zzx(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(DataHolder dataHolder) {
            this.zza.zza((Object)new zzan(dataHolder));
        }
    }

    static final class zze
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zza;

        zze(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(int n, String string) {
            this.zza.zza((Object)new zzcu(n, string));
        }
    }

    static final class zzf
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zza;

        zzf(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2) {
            this.zza = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbq.zza(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder) {
            this.zza.zza((Object)new zzal(dataHolder));
        }
    }

    final class zzv
    extends zzcct {
        private /* synthetic */ GamesClientImpl zza;

        public zzv(GamesClientImpl gamesClientImpl) {
            this.zza = gamesClientImpl;
            super(gamesClientImpl.zzaa().getMainLooper(), 1000);
        }

        @Override
        protected final void zza(String string, int n) {
            try {
                if (this.zza.zzs()) {
                    ((com.google.android.gms.games.internal.zzw)this.zza.zzaf()).zzc(string, n);
                    return;
                }
                com.google.android.gms.games.internal.zzf.zzb("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zza(remoteException);
                return;
            }
            catch (SecurityException securityException) {
                GamesClientImpl.zza(securityException);
                return;
            }
        }
    }
}

