/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

@Hide
public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zza;
    private final String zzb;
    private final String zzc;
    private final long zzd;
    private final long zze;
    private final String zzf;
    private final Uri zzg;
    private final Uri zzh;
    private final PlayerEntity zzi;
    private final String zzj;
    private final String zzk;
    private final String zzl;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zza = leaderboardScore.getRank();
        this.zzb = (String)zzbq.zza((Object)leaderboardScore.getDisplayRank());
        this.zzc = (String)zzbq.zza((Object)leaderboardScore.getDisplayScore());
        this.zzd = leaderboardScore.getRawScore();
        this.zze = leaderboardScore.getTimestampMillis();
        this.zzf = leaderboardScore.getScoreHolderDisplayName();
        this.zzg = leaderboardScore.getScoreHolderIconImageUri();
        this.zzh = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzi = player == null ? null : (PlayerEntity)player.freeze();
        this.zzj = leaderboardScore.getScoreTag();
        this.zzk = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzl = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zza;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzb;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzh.zza((String)this.zzb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zzc;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzh.zza((String)this.zzc, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzd;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zze;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzi == null) {
            return this.zzf;
        }
        return this.zzi.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzi == null) {
            com.google.android.gms.common.util.zzh.zza((String)this.zzf, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzi.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzi == null) {
            return this.zzg;
        }
        return this.zzi.getIconImageUri();
    }

    @Override
    @Hide
    public final String getScoreHolderIconImageUrl() {
        if (this.zzi == null) {
            return this.zzk;
        }
        return this.zzi.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzi == null) {
            return this.zzh;
        }
        return this.zzi.getHiResImageUri();
    }

    @Override
    @Hide
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzi == null) {
            return this.zzl;
        }
        return this.zzi.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zzi;
    }

    @Override
    public final String getScoreTag() {
        return this.zzj;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbg.zza((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbg.zza((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbg.zza((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbg.zza((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbg.zza((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbg.zza((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbg.zza((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbg.zza((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbg.zza((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbg.zza((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbg.zza((Object)leaderboardScore).zza("Rank", (Object)leaderboardScore.getRank()).zza("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zza("Score", (Object)leaderboardScore.getRawScore()).zza("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zza("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zza("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zza("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zza("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zza("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zza("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zza("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zza("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

